/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model.codec;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.model.DefaultDockingPathModel;
import com.javadocking.model.DockModel;
import com.javadocking.model.codec.DockModelDecoder;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import java.awt.Window;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DockModelPropertiesDecoder
implements DockModelDecoder {
    private static final String VERSION = "1.1";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_CLASS = "dockModelClass";

    public boolean canDecodeSource(String sourceName) {
        return sourceName.endsWith("dck");
    }

    public DockModel decode(String sourceName, Map dockablesMap, Map ownersMap, Map visualizersMap) throws IOException {
        Properties properties = PropertiesUtil.loadProperties(sourceName);
        String version = null;
        if (!VERSION.equals(version = PropertiesUtil.getString(properties, PROPERTY_VERSION, version))) {
            throw new IOException("Unsupported version [" + version + "].");
        }
        DockModel dockModel = this.createDockModel(properties);
        DockingManager.setDockModel(dockModel);
        HashMap docks = new HashMap();
        dockModel.loadProperties(sourceName, "dockModel.", properties, dockablesMap, ownersMap, docks, visualizersMap);
        DefaultDockingPathModel dockingPathModel = new DefaultDockingPathModel();
        dockingPathModel.loadProperties("dockingPathModel.", properties, docks);
        DockingManager.setDockingPathModel(dockingPathModel);
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator rootDockKeys = dockModel.getRootKeys(owner);
            while (rootDockKeys.hasNext()) {
                String rootDockKey = (String)rootDockKeys.next();
                Dock rootDock = dockModel.getRootDock(rootDockKey);
                if (!(rootDock instanceof CompositeDock)) continue;
                DockingUtil.removeEmptyChildren((CompositeDock)rootDock);
            }
        }
        return dockModel;
    }

    private DockModel createDockModel(Properties properties) throws IOException {
        String className = null;
        className = PropertiesUtil.getString(properties, PROPERTY_CLASS, className);
        Class<?> clazz = null;
        DockModel dockModel = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not find class [" + className + "] (ClassNotFoundException).");
        }
        try {
            dockModel = (DockModel)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Illegal acces to class [" + className + "] (IllegalAccessException).");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Could not instantiate class [" + className + "] (InstantiationException).");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class [" + className + "] is not a Dock. (ClassCastException).");
        }
        return dockModel;
    }
}

