/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model.codec;

import com.javadocking.DockingManager;
import com.javadocking.model.DockModel;
import com.javadocking.model.DockingPathModel;
import com.javadocking.model.codec.DockModelEncoder;
import com.javadocking.util.PropertiesUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class DockModelPropertiesEncoder
implements DockModelEncoder {
    public static final String EXTENSION = "dck";
    private static final String PROPERTY_CLASS = "dockModelClass";
    private static final String PROPERTY_VERSION = "version";
    private static final String VERSION = "1.1";
    private static final String COMMENT = "Properties for a com.javadocking.model.DockModel generated by DockModelPropertiesEncoder";

    public boolean canExport(DockModel dockModel, String destinationName) {
        return destinationName.endsWith(EXTENSION);
    }

    public boolean canSave(DockModel dockModel) {
        return true;
    }

    public void export(DockModel dockModel, String destinationName) throws IOException, IllegalArgumentException {
        if (!this.canExport(dockModel, destinationName)) {
            throw new IllegalArgumentException("This dock model cannot be saved.");
        }
        Properties properties = this.saveProperties(dockModel);
        PropertiesUtil.saveProperties(properties, destinationName, COMMENT);
    }

    public void save(DockModel dockModel) throws IOException, IllegalArgumentException {
        if (dockModel.getSource() == null) {
            throw new IOException("The source path is null.");
        }
        this.export(dockModel, dockModel.getSource());
    }

    private Properties saveProperties(DockModel dockModel) {
        Properties properties = new Properties();
        PropertiesUtil.setString(properties, PROPERTY_VERSION, VERSION);
        PropertiesUtil.setString(properties, PROPERTY_CLASS, dockModel.getClass().getName());
        HashMap dockKeys = new HashMap();
        dockModel.saveProperties("dockModel.", properties, dockKeys);
        DockingPathModel dockingPathModel = DockingManager.getDockingPathModel();
        if (dockingPathModel != null) {
            dockingPathModel.saveProperties("dockingPathModel.", properties, dockKeys);
        }
        return properties;
    }
}

