/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.util;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.model.DockModel;
import com.javadocking.visualizer.Visualizer;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DockingUtil {
    public static boolean contains(LeafDock leafDock, Dockable dockabe) {
        if (dockabe instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockabe;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (!DockingUtil.contains(leafDock, compositeDockable.getDockable(index))) continue;
                return true;
            }
            return false;
        }
        for (int index = 0; index < leafDock.getDockableCount(); ++index) {
            if (!leafDock.getDockable(index).equals(dockabe)) continue;
            return true;
        }
        return false;
    }

    public static String getFloatRootDockKey(Window owner) {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        Iterator rootDockKeyIterator = dockModel.getRootKeys(owner);
        while (rootDockKeyIterator.hasNext()) {
            String rootDockKey = (String)rootDockKeyIterator.next();
            Dock rootDock = dockModel.getRootDock(rootDockKey);
            if (!(rootDock instanceof FloatDock)) continue;
            return rootDockKey;
        }
        return null;
    }

    public static Dockable retrieveDockableOfDockModel(String dockableID) {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator rootKeys = dockModel.getRootKeys(owner);
            while (rootKeys.hasNext()) {
                String rootKey = (String)rootKeys.next();
                Dock rootDock = dockModel.getRootDock(rootKey);
                ArrayList dockablesOfTree = new ArrayList();
                DockingUtil.retrieveDockables(rootDock, dockablesOfTree);
                Iterator dockableIterator = dockablesOfTree.iterator();
                while (dockableIterator.hasNext()) {
                    Dockable dockableOfTree = (Dockable)dockableIterator.next();
                    if (!dockableOfTree.getID().equals(dockableID)) continue;
                    return dockableOfTree;
                }
            }
            Iterator visualizerKeys = dockModel.getVisualizerKeys(owner);
            while (visualizerKeys.hasNext()) {
                String visualizerKey = (String)visualizerKeys.next();
                Visualizer visualizer = dockModel.getVisualizer(visualizerKey);
                for (int dockableIndex = 0; dockableIndex < visualizer.getVisualizedDockableCount(); ++dockableIndex) {
                    Dockable dockableOfViualizer = visualizer.getVisualizedDockable(dockableIndex);
                    if (!dockableOfViualizer.getID().equals(dockableID)) continue;
                    return dockableOfViualizer;
                }
            }
        }
        return null;
    }

    public static void removeEmptyChildren(CompositeDock compositeDock) {
        int index;
        for (int index2 = 0; index2 < compositeDock.getChildDockCount(); ++index2) {
            Dock childDock = compositeDock.getChildDock(index2);
            if (!(childDock instanceof CompositeDock)) continue;
            DockingUtil.removeEmptyChildren((CompositeDock)childDock);
        }
        ArrayList<Dock> emptyChildDockList = new ArrayList<Dock>();
        for (index = 0; index < compositeDock.getChildDockCount(); ++index) {
            if (!compositeDock.getChildDock(index).isEmpty()) continue;
            emptyChildDockList.add(compositeDock.getChildDock(index));
        }
        for (index = 0; index < emptyChildDockList.size(); ++index) {
            compositeDock.emptyChild((Dock)emptyChildDockList.get(index));
        }
    }

    public static Dock searchDock(Dock rootDock, Dockable dockable) {
        int index;
        if (rootDock instanceof LeafDock) {
            LeafDock leafDock = (LeafDock)rootDock;
            for (index = 0; index < leafDock.getDockableCount(); ++index) {
                if (!dockable.equals(leafDock.getDockable(index))) continue;
                return leafDock;
            }
        }
        if (rootDock instanceof CompositeDock) {
            CompositeDock compositeDock = (CompositeDock)rootDock;
            for (index = 0; index < compositeDock.getChildDockCount(); ++index) {
                Dock searchedDock = DockingUtil.searchDock(compositeDock.getChildDock(index), dockable);
                if (searchedDock == null) continue;
                return searchedDock;
            }
        }
        return null;
    }

    public static void retrieveDockables(Dock rootDock, List dockables) {
        int index;
        if (rootDock instanceof LeafDock) {
            LeafDock leafDock = (LeafDock)rootDock;
            for (index = 0; index < leafDock.getDockableCount(); ++index) {
                dockables.add(leafDock.getDockable(index));
            }
        }
        if (rootDock instanceof CompositeDock) {
            CompositeDock compositeDock = (CompositeDock)rootDock;
            for (index = 0; index < compositeDock.getChildDockCount(); ++index) {
                DockingUtil.retrieveDockables(compositeDock.getChildDock(index), dockables);
            }
        }
    }

    public static void retrieveDockables(Dockable rootDockable, List dockables) {
        if (rootDockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)rootDockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                DockingUtil.retrieveDockables(compositeDockable.getDockable(index), dockables);
            }
        } else {
            dockables.add(rootDockable);
        }
    }

    public static Dock getRootDock(Dock dock) {
        CompositeDock parentDock = dock.getParentDock();
        if (parentDock == null) {
            return dock;
        }
        return DockingUtil.getRootDock(parentDock);
    }

    public static Dock getFloatChildDock(Dock dock) {
        if (dock == null) {
            return null;
        }
        CompositeDock parentDock = dock.getParentDock();
        if (parentDock == null) {
            return null;
        }
        if (parentDock instanceof FloatDock) {
            return dock;
        }
        return DockingUtil.getFloatChildDock(parentDock);
    }

    public static Dockable createDockable(Dock dock) {
        if (dock instanceof CompositeDock) {
            ArrayList dockablesList = new ArrayList();
            DockingUtil.retrieveDockables(dock, dockablesList);
            if (dockablesList.size() == 0) {
                return null;
            }
            Dockable[] dockables = new Dockable[dockablesList.size()];
            dockablesList.toArray(dockables);
            DefaultCompositeDockable compositeDockable = new DefaultCompositeDockable(dockables);
            LeafDock parent = null;
            if (dockables.length > 0 && dockables[0].getDock() != null) {
                parent = dockables[0].getDock();
                for (int index = 1; index < dockables.length; ++index) {
                    if (parent.equals(dockables[index].getDock())) continue;
                    parent = null;
                    break;
                }
            }
            compositeDockable.setState(1, parent);
            return compositeDockable;
        }
        if (dock instanceof LeafDock) {
            LeafDock leafDock = (LeafDock)dock;
            int childCount = leafDock.getDockableCount();
            if (childCount == 0) {
                return null;
            }
            if (childCount == 1) {
                return leafDock.getDockable(0);
            }
            Dockable[] dockables = new Dockable[childCount];
            for (int index = 0; index < childCount; ++index) {
                dockables[index] = leafDock.getDockable(index);
            }
            DefaultCompositeDockable compositeDockable = new DefaultCompositeDockable(dockables);
            compositeDockable.setDock(leafDock);
            return compositeDockable;
        }
        return null;
    }

    public static Dimension getDockablePreferredSize(Dockable dockable, int dockingMode) {
        Dimension size = null;
        if (dockable.getContent() != null) {
            size = dockable.getContent().getPreferredSize();
        } else if (dockable instanceof CompositeDockable) {
            size = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 16);
        }
        return size;
    }

    public static Dimension getCompositeDockablePreferredSize(CompositeDockable compositeDockable, int dockingMode) {
        if (dockingMode == 16) {
            Dimension unionSize = new Dimension(0, 0);
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dimension childSize = compositeDockable.getDockable(index).getContent().getPreferredSize();
                unionSize.setSize(Math.max(unionSize.width, childSize.width), Math.max(unionSize.height, childSize.height));
            }
            return unionSize;
        }
        if (dockingMode == 256) {
            Dimension unionSize = new Dimension(0, 0);
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dimension childSize = compositeDockable.getDockable(index).getContent().getPreferredSize();
                unionSize.setSize(unionSize.width + childSize.width, Math.max(unionSize.height, childSize.height));
            }
            return unionSize;
        }
        if (dockingMode == 512) {
            Dimension unionSize = new Dimension(0, 0);
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dimension childSize = compositeDockable.getDockable(index).getContent().getPreferredSize();
                unionSize.setSize(Math.max(unionSize.width, childSize.width), unionSize.height + childSize.height);
            }
            return unionSize;
        }
        if (dockingMode == 1024) {
            int columnCount = (int)Math.ceil(Math.sqrt(compositeDockable.getDockableCount()));
            if (columnCount <= 0) {
                columnCount = 1;
            }
            Dimension unionSize = new Dimension(0, 0);
            Dimension lineUnionSize = new Dimension(0, 0);
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                if (index % columnCount == 0) {
                    unionSize.setSize(Math.max(unionSize.width, lineUnionSize.width), unionSize.height + lineUnionSize.height);
                    lineUnionSize = new Dimension(0, 0);
                }
                Dimension childSize = compositeDockable.getDockable(index).getContent().getPreferredSize();
                lineUnionSize.setSize(lineUnionSize.width + childSize.width, Math.max(lineUnionSize.height, childSize.height));
            }
            unionSize.setSize(Math.max(unionSize.width, lineUnionSize.width), unionSize.height + lineUnionSize.height);
            return unionSize;
        }
        throw new IllegalArgumentException("The docking mode [" + dockingMode + "] is not allowed.");
    }

    public static String getRootDockKey(Dock rootDock) {
        if (rootDock.getParentDock() != null) {
            throw new IllegalArgumentException("The dock is not a root dock. It's parent is not null.");
        }
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator rootDockKeyIterator = dockModel.getRootKeys(owner);
            while (rootDockKeyIterator.hasNext()) {
                String key = (String)rootDockKeyIterator.next();
                Dock rootDockForKey = dockModel.getRootDock(key);
                if (!rootDockForKey.equals(rootDock)) continue;
                return key;
            }
        }
        return null;
    }

    public static Window getWindowOwner(String rootDockKey) {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        for (int index = 0; index < dockModel.getOwnerCount(); ++index) {
            Window owner = dockModel.getOwner(index);
            Iterator rootDockKeyIterator = dockModel.getRootKeys(owner);
            while (rootDockKeyIterator.hasNext()) {
                if (!rootDockKeyIterator.next().equals(rootDockKey)) continue;
                return owner;
            }
        }
        return null;
    }

    public static boolean containsDock(Dock rootDock, Dock dock) {
        if (rootDock instanceof LeafDock && rootDock.equals(dock)) {
            return true;
        }
        if (rootDock instanceof CompositeDock) {
            if (rootDock.equals(dock)) {
                return true;
            }
            CompositeDock compositeDock = (CompositeDock)rootDock;
            for (int index = 0; index < compositeDock.getChildDockCount(); ++index) {
                boolean found = DockingUtil.containsDock(compositeDock.getChildDock(index), dock);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    private DockingUtil() {
    }
}

