/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.util;

public class JvmVersionUtil {
    public static final int VERSION_3_OR_LESS = 3;
    public static final int VERSION_4_or_5 = 4;
    public static final int VERSION_6_OR_MORE = 6;
    private static final float VERSION_4 = 1.4f;
    private static final float VERSION_6 = 1.6f;

    public static int getVersion() {
        String jVersion = System.getProperty("java.version");
        int pointPosition = jVersion.indexOf(".");
        if (pointPosition > 0 && jVersion.length() >= pointPosition + 2) {
            String version = jVersion.substring(0, pointPosition + 2);
            try {
                float versionNumber = Float.parseFloat(version);
                if (versionNumber < 1.4f) {
                    return 3;
                }
                if (versionNumber < 1.6f) {
                    return 4;
                }
                return 6;
            }
            catch (NumberFormatException exception) {
                throw new IllegalStateException("Unknown java version [" + jVersion + "].");
            }
        }
        throw new IllegalStateException("Unknown java version [" + jVersion + "].");
    }

    private JvmVersionUtil() {
    }
}

