/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.util;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesUtil {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final char COMMA = ',';

    public static Properties loadProperties(String sourceName) throws IOException {
        Properties result = new Properties();
        FileInputStream inputStream = new FileInputStream(sourceName);
        result.load(inputStream);
        inputStream.close();
        return result;
    }

    public static void saveProperties(Properties properties, String destinationName, String comment) throws IOException {
        if (properties == null) {
            throw new NullPointerException("Properties null.");
        }
        FileOutputStream outputStream = new FileOutputStream(destinationName);
        properties.store(outputStream, comment);
        outputStream.close();
    }

    public static boolean getBoolean(Properties properties, String name, boolean defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        stringValue = stringValue.trim();
        return stringValue.startsWith(TRUE);
    }

    public static void setBoolean(Properties properties, String name, boolean value) {
        properties.put(name, new Boolean(value).toString());
    }

    public static String getString(Properties properties, String name, String defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        return stringValue;
    }

    public static void setString(Properties properties, String name, String value) {
        if (value != null) {
            properties.put(name, value);
        }
    }

    public static int getInteger(Properties properties, String name, int defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        try {
            stringValue = stringValue.trim();
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static void setInteger(Properties properties, String name, int value) {
        properties.put(name, new Integer(value).toString());
    }

    public static double getDouble(Properties properties, String name, double defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        try {
            stringValue = stringValue.trim();
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static void setDouble(Properties properties, String name, double value) {
        properties.put(name, new Double(value).toString());
    }

    public static Color getColor(Properties properties, String name, Color defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        try {
            stringValue = stringValue.trim();
            StringTokenizer tokenizer = new StringTokenizer(stringValue, "[{(,/)}]");
            String red = tokenizer.nextToken();
            String green = tokenizer.nextToken();
            String blue = tokenizer.nextToken();
            int redValue = Integer.parseInt(red);
            int greenValue = Integer.parseInt(green);
            int blueValue = Integer.parseInt(blue);
            if (tokenizer.hasMoreTokens()) {
                String alfa = tokenizer.nextToken();
                int alfaValue = Integer.parseInt(alfa);
                return new Color(redValue, greenValue, blueValue, alfaValue);
            }
            return new Color(redValue, greenValue, blueValue);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static void setColor(Properties properties, String name, Color value) {
        if (value != null) {
            String colorString = "(" + value.getRed() + ',' + value.getGreen() + ',' + value.getBlue() + ',' + value.getAlpha() + ")";
            properties.put(name, colorString);
        }
    }

    public static String[] getStringArray(Properties properties, String name, String[] defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        stringValue = stringValue.trim();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, "(,)");
        ArrayList<Object> stringList = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            stringList.add(tokenizer.nextElement());
        }
        String[] stringArray = new String[stringList.size()];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = (String)stringList.get(index);
        }
        return stringArray;
    }

    public static void setStringArray(Properties properties, String name, String[] value) {
        if (value != null && value.length > 0) {
            StringBuffer totalString = new StringBuffer(value[0]);
            for (int index = 1; index < value.length; ++index) {
                totalString.append(',');
                totalString.append(value[index]);
            }
            properties.put(name, totalString.toString());
        }
    }

    public static int[] getIntegerArray(Properties properties, String name, int[] defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        stringValue = stringValue.trim();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, "[{(,/)}]");
        ArrayList<Object> intList = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            intList.add(tokenizer.nextElement());
        }
        int[] intArray = new int[intList.size()];
        for (int index = 0; index < intArray.length; ++index) {
            try {
                intArray[index] = Integer.parseInt((String)intList.get(index));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return intArray;
    }

    public static void setIntegerArray(Properties properties, String name, int[] value) {
        if (value != null && value.length > 0) {
            StringBuffer totalString = new StringBuffer();
            totalString.append(value[0]);
            for (int index = 1; index < value.length; ++index) {
                totalString.append(',');
                totalString.append(value[index]);
            }
            properties.put(name, totalString.toString());
        }
    }

    public static double[] getDoubleArray(Properties properties, String name, double[] defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        stringValue = stringValue.trim();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, "[{(,/)}]");
        ArrayList<Object> doubleList = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            doubleList.add(tokenizer.nextElement());
        }
        double[] doubleArray = new double[doubleList.size()];
        for (int index = 0; index < doubleArray.length; ++index) {
            try {
                doubleArray[index] = Integer.parseInt((String)doubleList.get(index));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return doubleArray;
    }

    public static void setDoubleArray(Properties properties, String name, double[] value) {
        if (value != null && value.length > 0) {
            StringBuffer totalString = new StringBuffer("" + value[0]);
            for (int index = 1; index < value.length; ++index) {
                totalString.append(',');
                totalString.append(value[index]);
            }
            properties.put(name, totalString.toString());
        }
    }

    private PropertiesUtil() {
    }
}

