/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.visualizer;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import com.javadocking.visualizer.ExternalizeDock;
import com.javadocking.visualizer.Externalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FloatExternalizer
implements Externalizer {
    private static final String EXTERNALIZE_DOCK_PREFIX = "externalizeDock";
    private List externalizeDocks = new LinkedList();
    private Map externalizeDockWindows = new HashMap();
    private Window owner;
    private WindowClosingListener windowClosingListener = new WindowClosingListener();
    private List windowFocusListeners = new ArrayList();
    private OwnerWindowListener ownerWindowListener = new OwnerWindowListener();

    public FloatExternalizer(Window owner) {
        this.setOwner(owner);
    }

    public void moveExternalizedDockable(Dockable dockable, Point position, Point dockableOffset) {
        if (dockable.getState() != 16) {
            throw new IllegalStateException("The dockable shoud be in state [com.javadocking.dockable.DockableState.EXTERNALIZED].");
        }
        LeafDock leafDock = dockable.getDock();
        if (!(leafDock instanceof ExternalizeDock)) {
            throw new IllegalStateException("The dock of the externalized dockable is a [" + leafDock.getClass() + "]. It should be a [com.javadocking.visualizer.Externalizer].");
        }
        ExternalizeDock childDock = (ExternalizeDock)leafDock;
        if (!this.equals(childDock.getExternalizer())) {
            throw new IllegalStateException("The dockable is externalized in another [com.javadocking.dock.FloatDock].");
        }
        this.moveDock(childDock, position, dockableOffset);
    }

    public void visualizeDockable(Dockable dockable) {
        if (!this.canVisualizeDockable(dockable)) {
            return;
        }
        Point ownerLocation = this.getOwner().getLocation();
        Dimension ownersize = this.getOwner().getSize();
        Dimension preferredSize = dockable.getContent().getPreferredSize();
        Point location = new Point(ownerLocation.x + ownersize.width / 2 - preferredSize.width / 2, ownerLocation.y + ownersize.height / 2 - preferredSize.height / 2);
        this.checkFloatingWindowLocation(location);
        dockable.setState(16, this);
        ExternalizeDock externalizeDock = DockingManager.getComponentFactory().createExternalizer();
        externalizeDock.setExternalizer(this);
        externalizeDock.externalizeDockable(dockable);
        this.addExternalizeDock(externalizeDock, location, null);
    }

    private void moveDock(Dock childDock, Point relativeLocation, Point dockableOffset) {
        Point point = new Point(relativeLocation.x - dockableOffset.x, relativeLocation.y - dockableOffset.y);
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)childDock));
        window.setLocation(new Point(point.x, point.y));
    }

    public boolean canVisualizeDockable(Dockable dockableToVisualize) {
        return (dockableToVisualize.getPossibleStates() & 0x10) != 0;
    }

    public int getState() {
        return 16;
    }

    public Dockable getVisualizedDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getVisualizedDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        ExternalizeDock externalizeDock = (ExternalizeDock)this.externalizeDocks.get(index);
        if (externalizeDock.getDockableCount() != 1) {
            throw new IllegalStateException("The externalize dock contains [" + externalizeDock.getDockableCount() + "] dockables.");
        }
        return externalizeDock.getDockable(0);
    }

    public int getVisualizedDockableCount() {
        return this.externalizeDocks.size();
    }

    public void removeVisualizedDockable(Dockable dockableToRemove) {
        for (int index = 0; index < this.externalizeDocks.size(); ++index) {
            ExternalizeDock externalizeDock = (ExternalizeDock)this.externalizeDocks.get(index);
            if (externalizeDock.getDockableCount() != 1) {
                throw new IllegalStateException("The externalize dock contains [" + externalizeDock.getDockableCount() + "] dockables.");
            }
            Dockable dockable = externalizeDock.getDockable(0);
            if (!dockable.equals(dockableToRemove)) continue;
            Window window = (Window)this.externalizeDockWindows.get(externalizeDock);
            window.setVisible(false);
            window.dispose();
            this.externalizeDocks.remove(externalizeDock);
            this.externalizeDockWindows.remove(externalizeDock);
            externalizeDock.removeDockable(dockableToRemove);
            return;
        }
    }

    public void saveProperties(String prefix, Properties properties) {
        PropertiesUtil.setInteger(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + "externalizeDockCount" + ".", this.externalizeDocks.size());
        int[] dim = new int[2];
        for (int index = 0; index < this.externalizeDocks.size(); ++index) {
            ExternalizeDock dock = (ExternalizeDock)this.externalizeDocks.get(index);
            PropertiesUtil.setString(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "class", dock.getClass().getName());
            dock.saveProperties(prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "dock", properties, null);
            Window window = (Window)this.externalizeDockWindows.get(dock);
            dim[0] = window.getSize().width;
            dim[1] = window.getSize().height;
            PropertiesUtil.setIntegerArray(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "windowRectangle", dim);
            Position.setPositionProperty(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "position", this.getExternalizeDockPosition(dock));
        }
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap, Window owner) throws IOException {
        this.setOwner(owner);
        int count = 0;
        count = PropertiesUtil.getInteger(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + "externalizeDockCount" + ".", count);
        for (int index = count - 1; index >= 0; --index) {
            String className = null;
            className = PropertiesUtil.getString(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "class", className);
            Class<?> clazz = null;
            ExternalizeDock dock = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Could not find class [" + className + "] (ClassNotFoundException).");
            }
            try {
                dock = (ExternalizeDock)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Illegal acces to class [" + className + "] (IllegalAccessException).");
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Could not instantiate class [" + className + "] (InstantiationException).");
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Class [" + className + "] is not a ExternalizeDock. (ClassCastException).");
            }
            dock.loadProperties(prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "dock", properties, null, dockablesMap, owner);
            dock.setExternalizer(this);
            if (dock.isEmpty()) continue;
            dock.getDockable(0).setState(16, this);
            int[] dim = null;
            dim = PropertiesUtil.getIntegerArray(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "windowRectangle", dim);
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + EXTERNALIZE_DOCK_PREFIX + "." + index + "." + "position", position);
            if (dim == null || dim.length != 2) continue;
            this.addExternalizeDock(dock, new Point(position.getPosition(0), position.getPosition(1)), new Dimension(dim[0], dim[1]));
        }
    }

    public Window getOwner() {
        return this.owner;
    }

    public void setOwner(Window newOwner) {
        if (this.owner != null) {
            this.owner.removeWindowListener(this.ownerWindowListener);
        }
        if (newOwner != null) {
            newOwner.addWindowListener(this.ownerWindowListener);
        }
        this.owner = newOwner;
    }

    public void externalizeDockable(Dockable dockable, Point position) {
        if (!this.canVisualizeDockable(dockable)) {
            return;
        }
        dockable.setState(16, this);
        ExternalizeDock externalizeDock = DockingManager.getComponentFactory().createExternalizer();
        externalizeDock.setExternalizer(this);
        externalizeDock.externalizeDockable(dockable);
        this.addExternalizeDock(externalizeDock, position, null);
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListeners.add(windowFocusListener);
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListeners.remove(windowFocusListener);
        Iterator iterator = this.externalizeDockWindows.values().iterator();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next();
            window.removeWindowFocusListener(windowFocusListener);
        }
    }

    protected void getDefaultFloatingWindowLocation(Point location) {
        location.move(this.getOwner().getLocation().x, this.getOwner().getLocation().y);
    }

    private void checkFloatingWindowLocation(Point location) {
        if (!SwingUtil.isLocationInScreenBounds(location)) {
            this.getDefaultFloatingWindowLocation(location);
        }
    }

    private void addExternalizeDock(ExternalizeDock dock, Point location, Dimension size) {
        Point point = new Point(location.x, location.y);
        this.checkFloatingWindowLocation(point);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(DockingManager.getComponentFactory().createFloatingBorder());
        panel.add((Component)((Object)dock), "Center");
        JDialog dialog = DockingManager.getComponentFactory().createJDialog(this.owner);
        dialog.setContentPane(panel);
        dialog.addWindowFocusListener(new MoveToFrontListener(dock));
        Iterator iterator = this.windowFocusListeners.iterator();
        while (iterator.hasNext()) {
            dialog.addWindowFocusListener((WindowFocusListener)iterator.next());
        }
        dialog.addWindowListener(this.windowClosingListener);
        if (size != null) {
            dialog.setSize(size.width, size.height);
        } else {
            dialog.pack();
        }
        dialog.setLocation(point.x - dialog.getInsets().left, point.y - dialog.getInsets().top);
        this.externalizeDockWindows.put(dock, dialog);
        dock.setExternalizer(this);
        this.externalizeDocks.add(0, dock);
        dialog.setVisible(true);
    }

    private Position getExternalizeDockPosition(ExternalizeDock externalizeDock) throws IllegalArgumentException {
        Window window = (Window)this.externalizeDockWindows.get(externalizeDock);
        int index = this.externalizeDocks.indexOf(externalizeDock);
        if (index >= 0 && window != null) {
            int[] positions = new int[]{window.getLocation().x, window.getLocation().y, index};
            return new Position(positions);
        }
        throw new IllegalArgumentException("Externalizer does not contain the externalize dock.");
    }

    private class OwnerWindowListener
    implements WindowListener {
        private OwnerWindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            for (int index = 0; index < FloatExternalizer.this.externalizeDocks.size(); ++index) {
                Dock dock = (Dock)FloatExternalizer.this.externalizeDocks.get(index);
                Window window = (Window)FloatExternalizer.this.externalizeDockWindows.get(dock);
                window.setVisible(false);
                window.dispose();
                FloatExternalizer.this.externalizeDocks.remove(dock);
                FloatExternalizer.this.externalizeDockWindows.remove(dock);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    private class MoveToFrontListener
    implements WindowFocusListener {
        private Dock childDock;

        public MoveToFrontListener(Dock childDock) {
            this.childDock = childDock;
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (FloatExternalizer.this.externalizeDocks.contains(this.childDock)) {
                FloatExternalizer.this.externalizeDocks.remove(this.childDock);
                FloatExternalizer.this.externalizeDocks.add(0, this.childDock);
            }
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }
    }

    private class WindowClosingListener
    implements WindowListener {
        private WindowClosingListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Container contentPane = SwingUtil.getContentPane(windowEvent.getWindow());
            Dock childDock = (Dock)((Object)contentPane.getComponent(0));
            FloatExternalizer.this.externalizeDocks.remove(childDock);
            FloatExternalizer.this.externalizeDockWindows.remove(childDock);
            ArrayList childDockables = new ArrayList();
            DockingUtil.retrieveDockables(childDock, childDockables);
            Iterator iterator = childDockables.iterator();
            while (iterator.hasNext()) {
                Dockable dockable = (Dockable)iterator.next();
                dockable.setState(2, null);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }
    }
}

