/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.visualizer;

import com.javadocking.DockingManager;
import com.javadocking.dock.DockableHider;
import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;

public class SingleMaximizer
extends JPanel
implements Visualizer {
    private Component content;
    private Dockable maximizedDockable;
    private int headerPosition = 3;

    public SingleMaximizer() {
        super(new BorderLayout());
    }

    public SingleMaximizer(Component content) {
        super(new BorderLayout());
        this.setContent(content);
    }

    public boolean canVisualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Dockable to maximize null.");
        }
        return true;
    }

    public void visualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Null visualized dockable.");
        }
        if (this.maximizedDockable != null) {
            Dockable dockableToRemove = DockingUtil.retrieveDockableOfDockModel(this.maximizedDockable.getID());
            if (dockableToRemove == null) {
                dockableToRemove = this.maximizedDockable;
            }
            this.removeVisualizedDockable(dockableToRemove);
            LeafDock dock = dockableToRemove.getDock();
            if (dock != null) {
                ((DockableHider)dock).restoreDockable(dockableToRemove);
                dockableToRemove.setState(1, dock);
            } else {
                dockableToRemove.setState(2, null);
            }
        }
        dockableToVisualize.setState(4, this);
        if (this.content != null) {
            this.remove(this.content);
        }
        this.maximizedDockable = dockableToVisualize;
        this.add(dockableToVisualize.getContent(), "Center");
        Component header = (Component)((Object)DockingManager.getComponentFactory().createMaximizeHeader(dockableToVisualize, this.headerPosition));
        this.add(header, "North");
        this.revalidate();
        this.repaint();
    }

    public int getState() {
        return 4;
    }

    public Dockable getVisualizedDockable(int index) {
        if (index < 0 || index >= this.getVisualizedDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return this.maximizedDockable;
    }

    public int getVisualizedDockableCount() {
        if (this.maximizedDockable != null) {
            return 1;
        }
        return 0;
    }

    public void removeVisualizedDockable(Dockable dockable) {
        if (this.maximizedDockable == null) {
            throw new IllegalStateException("There is no visualized dockable.");
        }
        if (!this.maximizedDockable.equals(dockable)) {
            throw new IllegalArgumentException("The dockable is not minimized in this minimizer.");
        }
        this.removeAll();
        this.maximizedDockable = null;
        if (this.content != null) {
            this.add(this.content, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap, Window owner) throws IOException {
        int headerPosition = 3;
        headerPosition = PropertiesUtil.getInteger(properties, prefix + "headerPosition", headerPosition);
        this.setHeaderPosition(headerPosition);
    }

    public void saveProperties(String prefix, Properties properties) {
        PropertiesUtil.setInteger(properties, prefix + "headerPosition", this.headerPosition);
    }

    public void setContent(Component component) {
        if (component == null) {
            throw new NullPointerException("Null content.");
        }
        if (this.content != null) {
            throw new IllegalStateException("There is already a content.");
        }
        this.content = component;
        this.add(this.content, "Center");
    }

    public Component getContent() {
        return this.content;
    }

    public int getHeaderPosition() {
        return this.headerPosition;
    }

    public void setHeaderPosition(int headerPosition) {
        this.headerPosition = headerPosition;
    }
}

