/*
 * Decompiled with CFR 0.152.
 */
package supercollider.sclang.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import supercollider.sclang.internal.ScLangLibrary;

public class Util {
    public static File copyResourceToFS(String resourcePath, String targetFsLocation) throws IOException {
        URL res = ScLangLibrary.class.getResource(resourcePath);
        InputStream is = res.openStream();
        File file = new File(targetFsLocation);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] array = new byte[1024];
        int i = is.read(array);
        while (i != -1) {
            fos.write(array, 0, i);
            i = is.read(array);
        }
        fos.close();
        is.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static String getOsName() {
        HashMap<String, String> nativeNames = new HashMap<String, String>();
        nativeNames.put("Mac OS X", "macosx");
        nativeNames.put("Windows", "windows");
        nativeNames.put("Linux", "linux");
        String name = System.getProperty("os.name");
        String nname = "";
        for (String key : nativeNames.keySet()) {
            if (name.indexOf(key) < 0) continue;
            nname = (String)nativeNames.get(key);
            break;
        }
        return nname;
    }

    public static String getOsArch() {
        HashMap<String, String> nativeNames = new HashMap<String, String>();
        nativeNames.put("amd64", "x86_64");
        nativeNames.put("x86_64", "x86_64");
        nativeNames.put("x86", "x86");
        nativeNames.put("i386", "x86");
        String arch = System.getProperty("os.arch");
        String narch = "";
        for (String key : nativeNames.keySet()) {
            if (arch.indexOf(key) < 0) continue;
            narch = (String)nativeNames.get(key);
            break;
        }
        return narch;
    }
}

