/*
 * Decompiled with CFR 0.152.
 */
package supercollider.internal;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import supercollider.internal.InternalSndBuf;
import supercollider.internal.ReplyCallback;
import supercollider.internal.ScsynthInteropStartOptions;
import supercollider.internal.Util;

public class ScSynthLibrary {
    private static String ugensDir = "";
    private static String scsynthDir = "";

    public static String getUgensPath() {
        return ugensDir;
    }

    public static String getScSynthPath() {
        return scsynthDir;
    }

    private static File copyResourceToFS(String resourcePath, String targetFsLocation) throws IOException {
        URL res = ScSynthLibrary.class.getResource(resourcePath);
        InputStream is = res.openStream();
        File file = new File(targetFsLocation);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] array = new byte[1024];
        int i = is.read(array);
        while (i != -1) {
            fos.write(array, 0, i);
            i = is.read(array);
        }
        fos.close();
        is.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<String> getFileList(String path) {
        ArrayList<String> retval = new ArrayList<String>();
        InputStream in = null;
        try {
            in = ScSynthLibrary.class.getResource(path).openStream();
            LineIterator it = IOUtils.lineIterator((InputStream)in, (String)"UTF-8");
            while (it.hasNext()) {
                String line = it.nextLine();
                retval.add(line);
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((InputStream)in);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return retval;
    }

    private static void addDirToLoadPath(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static native ScsynthInteropStartOptions.ByReference scsynth_interop_get_default_start_options();

    public static native int scsynth_interop_get_device_count();

    public static native String scsynth_interop_get_device_name(int var0);

    public static native int scsynth_interop_get_device_max_input_channels(int var0);

    public static native int scsynth_interop_get_device_max_output_channels(int var0);

    public static native int scsynth_interop_init();

    public static native void scsynth_interop_cleanup();

    public static native Pointer scsynth_interop_start(ScsynthInteropStartOptions var0);

    public static native InternalSndBuf scsynth_interop_copy_sndbuf(Pointer var0, int var1);

    public static native void World_Cleanup(Pointer var0);

    public static native int World_OpenUDP(Pointer var0, int var1);

    public static native int World_OpenTCP(Pointer var0, int var1, int var2, int var3);

    public static native boolean World_SendPacket(Pointer var0, int var1, ByteBuffer var2, ReplyCallback var3);

    public static native boolean World_SendPacketWithContext(Pointer var0, int var1, String var2, ReplyCallback var3, Pointer var4);

    public static native void World_WaitForQuit(Pointer var0);

    static {
        try {
            String target;
            String source;
            String baseTempPath = System.getProperty("java.io.tmpdir");
            Random rand = new Random();
            int randomInt = 100000 + rand.nextInt(899999);
            File tempDir = new File(baseTempPath + File.separator + "scsynth_interop" + randomInt);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            tempDir.deleteOnExit();
            File tempUgensDir = new File(tempDir.getPath() + File.separator + "ugens");
            if (!tempUgensDir.exists()) {
                tempUgensDir.mkdir();
            }
            tempUgensDir.deleteOnExit();
            String os = Util.getOsName();
            String arch = Util.getOsArch();
            String variant = "common";
            String resourcesBasePath = "/supercollider/scsynth/" + os + "/" + arch + "/" + variant;
            List<String> scSynthDirList = ScSynthLibrary.getFileList(resourcesBasePath + "/contents.txt");
            List<String> ugenDirList = ScSynthLibrary.getFileList(resourcesBasePath + "/ugens/contents.txt");
            for (String fn : scSynthDirList) {
                source = resourcesBasePath + "/" + fn;
                target = tempDir.getPath() + File.separator + fn;
                File lib = ScSynthLibrary.copyResourceToFS(source, target);
                lib.deleteOnExit();
            }
            for (String fn : ugenDirList) {
                source = resourcesBasePath + "/ugens/" + fn;
                target = tempUgensDir.getPath() + File.separator + fn;
                File ugen = ScSynthLibrary.copyResourceToFS(source, target);
                ugen.deleteOnExit();
            }
            scsynthDir = tempDir.getPath();
            ugensDir = tempUgensDir.getPath();
            ScSynthLibrary.addDirToLoadPath(scsynthDir);
            System.setProperty("jna.library.path", tempDir.getPath());
            Native.register((String)"scsynth-interop");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

