/*
 * Decompiled with CFR 0.152.
 */
package supercollider;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import supercollider.MessageReceivedListener;
import supercollider.ScSynthDevice;
import supercollider.ScSynthOptions;
import supercollider.ScSynthSndBuf;
import supercollider.ScSynthStartedListener;
import supercollider.ScSynthStoppedListener;
import supercollider.internal.InternalSndBuf;
import supercollider.internal.ReplyCallback;
import supercollider.internal.ScSynthLibrary;
import supercollider.internal.ScsynthInteropStartOptions;

public class ScSynth
implements Runnable {
    protected ArrayList<ScSynthStartedListener> startedListeners = new ArrayList();
    protected ArrayList<ScSynthStoppedListener> stoppedListeners = new ArrayList();
    protected ArrayList<MessageReceivedListener> messageListeners = new ArrayList();
    protected Pointer world = Pointer.NULL;
    protected boolean running = false;
    protected ScSynthOptions options = new ScSynthOptions();
    private ReplyCallback globalReplyCallback = new ReplyCallback(){

        @Override
        public void callback(Pointer addr, Pointer buf, int size) {
            ByteBuffer byteBuffer = buf.getByteBuffer(0L, (long)size).order(ByteOrder.BIG_ENDIAN);
            if (!ScSynth.this.messageListeners.isEmpty()) {
                for (MessageReceivedListener l : ScSynth.this.messageListeners) {
                    l.messageReceived(byteBuffer, size);
                }
            }
        }
    };

    public ScSynth() {
    }

    public ScSynth(ScSynthOptions options) {
        this.options = options;
    }

    public ScSynthOptions getOptions() {
        return this.options;
    }

    public void setOptions(ScSynthOptions options) {
        this.options = options;
    }

    public void openUdp(int port) {
        if (this.running) {
            ScSynthLibrary.scsynth_interop_open_udp(this.world, port);
        }
    }

    public void openTcp(int port) {
        if (this.running) {
            ScSynthLibrary.scsynth_interop_open_tcp(this.world, port, 64, 8);
        }
    }

    private ScsynthInteropStartOptions.ByReference getStartOptions() {
        ScsynthInteropStartOptions.ByReference retval = new ScsynthInteropStartOptions.ByReference();
        retval.UGensPluginPath = ScSynthLibrary.getUgensPath();
        retval.verbosity = this.options.getVerbosity();
        retval.inDeviceName = this.options.getInDeviceName();
        retval.outDeviceName = this.options.getOutDeviceName();
        retval.numControlBusChannels = this.options.getNumControlBusChannels();
        retval.numAudioBusChannels = this.options.getNumAudioBusChannels();
        retval.numInputBusChannels = this.options.getNumInputBusChannels();
        retval.numOutputBusChannels = this.options.getNumOutputBusChannels();
        retval.bufLength = this.options.getBufLength();
        retval.preferredHardwareBufferFrameSize = this.options.getPreferredHardwareBufferFrameSize();
        retval.preferredSampleRate = this.options.getPreferredSampleRate();
        retval.numBuffers = this.options.getNumBuffers();
        retval.maxNodes = this.options.getMaxNodes();
        retval.maxGraphDefs = this.options.getMaxGraphDefs();
        retval.realTimeMemorySize = this.options.getRealTimeMemorySize();
        retval.maxWireBufs = this.options.getMaxWireBufs();
        retval.numRGens = this.options.getNumRGens();
        return retval;
    }

    public static List<ScSynthDevice> getDevices() {
        ArrayList<ScSynthDevice> retval = new ArrayList<ScSynthDevice>();
        int count = ScSynthLibrary.scsynth_interop_get_device_count();
        for (int i = 0; i < count; ++i) {
            String name = ScSynthLibrary.scsynth_interop_get_device_name(i);
            int maxInputs = ScSynthLibrary.scsynth_interop_get_device_max_input_channels(i);
            int maxOutputs = ScSynthLibrary.scsynth_interop_get_device_max_output_channels(i);
            ScSynthDevice device = new ScSynthDevice();
            device.setName(name);
            device.setMaxInputs(maxInputs);
            device.setMaxOutputs(maxOutputs);
            retval.add(device);
        }
        return retval;
    }

    @Override
    public void run() {
        if (!this.running) {
            ScSynthLibrary.scsynth_interop_init();
            this.world = ScSynthLibrary.scsynth_interop_start(this.getStartOptions());
            this.running = true;
            for (ScSynthStartedListener scSynthStartedListener : this.startedListeners) {
                scSynthStartedListener.started();
            }
            ScSynthLibrary.scsynth_interop_wait_for_quit(this.world);
            ScSynthLibrary.scsynth_interop_cleanup();
            this.running = false;
            for (ScSynthStoppedListener scSynthStoppedListener : this.stoppedListeners) {
                scSynthStoppedListener.stopped();
            }
        }
    }

    public void addScSynthStartedListener(ScSynthStartedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.startedListeners.add(listener);
    }

    public void removeScSynthStartedListener(ScSynthStartedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.startedListeners.remove(listener);
    }

    public void addScSynthStoppedListener(ScSynthStoppedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.stoppedListeners.add(listener);
    }

    public void removeScSynthStoppedListener(ScSynthStoppedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.stoppedListeners.remove(listener);
    }

    public void addMessageReceivedListener(MessageReceivedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.messageListeners.add(listener);
    }

    public void removeMessageReceivedListener(MessageReceivedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.messageListeners.remove(listener);
    }

    public void send(ByteBuffer b) {
        if (this.running) {
            ScSynthLibrary.scsynth_interop_send_packet(this.world, b.limit(), b, this.globalReplyCallback);
        }
    }

    private float[] internalBufToFloatArray(InternalSndBuf buf) {
        float[] retval = new float[]{};
        int nFrames = buf.frames;
        Pointer data = buf.data;
        if (data != Pointer.NULL) {
            retval = data.getFloatArray(0L, nFrames);
        }
        return retval;
    }

    public ScSynthSndBuf getSndBuf(int index) {
        ScSynthSndBuf retval = new ScSynthSndBuf();
        if (this.running) {
            InternalSndBuf buf = ScSynthLibrary.scsynth_interop_copy_sndbuf(this.world, index);
            retval.setData(this.internalBufToFloatArray(buf));
            retval.setSamplerate(buf.samplerate);
            retval.setSampledur(buf.sampledur);
            retval.setChannels(buf.channels);
            retval.setSamples(buf.samples);
            retval.setFrames(buf.frames);
            retval.setMask(buf.mask);
            retval.setMask1(buf.mask1);
            retval.setCoord(buf.coord);
        }
        return retval;
    }

    public float[] getSndBufAsFloatArray(int index) {
        float[] retval = new float[]{};
        if (this.running) {
            InternalSndBuf buf = ScSynthLibrary.scsynth_interop_copy_sndbuf(this.world, index);
            retval = this.internalBufToFloatArray(buf);
        }
        return retval;
    }

    public static void main(String[] args) {
        ScSynth sc = new ScSynth();
        new Thread(sc).start();
    }
}

