/*
 * Decompiled with CFR 0.152.
 */
package supercollider.internal;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import supercollider.internal.InternalSndBuf;
import supercollider.internal.ReplyCallback;
import supercollider.internal.ScsynthInteropStartOptions;
import supercollider.internal.Util;

public class ScSynthLibrary {
    private static String ugensDir = "";
    private static String scsynthDir = "";

    public static String getUgensPath() {
        return ugensDir;
    }

    public static String getScSynthPath() {
        return scsynthDir;
    }

    public static List<String> getFileList(String path) throws IOException {
        ArrayList<String> retval = new ArrayList<String>();
        InputStream in = ScSynthLibrary.class.getResource(path).openStream();
        String[] contents = Util.convertStreamToString(in).split("\n");
        retval.addAll(Arrays.asList(contents));
        in.close();
        return retval;
    }

    public static native ScsynthInteropStartOptions.ByReference scsynth_interop_get_default_start_options();

    public static native int scsynth_interop_get_device_count();

    public static native String scsynth_interop_get_device_name(int var0);

    public static native int scsynth_interop_get_device_max_input_channels(int var0);

    public static native int scsynth_interop_get_device_max_output_channels(int var0);

    public static native int scsynth_interop_init();

    public static native void scsynth_interop_cleanup();

    public static native Pointer scsynth_interop_start(ScsynthInteropStartOptions var0);

    public static native InternalSndBuf scsynth_interop_copy_sndbuf(Pointer var0, int var1);

    public static native int scsynth_interop_open_udp(Pointer var0, int var1);

    public static native int scsynth_interop_open_tcp(Pointer var0, int var1, int var2, int var3);

    public static native boolean scsynth_interop_send_packet(Pointer var0, int var1, ByteBuffer var2, ReplyCallback var3);

    public static native void scsynth_interop_wait_for_quit(Pointer var0);

    static {
        try {
            String target;
            String source;
            String baseTempPath = System.getProperty("java.io.tmpdir");
            Random rand = new Random();
            int randomInt = 100000 + rand.nextInt(899999);
            File tempDir = new File(baseTempPath + File.separator + "scsynth_interop" + randomInt);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            tempDir.deleteOnExit();
            File tempUgensDir = new File(tempDir.getPath() + File.separator + "ugens");
            if (!tempUgensDir.exists()) {
                tempUgensDir.mkdir();
            }
            tempUgensDir.deleteOnExit();
            String os = Util.getOsName();
            String arch = Util.getOsArch();
            String variant = "common";
            String resourcesBasePath = "/supercollider/scsynth/" + os + "/" + arch + "/" + variant;
            List<String> scSynthDirList = ScSynthLibrary.getFileList(resourcesBasePath + "/contents.txt");
            List<String> ugenDirList = ScSynthLibrary.getFileList(resourcesBasePath + "/ugens/contents.txt");
            for (String fn : scSynthDirList) {
                source = resourcesBasePath + "/" + fn;
                target = tempDir.getPath() + File.separator + fn;
                File lib = Util.copyResourceToFS(source, target);
                lib.deleteOnExit();
            }
            for (String fn : ugenDirList) {
                source = resourcesBasePath + "/ugens/" + fn;
                target = tempUgensDir.getPath() + File.separator + fn;
                File ugen = Util.copyResourceToFS(source, target);
                ugen.deleteOnExit();
            }
            scsynthDir = tempDir.getPath();
            ugensDir = tempUgensDir.getPath();
            System.setProperty("jna.library.path", tempDir.getPath());
            Native.register((String)"scsynth-interop");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

