/*
 * Decompiled with CFR 0.152.
 */
package supercollider.internal;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Random;
import supercollider.internal.InternalSndBuf;
import supercollider.internal.ReplyCallback;
import supercollider.internal.ScsynthJnaStartOptions;
import supercollider.internal.Util;

public class ScSynthLibrary {
    private static String ugensDir = "";
    private static String scsynthDir = "";

    public static String getUgensPath() {
        return ugensDir;
    }

    public static String getScSynthPath() {
        return scsynthDir;
    }

    private static File copyResourceToFS(String resourcePath, String targetFsLocation) throws IOException {
        URL res = ScSynthLibrary.class.getResource(resourcePath);
        InputStream is = res.openStream();
        File file = new File(targetFsLocation);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] array = new byte[1024];
        int i = is.read(array);
        while (i != -1) {
            fos.write(array, 0, i);
            i = is.read(array);
        }
        fos.close();
        is.close();
        return file;
    }

    public static native ScsynthJnaStartOptions.ByReference scsynth_jna_get_default_start_options();

    public static native int scsynth_jna_get_device_count();

    public static native String scsynth_jna_get_device_name(int var0);

    public static native int scsynth_jna_get_device_max_input_channels(int var0);

    public static native int scsynth_jna_get_device_max_output_channels(int var0);

    public static native int scsynth_jna_init();

    public static native void scsynth_jna_cleanup();

    public static native Pointer scsynth_jna_start(ScsynthJnaStartOptions var0);

    public static native InternalSndBuf scsynth_jna_copy_sndbuf(Pointer var0, int var1);

    public static native void World_Cleanup(Pointer var0);

    public static native int World_OpenUDP(Pointer var0, int var1);

    public static native int World_OpenTCP(Pointer var0, int var1, int var2, int var3);

    public static native boolean World_SendPacket(Pointer var0, int var1, ByteBuffer var2, ReplyCallback var3);

    public static native boolean World_SendPacketWithContext(Pointer var0, int var1, String var2, ReplyCallback var3, Pointer var4);

    public static native void World_WaitForQuit(Pointer var0);

    private static String getUgensLocation() {
        return ScSynthLibrary.getScSynthLocation() + "/ugens";
    }

    private static String[] getScSynthDependencies() {
        if (Util.getOsName().equals("windows")) {
            return new String[]{"libsndfile-1.dll"};
        }
        return new String[0];
    }

    private static String[] getUgens() {
        if (Util.getOsName().equals("linux")) {
            return new String[]{"BinaryOpUGens.so", "KeyboardUGens.so", "MouseUGens.so", "GendynUGens.so", "PanUGens.so", "ChaosUGens.so", "GrainUGens.so", "PhysicalModelingUGens.so", "DelayUGens.so", "IOUGens.so", "PV_ThirdParty.so", "DemandUGens.so", "LFUGens.so", "ReverbUGens.so", "DiskIO_UGens.so", "ML_UGens.so", "TestUGens.so", "DynNoiseUGens.so", "MulAddUGens.so", "TriggerUGens.so", "FFT_UGens.so", "NoiseUGens.so", "UnaryOpUGens.so", "FilterUGens.so", "OscUGens.so", "UnpackFFTUGens.so"};
        }
        if (Util.getOsName().equals("windows")) {
            return new String[]{"BinaryOpUGens.scx", "ChaosUGens.scx", "DelayUGens.scx", "DemandUGens.scx", "DiskIOUGens.scx", "DynNoiseUGens.scx", "FilterUGens.scx", "GendynUGens.scx", "GrainUGens.scx", "IOUGens.scx", "LFUGens.scx", "libfftw3-3.dll", "libfftw3f-3.dll", "libfftw3l-3.dll", "libsndfile-1.dll", "MachineListeningUGens.scx", "MouseUGens.scx", "MulAddUGens.scx", "NoiseUGens.scx", "OSCUGens.scx", "PanUGens.scx", "PhysicalModelingUGens.scx", "ReverbUGens.scx", "scsynth.dll", "TestUGens.scx", "TriggerUGens.scx", "UnaryOpUGens.scx", "UnpackFFTUGens.scx"};
        }
        if (Util.getOsName().equals("macosx")) {
            return new String[]{"IOUGens.scx", "OscUGens.scx", "UnaryOpUGens.scx", "DiskIO_UGens.scx", "DynNoiseUGens.scx", "GrainUGens.scx", "LFUGens.scx", "NoiseUGens.scx", "FFT_UGens.scx", "BinaryOpUGens.scx", "GendynUGens.scx", "ChaosUGens.scx", "MulAddUGens.scx", "DelayUGens.scx", "PhysicalModelingUGens.scx", "PV_ThirdParty.scx", "DemandUGens.scx", "PanUGens.scx", "KeyboardUGens.scx", "TriggerUGens.scx", "TestUGens.scx", "UnpackFFTUGens.scx", "MouseUGens.scx", "ReverbUGens.scx", "FilterUGens.scx", "ML_UGens.scx"};
        }
        return new String[0];
    }

    private static String getScSynth() {
        String retval = "";
        if (Util.getOsName().equals("linux")) {
            retval = "libscsynth_jna.so";
        } else if (Util.getOsName().equals("windows")) {
            retval = "scsynth_jna.dll";
        } else if (Util.getOsName().equals("macosx")) {
            retval = "libscsynth_jna.dylib";
        }
        return retval;
    }

    private static String getScSynthLocation() {
        return "/supercollider/scsynth/" + Util.getOsName() + "/" + Util.getOsArch();
    }

    static {
        try {
            String target;
            String source;
            String baseTempPath = System.getProperty("java.io.tmpdir");
            Random rand = new Random();
            int randomInt = 100000 + rand.nextInt(899999);
            File tempDir = new File(baseTempPath + File.separator + "scsynth_jna" + randomInt);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            tempDir.deleteOnExit();
            File tempUgensDir = new File(tempDir.getPath() + File.separator + "ugens");
            if (!tempUgensDir.exists()) {
                tempUgensDir.mkdir();
            }
            tempUgensDir.deleteOnExit();
            String fn = ScSynthLibrary.getScSynth();
            String source2 = ScSynthLibrary.getScSynthLocation() + "/" + fn;
            String target2 = tempDir.getPath() + File.separator + fn;
            File lib = ScSynthLibrary.copyResourceToFS(source2, target2);
            lib.deleteOnExit();
            for (String fn2 : ScSynthLibrary.getScSynthDependencies()) {
                source = ScSynthLibrary.getScSynthLocation() + "/" + fn2;
                target = tempDir.getPath() + File.separator + fn2;
                File lib2 = ScSynthLibrary.copyResourceToFS(source, target);
                lib2.deleteOnExit();
            }
            for (String fn2 : ScSynthLibrary.getUgens()) {
                source = ScSynthLibrary.getUgensLocation() + "/" + fn2;
                target = tempUgensDir.getPath() + File.separator + fn2;
                File ugen = ScSynthLibrary.copyResourceToFS(source, target);
                ugen.deleteOnExit();
            }
            scsynthDir = tempDir.getPath();
            ugensDir = tempUgensDir.getPath();
            System.setProperty("jna.library.path", tempDir.getPath());
            Native.register((String)"scsynth_jna");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

