/*
 * Decompiled with CFR 0.152.
 */
package supercollider;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Random;
import supercollider.ReplyCallback;
import supercollider.ScsynthJnaStartOptions;
import supercollider.SndBuf;

public class ScSynthLibrary {
    private static String ugensDir = "";
    private static String scsynthDir = "";

    public static String getUgensPath() {
        return ugensDir;
    }

    public static String getScSynthPath() {
        return scsynthDir;
    }

    private static File copyResourceToFS(String resourcePath, String targetFsLocation) throws IOException {
        URL res = ScSynthLibrary.class.getResource(resourcePath);
        InputStream is = res.openStream();
        File file = new File(targetFsLocation);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] array = new byte[1024];
        int i = is.read(array);
        while (i != -1) {
            fos.write(array, 0, i);
            i = is.read(array);
        }
        fos.close();
        is.close();
        return file;
    }

    public static native int scsynth_jna_init();

    public static native void scsynth_jna_cleanup();

    public static native Pointer scsynth_jna_start(ScsynthJnaStartOptions var0);

    public static native SndBuf scsynth_jna_copy_sndbuf(Pointer var0, int var1);

    public static native void World_Cleanup(Pointer var0);

    public static native int World_OpenUDP(Pointer var0, int var1);

    public static native int World_OpenTCP(Pointer var0, int var1, int var2, int var3);

    public static native boolean World_SendPacket(Pointer var0, int var1, ByteBuffer var2, ReplyCallback var3);

    public static native boolean World_SendPacketWithContext(Pointer var0, int var1, String var2, ReplyCallback var3, Pointer var4);

    public static native void World_WaitForQuit(Pointer var0);

    private static String getUgensLocation() {
        return ScSynthLibrary.getScSynthLocation() + "/ugens";
    }

    private static String[] getScSynthDependencies() {
        if (ScSynthLibrary.getOsName().equals("windows")) {
            return new String[]{"libsndfile-1.dll"};
        }
        return new String[0];
    }

    private static String[] getUgens() {
        if (ScSynthLibrary.getOsName().equals("linux")) {
            return new String[]{"BinaryOpUGens.so", "KeyboardUGens.so", "MouseUGens.so", "GendynUGens.so", "PanUGens.so", "ChaosUGens.so", "GrainUGens.so", "PhysicalModelingUGens.so", "DelayUGens.so", "IOUGens.so", "PV_ThirdParty.so", "DemandUGens.so", "LFUGens.so", "ReverbUGens.so", "DiskIO_UGens.so", "ML_UGens.so", "TestUGens.so", "DynNoiseUGens.so", "MulAddUGens.so", "TriggerUGens.so", "FFT_UGens.so", "NoiseUGens.so", "UnaryOpUGens.so", "FilterUGens.so", "OscUGens.so", "UnpackFFTUGens.so"};
        }
        if (ScSynthLibrary.getOsName().equals("windows")) {
            return new String[]{"BinaryOpUGens.scx", "ChaosUGens.scx", "DelayUGens.scx", "DemandUGens.scx", "DiskIOUGens.scx", "DynNoiseUGens.scx", "FilterUGens.scx", "GendynUGens.scx", "GrainUGens.scx", "IOUGens.scx", "LFUGens.scx", "libfftw3-3.dll", "libfftw3f-3.dll", "libfftw3l-3.dll", "libsndfile-1.dll", "MachineListeningUGens.scx", "MouseUGens.scx", "MulAddUGens.scx", "NoiseUGens.scx", "OSCUGens.scx", "PanUGens.scx", "PhysicalModelingUGens.scx", "ReverbUGens.scx", "scsynth.dll", "TestUGens.scx", "TriggerUGens.scx", "UnaryOpUGens.scx", "UnpackFFTUGens.scx"};
        }
        if (ScSynthLibrary.getOsName().equals("macosx")) {
            // empty if block
        }
        return new String[0];
    }

    private static String getScSynth() {
        String retval = "";
        if (ScSynthLibrary.getOsName().equals("linux")) {
            retval = "libscsynth_jna.so";
        } else if (ScSynthLibrary.getOsName().equals("windows")) {
            retval = "scsynth_jna.dll";
        } else if (ScSynthLibrary.getOsName().equals("macosx")) {
            retval = "";
        }
        return retval;
    }

    private static String getScSynthLocation() {
        return "/supercollider/scsynth/" + ScSynthLibrary.getOsName() + "/" + ScSynthLibrary.getOsArch();
    }

    private static String getOsName() {
        HashMap<String, String> nativeNames = new HashMap<String, String>();
        nativeNames.put("Mac OS X", "macosx");
        nativeNames.put("Windows", "windows");
        nativeNames.put("Linux", "linux");
        String name = System.getProperty("os.name");
        String nname = "";
        for (String key : nativeNames.keySet()) {
            if (name.indexOf(key) < 0) continue;
            nname = (String)nativeNames.get(key);
            break;
        }
        return nname;
    }

    private static String getOsArch() {
        HashMap<String, String> nativeNames = new HashMap<String, String>();
        nativeNames.put("amd64", "x86_64");
        nativeNames.put("x86_64", "x86_64");
        nativeNames.put("x86", "x86");
        nativeNames.put("i386", "x86");
        String arch = System.getProperty("os.arch");
        String narch = "";
        for (String key : nativeNames.keySet()) {
            if (arch.indexOf(key) < 0) continue;
            narch = (String)nativeNames.get(key);
            break;
        }
        return narch;
    }

    static {
        try {
            String target;
            String source;
            String baseTempPath = System.getProperty("java.io.tmpdir");
            Random rand = new Random();
            int randomInt = 100000 + rand.nextInt(899999);
            File tempDir = new File(baseTempPath + File.separator + "scsynth_jna" + randomInt);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            tempDir.deleteOnExit();
            File tempUgensDir = new File(tempDir.getPath() + File.separator + "ugens");
            if (!tempUgensDir.exists()) {
                tempUgensDir.mkdir();
            }
            tempUgensDir.deleteOnExit();
            String fn = ScSynthLibrary.getScSynth();
            String source2 = ScSynthLibrary.getScSynthLocation() + "/" + fn;
            String target2 = tempDir.getPath() + File.separator + fn;
            File lib = ScSynthLibrary.copyResourceToFS(source2, target2);
            lib.deleteOnExit();
            for (String fn2 : ScSynthLibrary.getScSynthDependencies()) {
                source = ScSynthLibrary.getScSynthLocation() + "/" + fn2;
                target = tempDir.getPath() + File.separator + fn2;
                File lib2 = ScSynthLibrary.copyResourceToFS(source, target);
                lib2.deleteOnExit();
            }
            for (String fn2 : ScSynthLibrary.getUgens()) {
                source = ScSynthLibrary.getUgensLocation() + "/" + fn2;
                target = tempUgensDir.getPath() + File.separator + fn2;
                File ugen = ScSynthLibrary.copyResourceToFS(source, target);
                ugen.deleteOnExit();
            }
            scsynthDir = tempDir.getPath();
            ugensDir = tempUgensDir.getPath();
            System.setProperty("jna.library.path", tempDir.getPath());
            Native.register((String)"scsynth_jna");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

