/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun.builtins;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGServer;
import java.util.Set;

public class NGAlias {
    private static String padl(String s, int len) {
        StringBuffer buf = new StringBuffer(s);
        while (buf.length() < len) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static void nailMain(NGContext context) throws ClassNotFoundException {
        String[] args = context.getArgs();
        NGServer server = context.getNGServer();
        if (args.length == 0) {
            Set aliases = server.getAliasManager().getAliases();
            int maxAliasLength = 0;
            int maxClassnameLength = 0;
            for (Alias alias : aliases) {
                maxAliasLength = Math.max(maxAliasLength, alias.getName().length());
                maxClassnameLength = Math.max(maxClassnameLength, alias.getAliasedClass().getName().length());
            }
            for (Alias alias : aliases) {
                context.out.println(NGAlias.padl(alias.getName(), maxAliasLength) + "\t" + NGAlias.padl(alias.getAliasedClass().getName(), maxClassnameLength));
                context.out.println(NGAlias.padl("", maxAliasLength) + "\t" + alias.getDescription());
                context.out.println();
            }
        } else if (args.length == 2) {
            server.getAliasManager().addAlias(new Alias(args[0], "", Class.forName(args[1])));
        }
    }
}

