/*
 * Decompiled with CFR 0.152.
 */
package benchtools.java.sets;

import benchtools.java.sets.DoubleInterval;
import benchtools.java.sets.IntegerInterval;
import java.util.Collections;
import java.util.Set;

public final class Intersects {
    public static final boolean intersects(IntegerInterval s0, IntegerInterval s1) {
        if (s0.max <= s1.min) {
            return false;
        }
        return s1.max > s0.min;
    }

    public static final boolean intersects(IntegerInterval s0, DoubleInterval s1) {
        if ((double)s0.max <= s1.min) {
            return false;
        }
        return !(s1.max <= (double)s0.min);
    }

    public static final boolean intersects(IntegerInterval s0, Set s1) {
        return s0.intersects(s1);
    }

    public static final boolean intersects(DoubleInterval s0, IntegerInterval s1) {
        if (s0.max <= (double)s1.min) {
            return false;
        }
        return !((double)s1.max <= s0.min);
    }

    public static final boolean intersects(DoubleInterval s0, DoubleInterval s1) {
        if (s0.max <= s1.min) {
            return false;
        }
        return !(s1.max <= s0.min);
    }

    public static final boolean intersects(DoubleInterval s0, Set s1) {
        return s0.intersects(s1);
    }

    public static final boolean intersects(Set s0, IntegerInterval s1) {
        return s1.intersects(s0);
    }

    public static final boolean intersects(Set s0, DoubleInterval s1) {
        return s1.intersects(s0);
    }

    public static final boolean intersects(Set s0, Set s1) {
        return !Collections.disjoint(s0, s1);
    }

    public static final boolean intersects(Object s0, Object s1) {
        throw new UnsupportedOperationException("don't know how to test for intersections of " + s0.getClass().getSimpleName() + " and " + s1.getClass().getSimpleName());
    }

    public static final boolean manual(Object s0, Object s1) {
        if (s0 instanceof IntegerInterval) {
            if (s1 instanceof IntegerInterval) {
                return Intersects.intersects((IntegerInterval)s0, (IntegerInterval)s1);
            }
            if (s1 instanceof DoubleInterval) {
                return Intersects.intersects((IntegerInterval)s0, (DoubleInterval)s1);
            }
            if (s1 instanceof Set) {
                return Intersects.intersects((IntegerInterval)s0, (Set)s1);
            }
            return ((IntegerInterval)s0).intersects(s1);
        }
        if (s0 instanceof DoubleInterval) {
            if (s1 instanceof DoubleInterval) {
                return Intersects.intersects((DoubleInterval)s0, (DoubleInterval)s1);
            }
            if (s1 instanceof IntegerInterval) {
                return Intersects.intersects((DoubleInterval)s0, (IntegerInterval)s1);
            }
            if (s1 instanceof Set) {
                return Intersects.intersects((DoubleInterval)s0, (Set)s1);
            }
            return ((DoubleInterval)s0).intersects(s1);
        }
        if (s0 instanceof Set) {
            if (s1 instanceof DoubleInterval) {
                return Intersects.intersects((Set)s0, (DoubleInterval)s1);
            }
            if (s1 instanceof IntegerInterval) {
                return Intersects.intersects((Set)s0, (IntegerInterval)s1);
            }
            if (s1 instanceof Set) {
                return Intersects.intersects((Set)s0, (Set)s1);
            }
        }
        throw new UnsupportedOperationException("Can't test for interesection of " + s0.getClass().getSimpleName() + " and " + s1.getClass().getSimpleName());
    }

    public static final int countIntersections(IntegerInterval[] s0, IntegerInterval[] s1) {
        int k = 0;
        int n = s0.length;
        assert (n == s1.length);
        for (int i = 0; i < n; ++i) {
            if (!Intersects.intersects(s0[i], s1[i])) continue;
            ++k;
        }
        return k;
    }

    private Intersects() {
        throw new UnsupportedOperationException("can't instantiate " + this.getClass());
    }
}

