package palisades.lakes.bench.java.sets;

/** Static containment  test.
 *
 * @author palisades dot lakes at gmail dot com
 * @since 2017-05-29
 * @version 2017-08-28
 */

@SuppressWarnings("unchecked")
public final class Contains extends Object {

  //--------------------------------------------------------------
  // primitives
  // TODO: code generation!
  //--------------------------------------------------------------

  public final static boolean contains (final ByteInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final DoubleInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final FloatInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final IntegerInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final LongInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final ShortInterval s,
                                        final byte x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final double x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final float x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final int x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final long x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final short x) {
    if (s.max <= x) { return false; }
    if (x <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------
  // Numbers
  //--------------------------------------------------------------

  public final static boolean contains (final ByteInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ByteInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final DoubleInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final DoubleInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final FloatInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final FloatInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final IntegerInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final IntegerInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final LongInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final LongInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final ShortInterval s,
                                        final Byte x) {
    if (s.max <= x.byteValue()) { return false; }
    if (x.byteValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final Double x) {
    if (s.max <= x.doubleValue()) { return false; }
    if (x.doubleValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final Float x) {
    if (s.max <= x.floatValue()) { return false; }
    if (x.floatValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final Integer x) {
    if (s.max <= x.intValue()) { return false; }
    if (x.intValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final Long x) {
    if (s.max <= x.longValue()) { return false; }
    if (x.longValue() <= s.min) { return false; }
    return true; }

  public final static boolean contains (final ShortInterval s,
                                        final Short x) {
    if (s.max <= x.shortValue()) { return false; }
    if (x.shortValue() <= s.min) { return false; }
    return true; }

  //--------------------------------------------------------------

  public final static boolean contains (final java.util.Set s,
                                        final int x) {
    return s.contains(Integer.valueOf(x)); }

  public final static boolean contains (final java.util.Set s,
                                        final Object x) {
    return s.contains(x); }

  //--------------------------------------------------------------
  // lookup
  //--------------------------------------------------------------

  public static final boolean contains (final Object s,
                                        final int x) {
    if (s instanceof ByteInterval) {
      final ByteInterval i = (ByteInterval) s;
      return contains(i,x); }
    if (s instanceof DoubleInterval) {
      final DoubleInterval i = (DoubleInterval) s;
      return contains(i,x); }
    if (s instanceof FloatInterval) {
      final FloatInterval i = (FloatInterval) s;
      return contains(i,x); }
    if (s instanceof IntegerInterval) {
      final IntegerInterval i = (IntegerInterval) s;
      return contains(i,x); }
    if (s instanceof LongInterval) {
      final LongInterval i = (LongInterval) s;
      return contains(i,x); }
    if (s instanceof ShortInterval) {
      final ShortInterval i = (ShortInterval) s;
      return contains(i,x); }
    if (s instanceof java.util.Set) {
      return contains((java.util.Set) s, x); }
    throw new IllegalArgumentException(
      "can't tell if " + s.getClass() + " contains " + x); }

  // ordered to favor IntegerInterval,Integer case,
  // because that's the exact benchmark case, and I want to see 
  // how fast it could be when hand-optimized, as a baseline
  
  public static final boolean contains (final Object s,
                                        final Object x) {

    if (s instanceof IntegerInterval) {
      final IntegerInterval i = (IntegerInterval) s;
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof ByteInterval) {
      final ByteInterval i = (ByteInterval) s;
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof DoubleInterval) {
      final DoubleInterval i = (DoubleInterval) s;
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof FloatInterval) {
      final FloatInterval i = (FloatInterval) s;
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof LongInterval) {
      final LongInterval i = (LongInterval) s;
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof ShortInterval) {
      final ShortInterval i = (ShortInterval) s;
      if (x instanceof Byte) { return contains(i, (Byte) x); }
      if (x instanceof Double) { return contains(i, (Double) x); }
      if (x instanceof Float) { return contains(i, (Float) x); }
      if (x instanceof Integer) { return contains(i, (Integer) x); }
      if (x instanceof Long) { return contains(i, (Long) x); }
      if (x instanceof Short) { return contains(i, (Short) x); } }

    if (s instanceof java.util.Set) {
      return contains((java.util.Set) s, x); }

    throw new IllegalArgumentException(
      "can't tell if " + s.getClass() + 
      " contains " + x.getClass()); }

  //--------------------------------------------------------------
  // summaries
  //--------------------------------------------------------------

  public static final int 
  countStatic (final IntegerInterval[] s,
               final int[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (contains(s[i],x[i])) { k++; } }
    return k; }

  public static final int 
  countStatic (final IntegerInterval[] s,
               final Integer[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (contains(s[i],x[i])) { k++; } }
    return k; }

  public static final int 
  countStatic (final Set[] s,
               final int[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (contains(s[i],x[i])) { k++; } }
    return k; }

  public static final int 
  countStatic (final Set[] s,
               final Integer[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (contains(s[i],x[i])) { k++; } }
    return k; }

  public static final int 
  countStatic (final Object[] s,
               final Object[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (contains(s[i],x[i])) { k++; } }
    return k; }

  //--------------------------------------------------------------

  public static final int 
  countVirtual (final IntegerInterval[] s,
                final int[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (s[i].contains(x[i])) { k++; } }
    return k; }

  public static final int 
  countVirtual (final IntegerInterval[] s,
                final Integer[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (s[i].contains(x[i])) { k++; } }
    return k; }

  //--------------------------------------------------------------

  public static final int 
  countInterface (final Set[] s,
                  final int[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (s[i].contains(x[i])) { k++; } }
    return k; }

  public static final int 
  countInterface (final Set[] s,
                  final Integer[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (s[i].contains(x[i])) { k++; } }
    return k; }

  public static final int 
  countInterface (final Set[] s,
                  final Number[] x) {
    int k = 0;
    final int n = s.length;
    assert n == x.length;
    for (int i=0;i<n;i++) { 
      if (s[i].contains(x[i])) { k++; } }
    return k; }

  //--------------------------------------------------------------
  // construction
  //--------------------------------------------------------------

  private Contains () {
    throw new UnsupportedOperationException(
      "can't instantiate " + getClass()); }

  ///--------------------------------------------------------------
} // end class
//--------------------------------------------------------------
