/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.bench.java.sets;

import clojure.lang.IFn;
import palisades.lakes.bench.java.sets.Set;

public final class DoubleInterval
implements Set {
    public final double min;
    public final double max;

    @Override
    public final double diameter() {
        return this.max - this.min;
    }

    @Override
    public final boolean contains(boolean x) {
        return false;
    }

    @Override
    public final boolean contains(byte x) {
        return this.min <= (double)x && (double)x < this.max;
    }

    @Override
    public final boolean contains(char x) {
        return false;
    }

    @Override
    public final boolean contains(double x) {
        return this.min <= x && x < this.max;
    }

    @Override
    public final boolean contains(float x) {
        return this.min <= (double)x && (double)x < this.max;
    }

    @Override
    public final boolean contains(int x) {
        return this.min <= (double)x && (double)x < this.max;
    }

    @Override
    public final boolean contains(long x) {
        return this.min <= (double)x && (double)x < this.max;
    }

    @Override
    public final boolean contains(short x) {
        return this.min <= (double)x && (double)x < this.max;
    }

    @Override
    public final boolean contains(Boolean x) {
        return false;
    }

    @Override
    public final boolean contains(Byte x) {
        return this.min <= (double)x.byteValue() && (double)x.byteValue() < this.max;
    }

    @Override
    public final boolean contains(Character x) {
        return false;
    }

    @Override
    public final boolean contains(Double x) {
        return this.min <= x && x < this.max;
    }

    @Override
    public final boolean contains(Float x) {
        return this.min <= (double)x.floatValue() && (double)x.floatValue() < this.max;
    }

    @Override
    public final boolean contains(Integer x) {
        return this.min <= (double)x.intValue() && (double)x.intValue() < this.max;
    }

    @Override
    public final boolean contains(Long x) {
        return this.min <= (double)x.longValue() && (double)x.longValue() < this.max;
    }

    @Override
    public final boolean contains(Short x) {
        return this.min <= (double)x.shortValue() && (double)x.shortValue() < this.max;
    }

    @Override
    public final boolean contains(Object x) {
        if (x instanceof Byte) {
            return this.contains((Byte)x);
        }
        if (x instanceof Double) {
            return this.contains((Double)x);
        }
        if (x instanceof Float) {
            return this.contains((Float)x);
        }
        if (x instanceof Integer) {
            return this.contains((Integer)x);
        }
        if (x instanceof Long) {
            return this.contains((Long)x);
        }
        if (x instanceof Short) {
            return this.contains((Short)x);
        }
        return false;
    }

    public final boolean intersects(DoubleInterval that) {
        if (this.max <= that.min) {
            return false;
        }
        return !(that.max <= this.min);
    }

    public final boolean intersects(java.util.Set that) {
        for (Object x : that) {
            if (!this.contains(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean intersects(Object set2) {
        if (set2 instanceof DoubleInterval) {
            return this.intersects((DoubleInterval)set2);
        }
        if (set2 instanceof java.util.Set) {
            return this.intersects((java.util.Set)set2);
        }
        throw new UnsupportedOperationException("intersects unsupported for " + this.getClass().getSimpleName() + ", " + set2.getClass().getSimpleName());
    }

    private DoubleInterval(double z0, double z1) {
        assert (z0 <= z1);
        this.min = z0;
        this.max = z1;
    }

    public static final DoubleInterval make(double z0, double z1) {
        assert (!Double.isNaN(z0));
        assert (!Double.isNaN(z1));
        if (z0 <= z1) {
            return new DoubleInterval(z0, z1);
        }
        return new DoubleInterval(z1, z0);
    }

    public static final DoubleInterval generate(IFn.D g) {
        double x0 = g.invokePrim();
        double x1 = g.invokePrim();
        return DoubleInterval.make(x0, x1);
    }
}

