/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.bench.java.sets;

import palisades.lakes.bench.java.sets.IntegerInterval;
import palisades.lakes.bench.java.sets.Set;

public final class Diameter {
    public static final double diameter(java.util.Set s) {
        if (1 >= s.size()) {
            return 0.0;
        }
        double smin = Double.POSITIVE_INFINITY;
        double smax = Double.NEGATIVE_INFINITY;
        for (Object x : s) {
            double xx = ((Number)x).doubleValue();
            if (Double.isNaN(xx)) {
                return Double.NaN;
            }
            if (xx < smin) {
                smin = xx;
            }
            if (!(xx > smax)) continue;
            smax = xx;
        }
        return smax - smin;
    }

    public static final double diameter(Object s) {
        if (s instanceof Set) {
            return ((Set)s).diameter();
        }
        if (s instanceof java.util.Set) {
            return Diameter.diameter((java.util.Set)s);
        }
        throw new IllegalArgumentException("no diameter method for " + s.getClass());
    }

    public static final double maxStatic(IntegerInterval[] s) {
        double dmax = Double.NEGATIVE_INFINITY;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            double d = Diameter.diameter(s[i]);
            if (!(dmax < d)) continue;
            dmax = d;
        }
        return dmax;
    }

    public static final double maxVirtual(IntegerInterval[] s) {
        double dmax = Double.NEGATIVE_INFINITY;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            double d = s[i].diameter();
            if (!(dmax < d)) continue;
            dmax = d;
        }
        return dmax;
    }

    public static final double maxInterface(Set[] s) {
        double dmax = Double.NEGATIVE_INFINITY;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            double d = s[i].diameter();
            if (!(dmax < d)) continue;
            dmax = d;
        }
        return dmax;
    }

    public static final double maxLookup(Object[] s) {
        double dmax = Double.NEGATIVE_INFINITY;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            double d = Diameter.diameter(s[i]);
            if (!(dmax < d)) continue;
            dmax = d;
        }
        return dmax;
    }

    private Diameter() {
        throw new UnsupportedOperationException("can't instantiate " + this.getClass());
    }
}

