/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.bench.java.sets;

import clojure.lang.IFn;
import palisades.lakes.bench.java.sets.ByteInterval;
import palisades.lakes.bench.java.sets.DoubleInterval;
import palisades.lakes.bench.java.sets.IntegerInterval;
import palisades.lakes.bench.java.sets.LongInterval;
import palisades.lakes.bench.java.sets.Set;
import palisades.lakes.bench.java.sets.ShortInterval;

public final class FloatInterval
implements Set {
    public final float min;
    public final float max;

    @Override
    public final double diameter() {
        return this.max - this.min;
    }

    @Override
    public final boolean contains(boolean x) {
        return false;
    }

    @Override
    public final boolean contains(byte x) {
        return this.min <= (float)x && (float)x < this.max;
    }

    @Override
    public final boolean contains(char x) {
        return false;
    }

    @Override
    public final boolean contains(double x) {
        return (double)this.min <= x && x < (double)this.max;
    }

    @Override
    public final boolean contains(float x) {
        return this.min <= x && x < this.max;
    }

    @Override
    public final boolean contains(int x) {
        return this.min <= (float)x && (float)x < this.max;
    }

    @Override
    public final boolean contains(long x) {
        return this.min <= (float)x && (float)x < this.max;
    }

    @Override
    public final boolean contains(short x) {
        return this.min <= (float)x && (float)x < this.max;
    }

    @Override
    public final boolean contains(Boolean x) {
        return false;
    }

    @Override
    public final boolean contains(Byte x) {
        return this.min <= (float)x.byteValue() && (float)x.byteValue() < this.max;
    }

    @Override
    public final boolean contains(Character x) {
        return false;
    }

    @Override
    public final boolean contains(Double x) {
        return (double)this.min <= x && x < (double)this.max;
    }

    @Override
    public final boolean contains(Float x) {
        return this.min <= x.floatValue() && x.floatValue() < this.max;
    }

    @Override
    public final boolean contains(Integer x) {
        return this.min <= (float)x.intValue() && (float)x.intValue() < this.max;
    }

    @Override
    public final boolean contains(Long x) {
        return this.min <= (float)x.longValue() && (float)x.longValue() < this.max;
    }

    @Override
    public final boolean contains(Short x) {
        return this.min <= (float)x.shortValue() && (float)x.shortValue() < this.max;
    }

    @Override
    public final boolean contains(Object x) {
        if (x instanceof Byte) {
            return this.contains((Byte)x);
        }
        if (x instanceof Double) {
            return this.contains((Double)x);
        }
        if (x instanceof Float) {
            return this.contains((Float)x);
        }
        if (x instanceof Integer) {
            return this.contains((Integer)x);
        }
        if (x instanceof Long) {
            return this.contains((Long)x);
        }
        if (x instanceof Short) {
            return this.contains((Short)x);
        }
        return false;
    }

    public final boolean intersects(ByteInterval that) {
        if (this.max <= (float)that.min) {
            return false;
        }
        return !((float)that.max <= this.min);
    }

    public final boolean intersects(DoubleInterval that) {
        if ((double)this.max <= that.min) {
            return false;
        }
        return !(that.max <= (double)this.min);
    }

    public final boolean intersects(FloatInterval that) {
        if (this.max <= that.min) {
            return false;
        }
        return !(that.max <= this.min);
    }

    public final boolean intersects(IntegerInterval that) {
        if (this.max <= (float)that.min) {
            return false;
        }
        return !((float)that.max <= this.min);
    }

    public final boolean intersects(LongInterval that) {
        if (this.max <= (float)that.min) {
            return false;
        }
        return !((float)that.max <= this.min);
    }

    public final boolean intersects(ShortInterval that) {
        if (this.max <= (float)that.min) {
            return false;
        }
        return !((float)that.max <= this.min);
    }

    public final boolean intersects(java.util.Set that) {
        for (Object x : that) {
            if (!this.contains(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean intersects(Object set2) {
        if (set2 instanceof IntegerInterval) {
            return this.intersects((IntegerInterval)set2);
        }
        if (set2 instanceof ByteInterval) {
            return this.intersects((ByteInterval)set2);
        }
        if (set2 instanceof DoubleInterval) {
            return this.intersects((DoubleInterval)set2);
        }
        if (set2 instanceof FloatInterval) {
            return this.intersects((FloatInterval)set2);
        }
        if (set2 instanceof LongInterval) {
            return this.intersects((LongInterval)set2);
        }
        if (set2 instanceof ShortInterval) {
            return this.intersects((ShortInterval)set2);
        }
        if (set2 instanceof java.util.Set) {
            return this.intersects((java.util.Set)set2);
        }
        throw new UnsupportedOperationException("intersects unsupported for " + this.getClass());
    }

    private FloatInterval(float z0, float z1) {
        assert (z0 <= z1);
        this.min = z0;
        this.max = z1;
    }

    public static final FloatInterval make(float z0, float z1) {
        assert (!Float.isNaN(z0));
        assert (!Float.isNaN(z1));
        if (z0 <= z1) {
            return new FloatInterval(z0, z1);
        }
        return new FloatInterval(z1, z0);
    }

    public static final FloatInterval generate(IFn.D g) {
        double x0 = g.invokePrim();
        assert (!Double.isNaN(x0));
        assert (Double.NEGATIVE_INFINITY < x0 && x0 < Double.POSITIVE_INFINITY) : "outside float range: " + x0;
        double x1 = g.invokePrim();
        assert (!Double.isNaN(x1));
        assert (Double.NEGATIVE_INFINITY < x1 && x1 < Double.POSITIVE_INFINITY) : "outside float range: " + x1;
        return FloatInterval.make((float)x0, (float)x1);
    }
}

