/*
 * Decompiled with CFR 0.152.
 */
package palisades.lakes.bench.java.sets;

import clojure.lang.IFn;
import palisades.lakes.bench.java.sets.ByteInterval;
import palisades.lakes.bench.java.sets.DoubleInterval;
import palisades.lakes.bench.java.sets.FloatInterval;
import palisades.lakes.bench.java.sets.IntegerInterval;
import palisades.lakes.bench.java.sets.Set;
import palisades.lakes.bench.java.sets.ShortInterval;

public final class LongInterval
implements Set {
    public final long min;
    public final long max;

    @Override
    public final double diameter() {
        return this.max - this.min;
    }

    @Override
    public final boolean contains(boolean x) {
        return false;
    }

    @Override
    public final boolean contains(byte x) {
        return this.min <= (long)x && (long)x < this.max;
    }

    @Override
    public final boolean contains(char x) {
        return false;
    }

    @Override
    public final boolean contains(double x) {
        return (double)this.min <= x && x < (double)this.max;
    }

    @Override
    public final boolean contains(float x) {
        return (float)this.min <= x && x < (float)this.max;
    }

    @Override
    public final boolean contains(int x) {
        return this.min <= (long)x && (long)x < this.max;
    }

    @Override
    public final boolean contains(long x) {
        return this.min <= x && x < this.max;
    }

    @Override
    public final boolean contains(short x) {
        return this.min <= (long)x && (long)x < this.max;
    }

    @Override
    public final boolean contains(Boolean x) {
        return false;
    }

    @Override
    public final boolean contains(Byte x) {
        return this.min <= (long)x.byteValue() && (long)x.byteValue() < this.max;
    }

    @Override
    public final boolean contains(Character x) {
        return false;
    }

    @Override
    public final boolean contains(Double x) {
        return (double)this.min <= x && x < (double)this.max;
    }

    @Override
    public final boolean contains(Float x) {
        return (float)this.min <= x.floatValue() && x.floatValue() < (float)this.max;
    }

    @Override
    public final boolean contains(Integer x) {
        return this.min <= (long)x.intValue() && (long)x.intValue() < this.max;
    }

    @Override
    public final boolean contains(Long x) {
        return this.min <= x && x < this.max;
    }

    @Override
    public final boolean contains(Short x) {
        return this.min <= (long)x.shortValue() && (long)x.shortValue() < this.max;
    }

    @Override
    public final boolean contains(Object x) {
        if (x instanceof Byte) {
            return this.contains((Byte)x);
        }
        if (x instanceof Double) {
            return this.contains((Double)x);
        }
        if (x instanceof Float) {
            return this.contains((Float)x);
        }
        if (x instanceof Integer) {
            return this.contains((Integer)x);
        }
        if (x instanceof Long) {
            return this.contains((Long)x);
        }
        if (x instanceof Short) {
            return this.contains((Short)x);
        }
        return false;
    }

    public final boolean intersects(ByteInterval that) {
        if (this.max <= (long)that.min) {
            return false;
        }
        return (long)that.max > this.min;
    }

    public final boolean intersects(DoubleInterval that) {
        if ((double)this.max <= that.min) {
            return false;
        }
        return !(that.max <= (double)this.min);
    }

    public final boolean intersects(FloatInterval that) {
        if ((float)this.max <= that.min) {
            return false;
        }
        return !(that.max <= (float)this.min);
    }

    public final boolean intersects(IntegerInterval that) {
        if (this.max <= (long)that.min) {
            return false;
        }
        return (long)that.max > this.min;
    }

    public final boolean intersects(LongInterval that) {
        if (this.max <= that.min) {
            return false;
        }
        return that.max > this.min;
    }

    public final boolean intersects(ShortInterval that) {
        if (this.max <= (long)that.min) {
            return false;
        }
        return (long)that.max > this.min;
    }

    public final boolean intersects(java.util.Set that) {
        for (Object x : that) {
            if (!this.contains(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean intersects(Object set2) {
        if (set2 instanceof IntegerInterval) {
            return this.intersects((IntegerInterval)set2);
        }
        if (set2 instanceof ByteInterval) {
            return this.intersects((ByteInterval)set2);
        }
        if (set2 instanceof DoubleInterval) {
            return this.intersects((DoubleInterval)set2);
        }
        if (set2 instanceof FloatInterval) {
            return this.intersects((FloatInterval)set2);
        }
        if (set2 instanceof LongInterval) {
            return this.intersects((LongInterval)set2);
        }
        if (set2 instanceof ShortInterval) {
            return this.intersects((ShortInterval)set2);
        }
        if (set2 instanceof java.util.Set) {
            return this.intersects((java.util.Set)set2);
        }
        throw new UnsupportedOperationException("intersects unsupported for " + this.getClass());
    }

    private LongInterval(long i0, long i1) {
        assert (i0 <= i1);
        this.min = i0;
        this.max = i1;
    }

    public static final LongInterval make(long i0, long i1) {
        if (i0 <= i1) {
            return new LongInterval(i0, i1);
        }
        return new LongInterval(i1, i0);
    }

    public static final LongInterval generate(IFn.L g) {
        long x0 = g.invokePrim();
        long x1 = g.invokePrim();
        return LongInterval.make(x0, x1);
    }
}

