/*
 * Decompiled with CFR 0.152.
 */
package faster.multimethods.java;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.RT;
import clojure.lang.Util;
import clojure.lang.Var;
import faster.multimethods.java.MultiFn;
import faster.multimethods.java.signature.Signature;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class MultiFnWoutHierarchy
extends AFn
implements MultiFn {
    private final IFn dispatchFn;
    private final String name;
    private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
    private volatile Map methodTable;
    private volatile Map preferTable;
    private Map methodCache;
    private static final Var parents = RT.var((String)"clojure.core", (String)"parents");

    public MultiFnWoutHierarchy(String n, IFn dispatchF) {
        this.name = n;
        this.dispatchFn = dispatchF;
        this.methodTable = Collections.emptyMap();
        this.methodCache = Collections.emptyMap();
        this.preferTable = Collections.emptyMap();
    }

    @Override
    public IPersistentMap getMethodTable() {
        return PersistentHashMap.create((Map)this.methodTable);
    }

    @Override
    public IPersistentMap getPreferTable() {
        Set ks = this.preferTable.keySet();
        Object[] kvs = new Object[2 * ks.size()];
        int i = 0;
        for (Object k : ks) {
            kvs[i++] = k;
            Set v = (Set)this.preferTable.get(k);
            kvs[i++] = PersistentHashSet.create((Object[])v.toArray());
        }
        return PersistentHashMap.create((Object[])kvs);
    }

    @Override
    public MultiFn reset() {
        this.rw.writeLock().lock();
        try {
            this.methodTable = Collections.emptyMap();
            this.methodCache = Collections.emptyMap();
            this.preferTable = Collections.emptyMap();
            MultiFnWoutHierarchy multiFnWoutHierarchy = this;
            return multiFnWoutHierarchy;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    private static final Map assoc(Map m, Object k, Object v) {
        HashMap<Object, Object> b = new HashMap<Object, Object>(m);
        b.put(k, v);
        return b;
    }

    private static final Map dissoc(Map m, Object k) {
        HashMap b = new HashMap(m);
        b.remove(k);
        return b;
    }

    private static final Set add(Set s, Object v) {
        if (null == s) {
            return Collections.singleton(v);
        }
        HashSet<Object> b = new HashSet<Object>(s);
        b.add(v);
        return b;
    }

    private static final Map add(Map m, Object k, Object v) {
        HashMap<Object, Set> b = new HashMap<Object, Set>(m);
        b.put(k, MultiFnWoutHierarchy.add((Set)b.get(k), v));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiFn addMethod(Object dispatch, IFn method) {
        this.rw.writeLock().lock();
        try {
            this.methodTable = MultiFnWoutHierarchy.assoc(this.methodTable, dispatch, method);
            this.resetCache();
            MultiFnWoutHierarchy multiFnWoutHierarchy = this;
            return multiFnWoutHierarchy;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    @Override
    public MultiFn removeMethod(Object dispatch) {
        this.rw.writeLock().lock();
        try {
            this.methodTable = MultiFnWoutHierarchy.dissoc(this.methodTable, dispatch);
            this.resetCache();
            MultiFnWoutHierarchy multiFnWoutHierarchy = this;
            return multiFnWoutHierarchy;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    private boolean prefers(Object x, Object y) {
        Set xprefs = (Set)this.preferTable.get(x);
        if (xprefs != null) {
            if (xprefs.contains(y)) {
                return true;
            }
            for (Object xx : xprefs) {
                if (!this.prefers(xx, y)) continue;
                return true;
            }
        }
        for (ISeq ps = RT.seq((Object)parents.invoke(x)); ps != null; ps = ps.next()) {
            if (!this.prefers(ps.first(), y)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiFn preferMethod(Object dispatchX, Object dispatchY) {
        this.rw.writeLock().lock();
        try {
            if (this.prefers(dispatchY, dispatchX)) {
                throw new IllegalStateException(String.format("Preference conflict in multimethod '%s':%s is already preferred to %s", this.name, dispatchY, dispatchX));
            }
            this.preferTable = MultiFnWoutHierarchy.add(this.preferTable, dispatchX, dispatchY);
            this.resetCache();
            MultiFnWoutHierarchy multiFnWoutHierarchy = this;
            return multiFnWoutHierarchy;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    private static final boolean isA(Class child, Class parent) {
        return parent.isAssignableFrom(child);
    }

    private static final boolean isA(Signature child, Signature parent) {
        return parent.isAssignableFrom(child);
    }

    private static final boolean isA(IPersistentVector child, IPersistentVector parent) {
        int n = child.length();
        if (n != parent.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (MultiFnWoutHierarchy.isA(child.nth(i), parent.nth(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isA(Object child, Object parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (child instanceof Class && parent instanceof Class) {
            return MultiFnWoutHierarchy.isA((Class)child, (Class)parent);
        }
        if (child instanceof Signature && parent instanceof Signature) {
            return MultiFnWoutHierarchy.isA((Signature)child, (Signature)parent);
        }
        if (child instanceof IPersistentVector && parent instanceof IPersistentVector) {
            return MultiFnWoutHierarchy.isA((IPersistentVector)child, (IPersistentVector)parent);
        }
        return false;
    }

    private boolean dominates(Object x, Object y) {
        return this.prefers(x, y) || MultiFnWoutHierarchy.isA(x, y);
    }

    private Map resetCache() {
        this.rw.writeLock().lock();
        try {
            Map map2 = this.methodCache = this.methodTable;
            return map2;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFn findAndCacheBestMethod(Object dispatch) {
        Object bestValue;
        this.rw.readLock().lock();
        Map mt = this.methodTable;
        Map pt = this.preferTable;
        try {
            Map.Entry bestEntry = null;
            for (Map.Entry o : this.methodTable.entrySet()) {
                Map.Entry e = o;
                if (!MultiFnWoutHierarchy.isA(dispatch, e.getKey())) continue;
                if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                    bestEntry = e;
                }
                if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
                throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match dispatch value: %s -> %s and %s, and neither is preferred", this.name, dispatch, e.getKey(), bestEntry.getKey()));
            }
            if (null == bestEntry) {
                Iterator iterator = null;
                return iterator;
            }
            bestValue = bestEntry.getValue();
        }
        finally {
            this.rw.readLock().unlock();
        }
        this.rw.writeLock().lock();
        try {
            IFn iFn;
            if (mt == this.methodTable && pt == this.preferTable) {
                this.methodCache = MultiFnWoutHierarchy.assoc(this.methodCache, dispatch, bestValue);
                iFn = (IFn)bestValue;
                return iFn;
            }
            this.resetCache();
            iFn = this.findAndCacheBestMethod(dispatch);
            return iFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    @Override
    public IFn getMethod(Object dispatch) {
        IFn targetFn = (IFn)this.methodCache.get(dispatch);
        if (targetFn != null) {
            return targetFn;
        }
        return this.findAndCacheBestMethod(dispatch);
    }

    private IFn getFn(Object dispatch) {
        IFn targetFn = this.getMethod(dispatch);
        if (targetFn == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for dispatch value: %s", this.name, dispatch));
        }
        return targetFn;
    }

    public final Object invoke() {
        return this.getFn(this.dispatchFn.invoke()).invoke();
    }

    public final Object invoke(Object arg1) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1));
        Object object = arg1;
        arg1 = null;
        return iFn.invoke(Util.ret1((Object)object, null));
    }

    public final Object invoke(Object arg1, Object arg2) {
        Object k = this.dispatchFn.invoke(arg1, arg2);
        IFn f = this.getMethod(k);
        assert (null != f);
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        return f.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null), Util.ret1((Object)object17, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null), Util.ret1((Object)object17, null), Util.ret1((Object)object18, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null), Util.ret1((Object)object17, null), Util.ret1((Object)object18, null), Util.ret1((Object)object19, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null), Util.ret1((Object)object17, null), Util.ret1((Object)object18, null), Util.ret1((Object)object19, null), Util.ret1((Object)object20, null));
    }

    public final Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1((Object)object, null), Util.ret1((Object)object2, null), Util.ret1((Object)object3, null), Util.ret1((Object)object4, null), Util.ret1((Object)object5, null), Util.ret1((Object)object6, null), Util.ret1((Object)object7, null), Util.ret1((Object)object8, null), Util.ret1((Object)object9, null), Util.ret1((Object)object10, null), Util.ret1((Object)object11, null), Util.ret1((Object)object12, null), Util.ret1((Object)object13, null), Util.ret1((Object)object14, null), Util.ret1((Object)object15, null), Util.ret1((Object)object16, null), Util.ret1((Object)object17, null), Util.ret1((Object)object18, null), Util.ret1((Object)object19, null), Util.ret1((Object)object20, null), args);
    }
}

