(ns leiningen.new.pancang
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "pancang"))

(defn pancang
  "FIXME: write documentation"
  [name]
  (println "Pancang 0.1.1")
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' pancang project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render ".gitignore")]
             [".hgignore" (render ".hgignore")]
             ["LICENSE" (render "LICENSE")]
             ;;config
             ["config/config.edn" (render "config/config.edn")]
             ["config/logback.xml" (render "config/logback.xml")]
             ;;dev
             ["dev/user.clj" (render "dev/user.clj" data)]
             ["dev/dev.clj" (render "dev/dev.clj" data)]
             ;;resources
             ["resources/public/style.css" (render "resources/public/style.css")]
             ;;server source
             ["src/clj/{{sanitized}}/system.clj" (render "src/clj/bank/system.clj" data)]
             ["src/clj/{{sanitized}}/server.clj" (render "src/clj/bank/server.clj" data)]
             ["src/clj/{{sanitized}}/service.clj" (render "src/clj/bank/service.clj" data)]
             ["src/clj/{{sanitized}}/routes.clj" (render "src/clj/bank/routes.clj" data)]
             ["src/clj/{{sanitized}}/app/api.clj" (render "src/clj/bank/app/api.clj" data)]
             ["src/clj/{{sanitized}}/app/app.clj" (render "src/clj/bank/app/app.clj" data)]
             ;;cljs source
             ["src/cljs/{{sanitized}}/config.cljs" (render "src/cljs/pancang/config.cljs" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "src/cljs/pancang/core.cljs" data)]
             ["src/cljs/{{sanitized}}/db.cljs" (render "src/cljs/pancang/db.cljs" data)]
             ["src/cljs/{{sanitized}}/handlers.cljs" (render "src/cljs/pancang/handlers.cljs" data)]
             ["src/cljs/{{sanitized}}/routes.cljs" (render "src/cljs/pancang/routes.cljs" data)]
             ["src/cljs/{{sanitized}}/subs.cljs" (render "src/cljs/pancang/subs.cljs" data)]
             ["src/cljs/{{sanitized}}/views.cljs" (render "src/cljs/pancang/views.cljs" data)]
             )))
