(defproject pandeiro/re-frame "0.10.3"
  :description  "A fork of the Clojurescript MVC-like Framework For Writing SPAs Using Reagent, without tests bundled (so it compiles on CLJS 1.9.671)"
  :url          "http://github.com/Day8/re-frame.git"
  :license      {:name "MIT"}
  :dependencies [[org.clojure/clojure        "1.8.0"]
                 [org.clojure/clojurescript  "1.9.908"]
                 [reagent                    "0.7.0"]
                 [net.cgrand/macrovich       "0.2.0"]
                 [org.clojure/tools.logging  "0.3.1"]]

  :profiles {:debug {:debug true}}

  :clean-targets  [:target-path "run/compiled"]

  :resource-paths ["run/resources"]
  :jvm-opts       ["-Xmx1g" "-XX:+UseConcMarkSweepGC"]
  :source-paths   ["src"]

  :deploy-repositories [["releases"  {:sign-releases false :url "https://clojars.org/repo"}]
                        ["snapshots" {:sign-releases false :url "https://clojars.org/repo"}]])
