(defproject parkside-securities/abracad "0.4.15"
  :description "De/serialize Clojure data structures with Avro."
  :url "http://github.com/parkside-securities/abracad"
  :licenses [{:name "Eclipse Public License"
              :url "http://www.eclipse.org/legal/epl-v10.html"}
             {:name "Apache License, Version 2.0"
              :url "http://www.apache.org/licenses/LICENSE-2.0.html"}]
  :global-vars {*warn-on-reflection* true}
  :source-paths ["src/clojure"]
  :java-source-paths ["src/java"]
  :javac-options ["-target" "1.7" "-source" "1.7"]
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.apache.avro/avro "1.8.0"]
                 [cheshire/cheshire "5.6.1"]]
  :plugins [[lein-release "1.0.5"]]
  :codox {:include [abracad.avro abracad.avro.edn]}
  :aliases {"test-all" ["with-profile" ~(str "clojure-1-6:"
                                             "clojure-1-7:"
                                             "clojure-1-8")
                        "test"]}
  :profiles {:clojure-1-6 {:dependencies
                           [[org.clojure/clojure "1.6.0"]]}
             :clojure-1-7 {:dependencies
                           [[org.clojure/clojure "1.7.0"]]}
             :clojure-1-8 {:dependencies
                           [[org.clojure/clojure "1.8.0"]]}})
