# hydrox, Parkside Style

[![Build Status](https://travis-ci.com/parkside-securities/hydrox.svg?branch=master)](https://travis-ci.org/helpshift/hydrox)

dive deeper into your code

[![hydrox logo](https://raw.githubusercontent.com/helpshift/hydrox/master/template/assets/img/big.png)](http://helpshift.github.io/hydrox)

## Installation

### Deps Project:
1. In your `deps.edn`, add `hydrox` and `fudje` (optional, for more readable tests) to the `dev` alias:
```clojure
  :dev      {:extra-deps
             {parkside-securities/repl-bootstrap {:git/url "git@github.com:parkside-securities/repl-bootstrap.git"
                                                  :sha     "4950c722bd306a06a5e51a1471889fd4bfcd6aa7"}
              floatingpointio/graphql-builder    {:mvn/version "0.1.6"}
              fudje                              {:mvn/version "0.9.7"}
              parkside-securities/hydrox         {:mvn/version "0.10.36-SNAPSHOT"}}
```
2. Create the `:documentation` map in your `deps.edn`. This is how Hydrox knows where to put generated documents:
```clojure
:documentation {:site   "test-docs"
                 :output "docs"
                 :template {:path "template"
                            :copy ["assets"]
                            :defaults {:template     "article.html"
                                       :navbar       [:file "partials/navbar.html"]
                                       :dependencies [:file "partials/deps-web.html"]
                                       :navigation   :navigation
                                       :article      :article}}
                 :paths ["test"]
                 :files {"test-docs-name"
                         {:input "test/your_app/docs_test.clj"
                          :title "Your App Tests"
                          :subtitle "change these for your app."}}}}

```
3. Create the `docs` folder in your project. Intialize with a `docs/.gitignore` that includes the following lines:
```
*
*/
!.gitignore
# docs contents are generated by hydrox and copied to docker image at runtime 
# generated artifacts shouldn't be checked into git in general.
```

4. Create the `template` folder and copy the templates and assets from this project into it so the documentation generator can access them and they will have a standardized look.

5. Set up the server for your new files as follows:
- If you do not already have the latest [pedestal](https://github.com/parkside-securities/pedestal) in your project, add it to deps.edn,
  then add to your project according to the pedestal README.
- In your `config.edn`, configure pedestal to include a `:file-path` like so:
```clojure
:pedestal/service {:service-map  #ig/ref :your-app.pedestal/service
                   :interceptors [whatever the interceptors already were if you've got 'em']
                   :dev?         #duct/env "PEDESTAL_SERVICE_DEV"
                   :file-path    "docs"}
```

6. Open the repl with `clj -A:dev -e "(dev)(go)" -r`

7. In the repl run:
```clojure
(use 'hydrox.core)
(dive)
(generate-docs)
```
If you have correctly formatted your `:documentation` map, docs should be generated into your `docs` folder!
If you have correctly set up your pedestal server, you should be able to see the docs at `localhost:PORT/test-docs-name.html`!

8. Once it looks good, add the docs generation step to the project's wercker.yml:
```yaml
 - script:
        name: generate docs
        code: clojure -A:dev -e "(use 'hydrox.core) (dive) (generate-docs) (System/exit 0)"
```


### Lein Project:
In your `project.clj`, add hydrox to the `[:profiles :dev :dependencies]` entry:  

```clojure
(defproject ...
  ...
  :plugins ["lein-hydrox" "0.1.15"]
  :profiles {:dev {:dependencies [...
                                  [helpshift/hydrox "0.1.15"]
                                  ...]}}
  ...)
```

## Leiningen

To initialise a project:

```shell
lein hydrox init
```

To generate documentation (watches project for changes and updates documentation accordingly):

```shell
lein hydrox
```

## Original-flavor Hydrox Tutorials

- [0 - Introduction](https://youtu.be/3MIaucjfJcE)
- [1 - Getting Started](https://youtu.be/p93LmHOzy6Q)

## Overview 

[hydrox](https://www.github.com/helpshift/hydrox) assists in the transmission of knowledge around a clojure project, providing in-repl management of documentation, docstrings and metadata through the reuse/repurposing of test code. The tool allows for a design-orientated workflow for the programming process, blurring the boundaries between design, development, testing and documentation.

![hydrox overview](https://raw.githubusercontent.com/helpshift/hydrox/master/template/assets/img/hydrox-overview.png)

Please see the [docs](http://helpshift.github.io/hydrox) for more information (generated using itself).

## Links and References:

- the generated website for [hara](https://www.github.com/zcaudate/hara) can be seen [here](http://docs.caudate.me/hara)

- the `.html` [output](http://helpshift.github.io/hydrox/sample-document.html) can be seen for a sample `.clj` [input](https://github.com/helpshift/hydrox/blob/master/test/documentation/sample_document.clj)

## License

Copyright © 2015 [Helpshift](https://www.helpshift.com/)

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
