package pbalduino.cljqldb.helper;

import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.qldbsession.AmazonQLDBSessionClientBuilder;

import software.amazon.qldb.exceptions.QldbClientException;
import software.amazon.qldb.PooledQldbDriver;
import software.amazon.qldb.QldbDriver;
import software.amazon.qldb.QldbSession;

public final class Driver {
  private Driver() {}

  public static PooledQldbDriver createQldbDriver(final String ledgerName, final int retries) {
    AmazonQLDBSessionClientBuilder builder = AmazonQLDBSessionClientBuilder.standard();

    builder.setCredentials(DefaultAWSCredentialsProviderChain.getInstance());

    System.out.println("[clj-qldb] Logging builder: " + builder);
    System.out.println("[clj-qldb] Logging credentials: " + DefaultAWSCredentialsProviderChain.getInstance().getCredentials());

    PooledQldbDriver driver = PooledQldbDriver.builder()
            .withLedger(ledgerName)
            .withRetryLimit(retries)
            .withSessionClientBuilder(builder)
            .build();

    System.out.println("[clj-qldb] Logging driver: " + driver);

    return driver;
  }
}
