/*
 * Decompiled with CFR 0.152.
 */
package processing.svg;

import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PSurface;
import processing.core.PSurfaceNone;

public class PGraphicsSVG
extends PGraphicsJava2D {
    protected File file;
    protected OutputStream output;

    @Override
    public void setPath(String string) {
        this.path = string;
        if (string != null) {
            this.file = new File(string);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsSVG requires an absolute path for the location of the output file.");
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    @Override
    public PSurface createSurface() {
        this.surface = new PSurfaceNone(this);
        return this.surface;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.textMode = 5;
    }

    @Override
    public void beginDraw() {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        String string = "http://www.w3.org/2000/svg";
        Document document = dOMImplementation.createDocument(string, "svg", null);
        this.g2 = new SVGGraphics2D(document);
        ((SVGGraphics2D)this.g2).setSVGCanvasSize(new Dimension(this.width, this.height));
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
        this.pushMatrix();
    }

    @Override
    public void endDraw() {
        this.popMatrix();
        if (this.output == null) {
            if (this.path == null) {
                throw new RuntimeException("setOutput() or setPath() must be used with the SVG renderer");
            }
            File file = this.parent.saveFile(this.parent.insertFrame(this.path));
            try {
                this.output = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
        boolean bl = true;
        PrintWriter printWriter = PApplet.createWriter(this.output);
        try {
            ((SVGGraphics2D)this.g2).stream(printWriter, bl);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            sVGGraphics2DIOException.printStackTrace();
        }
        try {
            try {
                ((Writer)printWriter).flush();
                ((Writer)printWriter).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.output = null;
            }
        }
        finally {
            this.output = null;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean displayable() {
        return false;
    }

    @Override
    public void loadPixels() {
        this.nope("loadPixels");
    }

    @Override
    public void updatePixels() {
        this.nope("updatePixels");
    }

    @Override
    public void updatePixels(int n, int n2, int n3, int n4) {
        this.nope("updatePixels");
    }

    @Override
    public int get(int n, int n2) {
        this.nope("get");
        return 0;
    }

    @Override
    public PImage get(int n, int n2, int n3, int n4) {
        this.nope("get");
        return null;
    }

    @Override
    public PImage get() {
        this.nope("get");
        return null;
    }

    @Override
    public void set(int n, int n2, int n3) {
        this.nope("set");
    }

    @Override
    public void set(int n, int n2, PImage pImage) {
        this.nope("set");
    }

    @Override
    public void mask(int[] nArray) {
        this.nope("mask");
    }

    @Override
    public void mask(PImage pImage) {
        this.nope("mask");
    }

    @Override
    public void filter(int n) {
        this.nope("filter");
    }

    @Override
    public void filter(int n, float f) {
        this.nope("filter");
    }

    @Override
    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    @Override
    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    @Override
    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    @Override
    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    @Override
    public boolean save(String string) {
        this.nope("save");
        return false;
    }

    protected void nope(String string) {
        throw new RuntimeException("No " + string + "() for PGraphicsSVG");
    }
}

