/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2tex.Misc;
import tla2tex.Symbol;

public final class BuiltInSymbols {
    private static Hashtable builtInHashTable = new Hashtable(200);
    private static Hashtable prefixHashTable = new Hashtable(700);
    private static Hashtable pcalBuiltInHashTable = new Hashtable(200);
    private static Hashtable pcalPrefixHashTable = new Hashtable(700);
    private static Hashtable stringCharTable = new Hashtable(100);
    private static Hashtable canPrecedeLabelTable = new Hashtable(15);
    private static String nullString = "";
    public static String pcalLeftParen = "\u0000";
    public static String pcalRightParen = "\u0001";
    public static String pcalLeftBrace = "\u0002";
    public static String pcalRightBrace = "\u0003";

    public static void Initialize() {
        BuiltInSymbols.buildHashTable();
        BuiltInSymbols.buildPrefixHashTable();
        BuiltInSymbols.buildStringCharTable();
        BuiltInSymbols.buildCanPrecedeLabelTable();
    }

    public static boolean IsBuiltInSymbol(String str) {
        return null != BuiltInSymbols.GetBuiltInSymbol(str);
    }

    public static boolean IsBuiltInSymbol(String str, boolean pcalMode) {
        return null != BuiltInSymbols.GetBuiltInSymbol(str, pcalMode);
    }

    public static Symbol GetBuiltInSymbol(String str, boolean pcalMode) {
        Symbol sym2 = pcalMode ? (Symbol)pcalBuiltInHashTable.get(str) : (Symbol)builtInHashTable.get(str);
        if (sym2 == null || sym2.pcal && !pcalMode) {
            return null;
        }
        return sym2;
    }

    public static Symbol GetBuiltInSymbol(String str) {
        return (Symbol)builtInHashTable.get(str);
    }

    public static boolean IsBuiltInPrefix(String str) {
        return prefixHashTable.containsKey(str);
    }

    public static boolean IsBuiltInPrefix(String str, boolean pcal) {
        if (pcal) {
            return pcalPrefixHashTable.containsKey(str);
        }
        return prefixHashTable.containsKey(str);
    }

    public static boolean IsStringChar(char ch) {
        return stringCharTable.containsKey(String.valueOf(ch));
    }

    public static boolean CanPrecedeLabel(String str) {
        return canPrecedeLabelTable.containsKey(str);
    }

    private static void buildStringCharTable() {
        String legalChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ ~!@#$%^&*()_-+={}[]|:;<,>.?/`'0123456789";
        for (int n = 0; n < legalChars.length(); ++n) {
            stringCharTable.put(String.valueOf(legalChars.charAt(n)), nullString);
        }
    }

    private static void buildCanPrecedeLabelTable() {
        String[] canPrecedeLabel = new String[]{";", ")", "{", "begin", "do", "either", "or", "then", "else", "elsif"};
        for (int i = 0; i < canPrecedeLabel.length; ++i) {
            canPrecedeLabelTable.put(canPrecedeLabel[i], nullString);
        }
    }

    private static void add(String tla, String tex, int stype, int atype) {
        builtInHashTable.put(tla, new Symbol(tla, tex, stype, atype));
        pcalBuiltInHashTable.put(tla, new Symbol(tla, tex, stype, atype));
    }

    private static void pcaladd(String tla, String tex, int stype, int atype) {
        pcalBuiltInHashTable.put(tla, new Symbol(tla, tex, stype, atype, true));
    }

    private static void buildHashTable() {
        BuiltInSymbols.add("_", "\\_", 7, 0);
        BuiltInSymbols.add("ASSUMPTION", "{\\ASSUMPTION}", 7, 0);
        BuiltInSymbols.add("AXIOM", "{\\AXIOM}", 7, 0);
        BuiltInSymbols.add("BOOLEAN", "{\\BOOLEAN}", 7, 0);
        BuiltInSymbols.add("CASE", "{\\CASE}", 1, 60);
        BuiltInSymbols.add("CONSTANT", "{\\CONSTANT}", 7, 0);
        BuiltInSymbols.add("CONSTANTS", "{\\CONSTANTS}", 7, 0);
        BuiltInSymbols.add("EXCEPT", "{\\EXCEPT}", 7, 0);
        BuiltInSymbols.add("EXTENDS", "{\\EXTENDS}", 7, 0);
        BuiltInSymbols.add("FALSE", "{\\FALSE}", 7, 0);
        BuiltInSymbols.add("IF", "{\\IF}", 7, 0);
        BuiltInSymbols.add("INSTANCE", "{\\INSTANCE}", 7, 0);
        BuiltInSymbols.add("LOCAL", "{\\LOCAL}", 7, 0);
        BuiltInSymbols.add("MODULE", "{\\MODULE}", 7, 0);
        BuiltInSymbols.add("OTHER", "{\\OTHER}", 7, 0);
        BuiltInSymbols.add("STRING", "{\\STRING}", 7, 0);
        BuiltInSymbols.add("THEOREM", "{\\THEOREM}", 7, 0);
        BuiltInSymbols.add("TRUE", "{\\TRUE}", 7, 0);
        BuiltInSymbols.add("VARIABLE", "{\\VARIABLE}", 7, 0);
        BuiltInSymbols.add("VARIABLES", "{\\VARIABLES}", 7, 0);
        BuiltInSymbols.add("WITH", "{\\WITH}", 7, 0);
        BuiltInSymbols.add("BY", "{\\BY}", 7, 0);
        BuiltInSymbols.add("OBVIOUS", "{\\OBVIOUS}", 7, 0);
        BuiltInSymbols.add("HAVE", "{\\HAVE}", 7, 0);
        BuiltInSymbols.add("QED", "{\\QED}", 7, 0);
        BuiltInSymbols.add("TAKE", "{\\TAKE}", 7, 0);
        BuiltInSymbols.add("DEF", "{\\DEF}", 7, 0);
        BuiltInSymbols.add("HIDE", "{\\HIDE}", 7, 0);
        BuiltInSymbols.add("RECURSIVE", "{\\RECURSIVE}", 7, 0);
        BuiltInSymbols.add("USE", "{\\USE}", 7, 0);
        BuiltInSymbols.add("DEFINE", "{\\DEFINE}", 7, 0);
        BuiltInSymbols.add("PROOF", "{\\PROOF}", 7, 0);
        BuiltInSymbols.add("WITNESS", "{\\WITNESS}", 7, 0);
        BuiltInSymbols.add("PICK", "{\\PICK}", 7, 0);
        BuiltInSymbols.add("DEFS", "{\\DEFS}", 7, 0);
        BuiltInSymbols.add("SUFFICES", "{\\SUFFICES}", 7, 0);
        BuiltInSymbols.add("NEW", "{\\NEW}", 7, 0);
        BuiltInSymbols.add("LAMBDA", "{\\LAMBDA}", 7, 0);
        BuiltInSymbols.add("STATE", "{\\STATE}", 7, 0);
        BuiltInSymbols.add("ACTION", "{\\ACTION}", 7, 0);
        BuiltInSymbols.add("TEMPORAL", "{\\TEMPORAL}", 7, 0);
        BuiltInSymbols.add("ONLY", "{\\ONLY}", 7, 0);
        BuiltInSymbols.add("OMITTED", "{\\OMITTED}", 7, 0);
        BuiltInSymbols.add("ONLY", "{\\ONLY}", 7, 0);
        BuiltInSymbols.add("LEMMA", "{\\LEMMA}", 7, 0);
        BuiltInSymbols.add("PROPOSITION", "{\\PROPOSITION}", 7, 0);
        BuiltInSymbols.add("COROLLARY", "{\\COROLLARY}", 7, 0);
        BuiltInSymbols.add("WF_", "{\\WF}", 6, 0);
        BuiltInSymbols.add("SF_", "{\\SF}", 6, 0);
        BuiltInSymbols.add(">>_", "{\\rangle}", 6, 0);
        BuiltInSymbols.add("]_", "]", 6, 0);
        BuiltInSymbols.add("(", "(", 4, 0);
        BuiltInSymbols.add("[", "[", 4, 0);
        BuiltInSymbols.add("{", "\\{", 4, 0);
        BuiltInSymbols.add("<<", "{\\langle}", 4, 0);
        BuiltInSymbols.add(")", ")", 5, 0);
        BuiltInSymbols.add("}", "\\}", 5, 0);
        BuiltInSymbols.add("]", "]", 5, 0);
        BuiltInSymbols.add(">>", "{\\rangle}", 5, 0);
        BuiltInSymbols.add("\\A", "\\A\\,", 2, 0);
        BuiltInSymbols.add("\\forall", "\\forall\\,", 2, 0);
        BuiltInSymbols.add("\\E", "\\E\\,", 2, 0);
        BuiltInSymbols.add("\\exists", "\\exists\\,", 2, 0);
        BuiltInSymbols.add("\\AA", "{\\AA}", 2, 0);
        BuiltInSymbols.add("\\EE", "{\\EE}", 2, 0);
        BuiltInSymbols.add("~", "{\\lnot}", 2, 0);
        BuiltInSymbols.add("\\lnot", "{\\lnot}", 2, 0);
        BuiltInSymbols.add("\\neg", "{\\neg}", 2, 0);
        BuiltInSymbols.add("<>", "{\\Diamond}", 2, 0);
        BuiltInSymbols.add("CHOOSE", "{\\CHOOSE}", 2, 0);
        BuiltInSymbols.add("ENABLED", "{\\ENABLED}", 2, 0);
        BuiltInSymbols.add("UNCHANGED", "{\\UNCHANGED}", 2, 0);
        BuiltInSymbols.add("SUBSET", "{\\SUBSET}", 2, 0);
        BuiltInSymbols.add("UNION", "{\\UNION}", 2, 0);
        BuiltInSymbols.add("DOMAIN", "{\\DOMAIN}", 2, 0);
        BuiltInSymbols.add("'", "\\.{'}", 3, 0);
        BuiltInSymbols.add("^+", "\\.{\\mbox{}^+}", 3, 0);
        BuiltInSymbols.add("^*", "\\.{\\mbox{}^*}", 3, 0);
        BuiltInSymbols.add("^#", "\\.{\\mbox{}^{\\#}}", 3, 0);
        BuiltInSymbols.add("=>", "\\.{\\implies}", 1, 1);
        BuiltInSymbols.add("\\cdot", "\\.{\\cdot}", 1, 2);
        BuiltInSymbols.add("<=>", "\\.{\\equiv}", 1, 3);
        BuiltInSymbols.add("\\equiv", "\\.{\\equiv}", 1, 4);
        BuiltInSymbols.add("~>", "\\.{\\leadsto}", 1, 5);
        BuiltInSymbols.add("-+->", "\\.{\\whileop}", 1, 6);
        BuiltInSymbols.add("\\subseteq", "\\.{\\subseteq}", 1, 7);
        BuiltInSymbols.add("\\subset", "\\.{\\subset}", 1, 7);
        BuiltInSymbols.add("\\supset", "\\.{\\supset}", 1, 7);
        BuiltInSymbols.add("\\supseteq", "\\.{\\supseteq}", 1, 7);
        BuiltInSymbols.add("\\ll", "\\.{\\ll}", 1, 8);
        BuiltInSymbols.add("\\gg", "\\.{\\gg}", 1, 8);
        BuiltInSymbols.add("\\", "\\.{\\,\\backslash\\,}", 1, 9);
        BuiltInSymbols.add("\\cap", "\\.{\\cap}", 1, 10);
        BuiltInSymbols.add("\\intersect", "\\.{\\cap}", 1, 11);
        BuiltInSymbols.add("\\cup", "\\.{\\cup}", 1, 12);
        BuiltInSymbols.add("\\union", "\\.{\\cup}", 1, 13);
        BuiltInSymbols.add("/\\", "\\.{\\land}", 1, 14);
        BuiltInSymbols.add("\\/", "\\.{\\lor}", 1, 15);
        BuiltInSymbols.add("\\land", "\\.{\\land}", 1, 16);
        BuiltInSymbols.add("\\lor", "\\.{\\lor}", 1, 17);
        BuiltInSymbols.add("\\X", "\\.{\\times}", 1, 18);
        BuiltInSymbols.add("-", "\\.{-}", 1, 19);
        BuiltInSymbols.add("+", "\\.{+}", 1, 19);
        BuiltInSymbols.add("*", "\\.{*}", 1, 20);
        BuiltInSymbols.add("/", "\\.{/}", 1, 21);
        BuiltInSymbols.add("^", "\\.{\\ct}", 1, 22);
        BuiltInSymbols.add("|", "\\.{\\,|\\,}", 1, 23);
        BuiltInSymbols.add("||", "\\.{\\p@barbar}", 1, 24);
        BuiltInSymbols.add("&", "\\.{\\,\\&\\,}", 1, 25);
        BuiltInSymbols.add("&&", "\\.{\\,\\&\\&\\,}", 1, 26);
        BuiltInSymbols.add("++", "\\.{\\pp}", 1, 27);
        BuiltInSymbols.add("--", "\\.{\\mm}", 1, 27);
        BuiltInSymbols.add("**", "\\.{\\stst}", 1, 28);
        BuiltInSymbols.add("//", "\\.{\\slsl}", 1, 29);
        BuiltInSymbols.add("^^", "\\.{\\ct\\ct}", 1, 30);
        BuiltInSymbols.add("|-", "\\.{\\vdash}", 1, 31);
        BuiltInSymbols.add("|=", "\\.{\\models}", 1, 32);
        BuiltInSymbols.add("-|", "\\.{\\dashv}", 1, 33);
        BuiltInSymbols.add("=|", "\\.{\\eqdash}", 1, 34);
        BuiltInSymbols.add("<:", "\\.{\\ltcolon}", 1, 35);
        BuiltInSymbols.add(":>", "\\.{\\colongt}", 1, 35);
        BuiltInSymbols.add(":=", "\\.{:=}", 1, 35);
        BuiltInSymbols.add("::=", "\\.{::=}", 1, 36);
        BuiltInSymbols.add("(+)", "\\.{\\oplus}", 1, 37);
        BuiltInSymbols.add("(-)", "\\.{\\ominus}", 1, 37);
        BuiltInSymbols.add("\\oplus", "\\.{\\oplus}", 1, 37);
        BuiltInSymbols.add("\\ominus", "\\.{\\ominus}", 1, 37);
        BuiltInSymbols.add("(.)", "\\.{\\odot}", 1, 38);
        BuiltInSymbols.add("\\odot", "\\.{\\odot}", 1, 38);
        BuiltInSymbols.add("(/)", "\\.{\\oslash}", 1, 39);
        BuiltInSymbols.add("\\oslash", "\\.{\\oslash}", 1, 39);
        BuiltInSymbols.add("(\\X)", "\\.{\\otimes}", 1, 40);
        BuiltInSymbols.add("\\otimes", "\\.{\\otimes}", 1, 40);
        BuiltInSymbols.add("\\uplus", "\\.{\\uplus}", 1, 41);
        BuiltInSymbols.add("\\sqcap", "\\.{\\sqcap}", 1, 42);
        BuiltInSymbols.add("\\sqcup", "\\.{\\sqcup}", 1, 43);
        BuiltInSymbols.add("\\div", "\\.{\\div}", 1, 44);
        BuiltInSymbols.add("\\star", "\\.{\\star}", 1, 45);
        BuiltInSymbols.add("\\o", "\\.{\\circ}", 1, 46);
        BuiltInSymbols.add("\\circ", "\\.{\\circ}", 1, 46);
        BuiltInSymbols.add("\\bigcirc", "\\.{\\bigcirc}", 1, 47);
        BuiltInSymbols.add("\\bullet", "\\.{\\bullet}", 1, 48);
        BuiltInSymbols.add("\\in", "\\.{\\in}", 1, 49);
        BuiltInSymbols.add("\\notin", "\\.{\\notin}", 1, 49);
        BuiltInSymbols.add("=", "\\.{=}", 1, 49);
        BuiltInSymbols.add("#", "\\.{\\neq}", 1, 49);
        BuiltInSymbols.add("/=", "\\.{\\neq}", 1, 49);
        BuiltInSymbols.add("<", "\\.{<}", 1, 49);
        BuiltInSymbols.add(">", "\\.{>}", 1, 49);
        BuiltInSymbols.add("<=", "\\.{\\leq}", 1, 49);
        BuiltInSymbols.add("=<", "\\.{\\leq}", 1, 49);
        BuiltInSymbols.add(">=", "\\.{\\geq}", 1, 49);
        BuiltInSymbols.add("\\prec", "\\.{\\prec}", 1, 49);
        BuiltInSymbols.add("\\succ", "\\.{\\succ}", 1, 49);
        BuiltInSymbols.add("\\preceq", "\\.{\\preceq}", 1, 49);
        BuiltInSymbols.add("\\succeq", "\\.{\\succeq}", 1, 49);
        BuiltInSymbols.add("\\sim", "\\.{\\sim}", 1, 49);
        BuiltInSymbols.add("\\simeq", "\\.{\\simeq}", 1, 49);
        BuiltInSymbols.add("\\approx", "\\.{\\approx}", 1, 49);
        BuiltInSymbols.add("\\doteq", "\\.{\\doteq}", 1, 49);
        BuiltInSymbols.add("\\asymp", "\\.{\\asymp}", 1, 50);
        BuiltInSymbols.add("\\sqsubset", "\\.{\\sqsubset}", 1, 51);
        BuiltInSymbols.add("\\sqsupset", "\\.{\\sqsupset}", 1, 51);
        BuiltInSymbols.add("\\sqsubseteq", "\\.{\\sqsubseteq}", 1, 51);
        BuiltInSymbols.add("\\sqsupseteq", "\\.{\\sqsupseteq}", 1, 51);
        BuiltInSymbols.add("\\propto", "\\.{\\propto}", 1, 52);
        BuiltInSymbols.add(":", "\\.{:}", 8, 53);
        BuiltInSymbols.add("->", "\\.{\\rightarrow}", 1, 54);
        BuiltInSymbols.add("|->", "\\.{\\mapsto}", 1, 55);
        BuiltInSymbols.add("<-", "\\.{\\leftarrow}", 1, 56);
        BuiltInSymbols.add("==", "\\.{\\defeq}", 1, 57);
        BuiltInSymbols.add("ELSE", "\\.{\\ELSE}", 2, 58);
        BuiltInSymbols.add("THEN", "\\.{\\THEN}", 2, 58);
        BuiltInSymbols.add("LET", "\\.{\\LET}", 1, 59);
        BuiltInSymbols.add("IN", "\\.{\\IN}", 1, 59);
        BuiltInSymbols.add("[]", "{\\Box}", 1, 60);
        BuiltInSymbols.add("::", "{\\coloncolon}", 1, 61);
        BuiltInSymbols.add("ASSUME", "{\\ASSUME}", 7, 62);
        BuiltInSymbols.add("PROVE", "{\\PROVE}", 7, 62);
        BuiltInSymbols.add("..", "\\.{\\dotdot}", 1, 0);
        BuiltInSymbols.add("...", "\\.{\\dots}", 1, 0);
        BuiltInSymbols.add("$", "\\.{\\,\\$\\,}", 1, 0);
        BuiltInSymbols.add("$$", "\\.{\\,\\$\\$\\,}", 1, 0);
        BuiltInSymbols.add("?", "\\.{?}", 1, 0);
        BuiltInSymbols.add("??", "\\.{\\,??\\,}", 1, 0);
        BuiltInSymbols.add("%", "\\.{\\%}", 1, 0);
        BuiltInSymbols.add("%%", "\\.{\\,\\%\\%\\,}", 1, 0);
        BuiltInSymbols.add("##", "\\.{\\,\\#\\#\\,}", 1, 0);
        BuiltInSymbols.add("@@", "\\.{\\,@@\\,}", 1, 0);
        BuiltInSymbols.add("!!", "\\.{!!}", 1, 0);
        BuiltInSymbols.add("\\times", "\\.{\\times}", 1, 0);
        BuiltInSymbols.add("\\leq", "\\.{\\leq}", 1, 0);
        BuiltInSymbols.add("\\geq", "\\.{\\geq}", 1, 0);
        BuiltInSymbols.add("\\mod", "\\.{\\%}", 1, 0);
        BuiltInSymbols.add("\\wr", "\\.{\\wr}", 1, 0);
        BuiltInSymbols.add("\\cong", "\\.{\\cong}", 1, 0);
        BuiltInSymbols.add("!", "{\\bang}", 1, 0);
        BuiltInSymbols.add(",", ",\\,", 8, 0);
        BuiltInSymbols.add(".", ".", 8, 0);
        BuiltInSymbols.add("-.", "\\.{-\\!.\\,}", 9, 0);
        BuiltInSymbols.add("@", "@", 9, 0);
        BuiltInSymbols.pcaladd("fair", "{\\p@fair}", 7, 0);
        BuiltInSymbols.pcaladd("algorithm", "{\\p@algorithm}", 7, 0);
        BuiltInSymbols.pcaladd("--fair", "{\\p@mmfair}", 7, 0);
        BuiltInSymbols.pcaladd("--algorithm", "{\\p@mmalgorithm}", 7, 0);
        BuiltInSymbols.pcaladd(";", "{\\p@semicolon}", 8, 63);
        BuiltInSymbols.pcaladd("assert", "{\\p@assert}", 7, 0);
        BuiltInSymbols.pcaladd("await", "{\\p@await}", 7, 0);
        BuiltInSymbols.pcaladd("begin", "{\\p@begin}", 7, 0);
        BuiltInSymbols.pcaladd("end", "{\\p@end}", 7, 0);
        BuiltInSymbols.pcaladd("call", "{\\p@call}", 7, 0);
        BuiltInSymbols.pcaladd("define", "{\\p@define}", 7, 0);
        BuiltInSymbols.pcaladd("do", "{\\p@do}", 7, 0);
        BuiltInSymbols.pcaladd("either", "{\\p@either}", 1, 64);
        BuiltInSymbols.pcaladd("or", "{\\p@or}", 1, 64);
        BuiltInSymbols.pcaladd("goto", "{\\p@goto}", 7, 0);
        BuiltInSymbols.pcaladd("if", "{\\p@if}", 7, 0);
        BuiltInSymbols.pcaladd("then", "{\\p@then}", 1, 65);
        BuiltInSymbols.pcaladd("else", "{\\p@else}", 1, 65);
        BuiltInSymbols.pcaladd("elsif", "{\\p@elsif}", 1, 65);
        BuiltInSymbols.pcaladd("macro", "{\\p@macro}", 7, 0);
        BuiltInSymbols.pcaladd("print", "{\\p@print}", 7, 0);
        BuiltInSymbols.pcaladd("procedure", "{\\p@procedure}", 7, 0);
        BuiltInSymbols.pcaladd("process", "{\\p@process}", 7, 0);
        BuiltInSymbols.pcaladd("return", "{\\p@return}", 7, 0);
        BuiltInSymbols.pcaladd("skip", "{\\p@skip}", 7, 0);
        BuiltInSymbols.pcaladd("variable", "{\\p@variable}", 7, 0);
        BuiltInSymbols.pcaladd("variables", "{\\p@variables}", 7, 0);
        BuiltInSymbols.pcaladd("while", "{\\p@while}", 7, 0);
        BuiltInSymbols.pcaladd("with", "{\\p@with}", 7, 0);
        BuiltInSymbols.pcaladd("when", "{\\p@when}", 7, 0);
        BuiltInSymbols.pcaladd(pcalLeftParen, "{\\p@lparen}", 4, 0);
        BuiltInSymbols.pcaladd(pcalRightParen, "{\\p@rparen}", 5, 0);
        BuiltInSymbols.pcaladd(pcalLeftBrace, "{\\p@lbrace}", 4, 0);
        BuiltInSymbols.pcaladd(pcalRightBrace, "{\\p@rbrace}", 5, 0);
    }

    private static void buildPrefixHashTable() {
        String symbol;
        Enumeration builtInEnum = builtInHashTable.keys();
        while (builtInEnum.hasMoreElements()) {
            symbol = (String)builtInEnum.nextElement();
            if (Misc.IsLetter(symbol.charAt(0)) || symbol.length() > 1 && symbol.charAt(0) == '\\' && Misc.IsLetter(symbol.charAt(1))) continue;
            while (symbol.length() > 0) {
                prefixHashTable.put(symbol, nullString);
                symbol = symbol.substring(0, symbol.length() - 1);
            }
        }
        builtInEnum = pcalBuiltInHashTable.keys();
        while (builtInEnum.hasMoreElements()) {
            symbol = (String)builtInEnum.nextElement();
            if (Misc.IsLetter(symbol.charAt(0)) || symbol.length() > 1 && symbol.charAt(0) == '\\' && Misc.IsLetter(symbol.charAt(1))) continue;
            while (symbol.length() > 0) {
                pcalPrefixHashTable.put(symbol, nullString);
                symbol = symbol.substring(0, symbol.length() - 1);
            }
        }
    }
}

