/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.impl.FastTool;
import tlc2.value.impl.Value;
import util.Assert;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class REPL {
    private File specFile = null;
    static final String TEMP_DIR_PREFIX = "tlarepl";
    final String REPL_SPEC_NAME = "tlarepl";
    Path replTempDir;

    public REPL(Path tempDir) {
        this.replTempDir = tempDir;
    }

    public void setSpecFile(File pSpecFile) {
        this.specFile = pSpecFile;
    }

    public String processInput(String evalExpr) {
        String moduleExtends = "Reals,Sequences,Bags,FiniteSets,TLC,Randomization";
        if (this.specFile != null) {
            String mainModuleName = this.specFile.getName().replaceFirst(".tla$", "");
            moduleExtends = moduleExtends + "," + mainModuleName;
        }
        try {
            File tempFile = new File(this.replTempDir.toString(), "tlarepl.tla");
            File configFile = new File(this.replTempDir.toString(), "tlarepl.cfg");
            BufferedWriter cfgWriter = new BufferedWriter(new FileWriter(configFile.getAbsolutePath(), false));
            cfgWriter.append("INIT replinit");
            cfgWriter.newLine();
            cfgWriter.append("NEXT replnext");
            cfgWriter.newLine();
            cfgWriter.close();
            ArrayList<String> lines = new ArrayList<String>();
            String replValueVarName = "replvalue";
            lines.add("---- MODULE tlarepl ----");
            lines.add("EXTENDS " + moduleExtends);
            lines.add("VARIABLE replvar");
            lines.add("replinit == replvar = 0");
            lines.add("replnext == replvar' = 0");
            lines.add(replValueVarName + " == " + evalExpr);
            lines.add("====");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile.getAbsolutePath(), false));
            for (String line : lines) {
                writer.append(line);
                writer.newLine();
            }
            writer.close();
            ToolIO.setMode(1);
            ToolIO.reset();
            try {
                SimpleFilenameToStream resolver = new SimpleFilenameToStream(this.replTempDir.toAbsolutePath().toString());
                FastTool tool = new FastTool(TEMP_DIR_PREFIX, TEMP_DIR_PREFIX, resolver);
                ModuleNode module = tool.getSpecProcessor().getRootModule();
                OpDefNode valueNode = module.getOpDef(replValueVarName);
                Value exprVal = (Value)tool.eval(valueNode.getBody());
                return exprVal.toString();
            }
            catch (EvalException exc) {
                System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, exc);
            }
            catch (Assert.TLCRuntimeException exc) {
                if (exc.parameters != null && exc.parameters.length > 0) {
                    System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, Arrays.toString(exc.parameters));
                } else if (exc.getMessage() != null) {
                    String msg = exc.getMessage().trim();
                    msg = msg.replaceFirst("\\nline [0-9]+, col [0-9]+ to line [0-9]+, col [0-9]+ of module tlarepl$", "");
                    msg = msg.replaceAll("\\n", " ").trim();
                    System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, msg);
                } else {
                    System.out.printf("Error evaluating expression: '%s'%n", evalExpr);
                }
            }
        }
        catch (IOException pe) {
            pe.printStackTrace();
        }
        return "";
    }

    public void runREPL() throws IOException {
        DefaultParser parser = new DefaultParser();
        parser.setEscapeChars(null);
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().parser(parser).terminal(terminal).build();
        String prompt = "(tla+) ";
        try {
            while (true) {
                String expr;
                String res;
                if ((res = this.processInput(expr = reader.readLine(prompt))).equals("")) {
                    continue;
                }
                System.out.println(res);
            }
        }
        catch (UserInterruptException e) {
            return;
        }
        catch (EndOfFileException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        try {
            Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
            REPL repl = new REPL(tempDir);
            System.out.println("Welcome to the TLA+ REPL!");
            MP.printMessage(2262, TLCGlobals.versionOfTLC);
            System.out.println("Enter a constant-level TLA+ expression.");
            repl.runREPL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

