/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.coverage.ActionWrapper;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.coverage.CostModelNode;
import tlc2.tool.coverage.CoverageHashTable;
import tlc2.tool.coverage.OpApplNodeWrapper;
import tlc2.tool.coverage.RecursiveOpApplNodeWrapper;
import tlc2.tool.coverage.UnchangedOpApplNodeWrapper;
import tlc2.util.Context;
import tlc2.util.ObjLongTable;
import tlc2.util.Vect;

public class CostModelCreator
extends ExplorerVisitor {
    private final Deque<CostModelNode> stack = new ArrayDeque<CostModelNode>();
    private final Map<ExprOrOpArgNode, Subst> substs = new HashMap<ExprOrOpArgNode, Subst>();
    private final Map<OpApplNode, Set<OpApplNodeWrapper>> node2Wrapper = new HashMap<OpApplNode, Set<OpApplNodeWrapper>>();
    private final Set<OpDefNode> opDefNodes = new HashSet<OpDefNode>();
    private final Map<ExprNode, ExprNode> letIns = new HashMap<ExprNode, ExprNode>();
    private final Set<OpApplNodeWrapper> nodes = new HashSet<OpApplNodeWrapper>();
    private final ITool tool;
    private ActionWrapper root;
    private Context ctx = Context.Empty;

    private CostModelCreator(SemanticNode root, ITool tool) {
        this.tool = tool;
        this.stack.push(new RecursiveOpApplNodeWrapper());
        root.walkGraph(new CoverageHashTable(this.opDefNodes), this);
    }

    private CostModelCreator(ITool tool) {
        SemanticNode sn;
        this.tool = tool;
        ObjLongTable.Enumerator<SemanticNode> keys = tool.getPrimedLocs().keys();
        while ((sn = keys.nextElement()) != null) {
            this.nodes.add(new OpApplNodeWrapper((OpApplNode)sn, null));
        }
    }

    private CostModel getCM(Action act, ActionWrapper.Relation relation) {
        this.substs.clear();
        this.node2Wrapper.clear();
        this.opDefNodes.clear();
        this.letIns.clear();
        this.stack.clear();
        this.ctx = Context.Empty;
        this.root = new ActionWrapper(act, relation);
        this.stack.push(this.root);
        act.pred.walkGraph(new CoverageHashTable(this.opDefNodes), this);
        assert (this.stack.peek().isRoot());
        return this.stack.peek().getRoot();
    }

    @Override
    public void preVisit(ExploreNode exploreNode) {
        if (exploreNode instanceof OpApplNode) {
            Object lookup;
            OpApplNodeWrapper recursive;
            OpDefNode odn;
            ExprNode body;
            SymbolNode operator;
            Object val;
            OpApplNode opApplNode = (OpApplNode)exploreNode;
            if (opApplNode.isStandardModule()) {
                return;
            }
            OpApplNodeWrapper oan = opApplNode.hasOpcode(49) ? new UnchangedOpApplNodeWrapper(opApplNode, this.root) : new OpApplNodeWrapper(opApplNode, this.root);
            if (this.nodes.contains(oan)) {
                oan.setPrimed();
            }
            if (this.letIns.containsKey(opApplNode)) {
                ExprNode in = this.letIns.get(opApplNode);
                for (CostModelNode cmn : this.stack) {
                    SemanticNode node = cmn.getNode();
                    if (node != in || !(cmn instanceof OpApplNodeWrapper)) continue;
                    ((OpApplNodeWrapper)cmn).addLets(oan);
                }
            }
            if ((val = this.tool.lookup(operator = opApplNode.getOperator())) instanceof OpDefNode && operator != val && (body = (odn = (OpDefNode)val).getBody()) instanceof OpApplNode) {
                CostModelCreator substitution = new CostModelCreator(body, this.tool);
                oan.addChild((OpApplNodeWrapper)substitution.getModel());
            }
            if (operator instanceof OpDefNode && (odn = (OpDefNode)operator).getInRecursive() && (recursive = (OpApplNodeWrapper)this.stack.stream().filter(w -> w.getNode() != null && w.getNode() instanceof OpApplNode && ((OpApplNode)w.getNode()).getOperator() == odn).findFirst().orElse(null)) != null) {
                oan.setRecursive(recursive);
            }
            if (this.tool != null && operator instanceof OpDefNode && opApplNode.hasOpcode(0) && opApplNode.argsContainOpArgNodes() && (odn = (OpDefNode)operator).hasOpcode(0) && !odn.isStandardModule()) {
                this.ctx = this.tool.getOpContext(odn, opApplNode.getArgs(), this.ctx, false);
            }
            if ((lookup = this.ctx.lookup(opApplNode.getOperator())) instanceof OpDefNode && (body = ((OpDefNode)lookup).getBody()) instanceof OpApplNode) {
                this.node2Wrapper.computeIfAbsent((OpApplNode)body, key -> new HashSet()).add(oan);
            }
            if (this.node2Wrapper.containsKey(opApplNode)) {
                this.node2Wrapper.get(opApplNode).forEach(w -> w.addChild(oan));
            }
            if (this.substs.containsKey(exploreNode)) {
                Subst subst = this.substs.get(exploreNode);
                assert (subst.getExpr() == oan.getNode());
                subst.setCM(oan);
            }
            CostModelNode parent = this.stack.peek();
            parent.addChild(oan.setLevel(parent.getLevel() + 1));
            this.stack.push(oan);
        } else if (exploreNode instanceof SubstInNode) {
            Subst[] substs;
            SubstInNode sin = (SubstInNode)exploreNode;
            for (Subst subst : substs = sin.getSubsts()) {
                this.substs.put(subst.getExpr(), subst);
            }
        } else if (exploreNode instanceof LetInNode) {
            LetInNode lin = (LetInNode)exploreNode;
            for (OpDefNode opDefNode : lin.getLets()) {
                this.letIns.put(opDefNode.getBody(), lin.getBody());
            }
        } else if (exploreNode instanceof OpDefNode) {
            this.opDefNodes.add((OpDefNode)exploreNode);
        }
    }

    @Override
    public void postVisit(ExploreNode exploreNode) {
        if (exploreNode instanceof OpApplNode) {
            if (((OpApplNode)exploreNode).isStandardModule()) {
                return;
            }
            CostModelNode pop = this.stack.pop();
            assert (pop.getNode() == exploreNode);
        } else if (exploreNode instanceof OpDefNode) {
            boolean removed = this.opDefNodes.remove((OpDefNode)exploreNode);
            assert (removed);
        }
    }

    private CostModel getModel() {
        assert (this.stack.peek().isRoot());
        return this.stack.peek().getRoot();
    }

    public static final void create(ITool tool) {
        ExprNode[] actionConstraints;
        CostModelCreator collector = new CostModelCreator(tool);
        Vect<Action> init = tool.getInitStateSpec();
        for (int i = 0; i < init.size(); ++i) {
            Action[] initAction = init.elementAt(i);
            initAction.cm = collector.getCM((Action)initAction, ActionWrapper.Relation.INIT);
        }
        HashMap<SemanticNode, CostModel> cms = new HashMap<SemanticNode, CostModel>();
        for (Action nextAction : tool.getActions()) {
            if (cms.containsKey(nextAction.pred)) {
                nextAction.cm = (CostModel)cms.get(nextAction.pred);
                continue;
            }
            nextAction.cm = collector.getCM(nextAction, ActionWrapper.Relation.NEXT);
            cms.put(nextAction.pred, nextAction.cm);
        }
        for (Action invariant : tool.getInvariants()) {
            invariant.cm = collector.getCM(invariant, ActionWrapper.Relation.PROP);
        }
        for (ExprNode exprNode : actionConstraints = tool.getActionConstraints()) {
            OpDefNode opDefNode = (OpDefNode)exprNode.getToolObject(tool.getId());
            Action act = new Action((SemanticNode)exprNode, Context.Empty, opDefNode);
            act.cm = collector.getCM(act, ActionWrapper.Relation.CONSTRAINT);
            exprNode.setToolObject(tool.getId(), act);
        }
        ExprNode[] modelConstraints = tool.getModelConstraints();
        for (ExprNode exprNode : modelConstraints) {
            OpDefNode odn = (OpDefNode)exprNode.getToolObject(tool.getId());
            Action act = new Action((SemanticNode)exprNode, Context.Empty, odn);
            act.cm = collector.getCM(act, ActionWrapper.Relation.CONSTRAINT);
            exprNode.setToolObject(tool.getId(), act);
        }
        if (Boolean.getBoolean(CostModelCreator.class.getName() + ".implied")) {
            for (ASTConstants aSTConstants : tool.getImpliedInits()) {
                ((Action)aSTConstants).cm = collector.getCM((Action)aSTConstants, ActionWrapper.Relation.PROP);
            }
            for (ASTConstants aSTConstants : tool.getImpliedActions()) {
                ((Action)aSTConstants).cm = collector.getCM((Action)aSTConstants, ActionWrapper.Relation.PROP);
            }
        }
    }

    public static void report(ITool tool, long startTime) {
        long l;
        ExprNode[] actionConstraints;
        MP.printMessage(2201);
        Vect<Action> init = tool.getInitStateSpec();
        for (int i = 0; i < init.size(); ++i) {
            Action initAction = init.elementAt(i);
            initAction.cm.report();
        }
        Action[] actions2 = tool.getActions();
        HashSet<CostModel> reported = new HashSet<CostModel>();
        TreeSet<Action> sortedActions = new TreeSet<Action>(new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.pred.getLocation().compareTo(o2.pred.getLocation());
            }
        });
        sortedActions.addAll(Arrays.asList(actions2));
        for (Action action : sortedActions) {
            if (reported.contains(action.cm)) continue;
            action.cm.report();
            reported.add(action.cm);
        }
        for (Action invariant : tool.getInvariants()) {
            invariant.cm.report();
        }
        for (ExprNode exprNode : actionConstraints = tool.getActionConstraints()) {
            Action action = (Action)exprNode.getToolObject(tool.getId());
            action.cm.report();
        }
        ExprNode[] modelConstraints = tool.getModelConstraints();
        for (ExprNode exprNode : modelConstraints) {
            Action act = (Action)exprNode.getToolObject(tool.getId());
            act.cm.report();
        }
        if (Boolean.getBoolean(CostModelCreator.class.getName() + ".implied")) {
            for (ASTConstants aSTConstants : tool.getImpliedInits()) {
                ((Action)aSTConstants).cm.report();
            }
            for (ASTConstants aSTConstants : tool.getImpliedActions()) {
                ((Action)aSTConstants).cm.report();
            }
        }
        if ((l = System.currentTimeMillis() - startTime) > 300000L) {
            MP.printMessage(2777);
        } else {
            MP.printMessage(2202);
        }
    }
}

