/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;

public class IntValue
extends Value {
    private static final IntValue[] cache = new IntValue[10];
    public static final IntValue ValNegOne;
    public static final IntValue ValOne;
    public static final IntValue ValZero;
    public final int val;

    public static final int nbits(int tmp) {
        int nb = 0;
        while (tmp != 0 && tmp != -1) {
            ++nb;
            tmp >>= 1;
        }
        return nb + 1;
    }

    private IntValue(int i) {
        this.val = i;
    }

    @Override
    public final byte getKind() {
        return 1;
    }

    public final int nbits() {
        try {
            return IntValue.nbits(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public static IntValue gen(int i) {
        if (i >= 0 && i < cache.length) {
            return cache[i];
        }
        return new IntValue(i);
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof IntValue) {
                return Integer.compare(this.val, ((IntValue)obj).val);
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare integer " + Values.ppr(this.toString()) + " with non-integer:\n" + Values.ppr(obj.toString()));
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof IntValue) {
                return this.val == ((IntValue)obj).val;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to check equality of integer " + Values.ppr(this.toString()) + " with non-integer:\n" + Values.ppr(obj.toString()));
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the integer " + Values.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the integer " + Values.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to appy EXCEPT construct to the integer " + Values.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the integer " + Values.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the integer " + Values.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public boolean mutates() {
        return true;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            return val2 instanceof IntValue && this.val == ((IntValue)val2).val;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        vos.writeByte((byte)1);
        vos.writeInt(this.val);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            return FP64.Extend(FP64.Extend(fp, (byte)1), this.val);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean ignored) {
        try {
            return sb.append(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            IntValue.cache[i] = new IntValue(i);
        }
        ValNegOne = IntValue.gen(-1);
        ValOne = IntValue.gen(1);
        ValZero = IntValue.gen(0);
    }
}

