/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.util.Properties;
import javax.mail.Session;

public class PropUtil {
    private PropUtil() {
    }

    public static int getIntProperty(Properties props, String name2, int def2) {
        return PropUtil.getInt(PropUtil.getProp(props, name2), def2);
    }

    public static boolean getBooleanProperty(Properties props, String name2, boolean def2) {
        return PropUtil.getBoolean(PropUtil.getProp(props, name2), def2);
    }

    @Deprecated
    public static int getIntSessionProperty(Session session, String name2, int def2) {
        return PropUtil.getInt(PropUtil.getProp(session.getProperties(), name2), def2);
    }

    @Deprecated
    public static boolean getBooleanSessionProperty(Session session, String name2, boolean def2) {
        return PropUtil.getBoolean(PropUtil.getProp(session.getProperties(), name2), def2);
    }

    public static boolean getBooleanSystemProperty(String name2, boolean def2) {
        try {
            return PropUtil.getBoolean(PropUtil.getProp(System.getProperties(), name2), def2);
        }
        catch (SecurityException securityException) {
            try {
                String value = System.getProperty(name2);
                if (value == null) {
                    return def2;
                }
                if (def2) {
                    return !value.equalsIgnoreCase("false");
                }
                return value.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def2;
            }
        }
    }

    private static Object getProp(Properties props, String name2) {
        Object val2 = props.get(name2);
        if (val2 != null) {
            return val2;
        }
        return props.getProperty(name2);
    }

    private static int getInt(Object value, int def2) {
        if (value == null) {
            return def2;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return def2;
    }

    private static boolean getBoolean(Object value, boolean def2) {
        if (value == null) {
            return def2;
        }
        if (value instanceof String) {
            if (def2) {
                return !((String)value).equalsIgnoreCase("false");
            }
            return ((String)value).equalsIgnoreCase("true");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return def2;
    }
}

