/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CToken;
import tla2tex.Debug;
import tla2tex.FormatComments;
import tla2tex.Misc;
import tla2tex.TokenizeSpec;

public class TokenizeComment {
    private static Vector vspec = new Vector(50, 50);
    private static Vector linev = new Vector(40, 40);
    private static Vector argVec;
    private static char nextChar;
    private static String token;
    private static boolean inDQuote;
    private static boolean inSQuote;
    private static int col;
    private static int ncol;
    private static int line;
    private static String curString;
    private static final int START = 1;
    private static final int ID = 2;
    private static final int NUM_OR_ID = 3;
    private static final int BS = 4;
    private static final int NUM_OR_BI = 5;
    private static final int NUM = 6;
    private static final int BSBUILT_IN = 7;
    private static final int BUILT_IN = 8;
    private static final int REPEAT_CHAR = 9;
    private static final int STRING = 10;
    private static final int ESC_STRING = 11;
    private static final int LEFT_DQUOTE = 12;
    private static final int RIGHT_DQUOTE = 13;
    private static final int LEFT_SQUOTE = 14;
    private static final int RIGHT_SQUOTE = 15;
    private static final int TEX = 16;
    private static final int TEX_CARET = 17;
    private static final int THROW_AWAY = 18;
    private static final int THROW_AWAY_TILDE = 19;
    private static final int VERB = 20;
    private static final int VERB_DOT = 21;
    private static final int DONE = 22;
    private static int state;

    private static boolean isAllUnderscores() {
        boolean result = true;
        for (int i = 0; result && i < token.length(); ++i) {
            if (token.charAt(i) == '_') continue;
            result = false;
        }
        return result;
    }

    private static void skipNextChar() {
        if (++ncol < curString.length()) {
            nextChar = curString.charAt(ncol);
        } else if (ncol == curString.length()) {
            nextChar = (char)10;
        } else {
            if (++line < argVec.size()) {
                curString = (String)argVec.elementAt(line);
                if (curString == null) {
                    curString = "";
                }
            } else {
                curString = "\t";
            }
            ncol = 0;
            nextChar = curString.length() == 0 ? (char)10 : curString.charAt(0);
        }
    }

    private static void addNextChar() {
        token = token + nextChar;
        TokenizeComment.skipNextChar();
    }

    private static void Backspace(int n) {
        if ((ncol -= n) < 0) {
            Debug.ReportBug("TokenizeComment: Backspacing off end of line");
        }
    }

    private static void gotoStart() {
        state = 1;
        col = ncol;
    }

    private static void CTokenOut(int type2) {
        if (!token.equals("") || type2 == 3) {
            boolean tla = false;
            boolean amb = false;
            if (inSQuote && type2 != 9) {
                tla = true;
            } else {
                switch (type2) {
                    case 1: {
                        if (FormatComments.isAmbiguous(token)) {
                            if (!TokenizeSpec.isUsedBuiltin(token)) break;
                            amb = true;
                            break;
                        }
                        tla = true;
                        break;
                    }
                    case 2: {
                        if (token.charAt(0) == '\\') {
                            tla = true;
                            break;
                        }
                        amb = true;
                        break;
                    }
                    case 3: {
                        tla = true;
                        break;
                    }
                    case 4: {
                        if (FormatComments.IsWord(token)) {
                            if (!TokenizeSpec.isIdent(token)) break;
                            amb = true;
                            break;
                        }
                        if (TokenizeSpec.isIdent(token)) {
                            tla = true;
                            break;
                        }
                        amb = true;
                        break;
                    }
                    case 9: {
                        if (token.indexOf("\\end{verbatim}") == -1) break;
                        Debug.ReportError("Sorry, but you can't put the string\n\n       \\end{verbatim}\n\n    between `. and .' ");
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        break;
                    }
                    default: {
                        Debug.ReportBug("TokenizeComment.CTokenOut called with illegal type");
                    }
                }
            }
            linev.addElement(new CToken(token, col, type2, tla, amb));
        }
        token = "";
    }

    private static void startNewLine() {
        vspec.addElement(linev);
        linev = new Vector(30, 30);
        col = 0;
        ncol = 0;
    }

    private static CToken[][] vspecToArray() {
        CToken[][] aspec = new CToken[vspec.size()][];
        for (int n = 0; n < vspec.size(); ++n) {
            aspec[n] = new CToken[((Vector)vspec.elementAt(n)).size()];
            for (int m = 0; m < aspec[n].length; ++m) {
                aspec[n][m] = (CToken)((Vector)vspec.elementAt(n)).elementAt(m);
            }
        }
        vspec = new Vector(50, 50);
        return aspec;
    }

    public static CToken[][] Tokenize(Vector vec2) {
        if (vec2 == null || vec2.size() == 0) {
            return null;
        }
        argVec = vec2;
        line = 0;
        curString = argVec.elementAt(line) == null ? "" : (String)argVec.elementAt(line);
        nextChar = curString.equals("") ? (char)10 : curString.charAt(0);
        col = 0;
        ncol = 0;
        char repChar = ' ';
        state = 1;
        block23: while (state != 22) {
            switch (state) {
                case 1: {
                    if (Misc.IsSpace(nextChar)) {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 2;
                        continue block23;
                    }
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 3;
                        continue block23;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.startNewLine();
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    if (nextChar == '\\') {
                        TokenizeComment.addNextChar();
                        state = 4;
                        continue block23;
                    }
                    if (FormatComments.isRepeatChar(nextChar)) {
                        repChar = nextChar;
                        TokenizeComment.addNextChar();
                        state = 9;
                        continue block23;
                    }
                    if (nextChar == '\"') {
                        if (inDQuote) {
                            TokenizeComment.addNextChar();
                            state = 13;
                            continue block23;
                        }
                        TokenizeComment.skipNextChar();
                        state = 10;
                        continue block23;
                    }
                    if (nextChar == '`') {
                        TokenizeComment.addNextChar();
                        state = 14;
                        continue block23;
                    }
                    if (nextChar == '\'') {
                        if (inSQuote) {
                            TokenizeComment.skipNextChar();
                            inSQuote = false;
                            TokenizeComment.gotoStart();
                            continue block23;
                        }
                        TokenizeComment.addNextChar();
                        state = 15;
                        continue block23;
                    }
                    if (BuiltInSymbols.IsBuiltInPrefix("" + nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 8;
                        continue block23;
                    }
                    if (nextChar == '\t') {
                        state = 22;
                        continue block23;
                    }
                    TokenizeComment.addNextChar();
                    TokenizeComment.CTokenOut(5);
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 2: {
                    if (token.length() == 3 && (token.equals("WF_") || token.equals("SF_"))) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    if (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        continue block23;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token)) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    if (TokenizeComment.isAllUnderscores()) {
                        TokenizeComment.CTokenOut(6);
                    } else {
                        TokenizeComment.CTokenOut(4);
                    }
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 3: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 3;
                        continue block23;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 2;
                        continue block23;
                    }
                    TokenizeComment.CTokenOut(2);
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 4: {
                    if (nextChar == 'b' || nextChar == 'B' || nextChar == 'o' || nextChar == 'O' || nextChar == 'h' || nextChar == 'H') {
                        TokenizeComment.addNextChar();
                        state = 5;
                        continue block23;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        state = 7;
                        continue block23;
                    }
                    state = 8;
                    continue block23;
                }
                case 5: {
                    if (Misc.IsDigit(nextChar)) {
                        state = 6;
                        continue block23;
                    }
                    state = 7;
                    continue block23;
                }
                case 6: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 6;
                        continue block23;
                    }
                    if (Misc.IsLetter(nextChar) && token.charAt(0) != '\\') {
                        TokenizeComment.addNextChar();
                        state = 2;
                        continue block23;
                    }
                    TokenizeComment.CTokenOut(2);
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 7: {
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 7;
                        continue block23;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token)) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    TokenizeComment.CTokenOut(5);
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 8: {
                    if (BuiltInSymbols.IsBuiltInPrefix(token + nextChar)) {
                        TokenizeComment.addNextChar();
                        continue block23;
                    }
                    if (!BuiltInSymbols.IsBuiltInSymbol(token)) {
                        while (!BuiltInSymbols.IsBuiltInSymbol(token)) {
                            TokenizeComment.Backspace(1);
                            if (token.length() == 0) {
                                Debug.ReportBug("Error tokenizing built-in symbol");
                            }
                            token = token.substring(0, token.length() - 1);
                        }
                        nextChar = curString.charAt(ncol);
                    }
                    TokenizeComment.CTokenOut(1);
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 9: {
                    if (nextChar == repChar) {
                        TokenizeComment.addNextChar();
                        continue block23;
                    }
                    if (token.length() >= FormatComments.getRepeatCharMin(repChar)) {
                        TokenizeComment.CTokenOut(6);
                        state = 1;
                        continue block23;
                    }
                    state = 8;
                    continue block23;
                }
                case 10: {
                    if (nextChar == '\\') {
                        TokenizeComment.addNextChar();
                        state = 11;
                        continue block23;
                    }
                    if (BuiltInSymbols.IsStringChar(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 10;
                        continue block23;
                    }
                    if (nextChar == '\"' && (TokenizeSpec.isString(token) || inSQuote)) {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.CTokenOut(3);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    state = 12;
                    continue block23;
                }
                case 11: {
                    if (nextChar == '\"' || nextChar == '\\' || nextChar == 't' || nextChar == 'n' || nextChar == 'f' || nextChar == 'r') {
                        TokenizeComment.addNextChar();
                        state = 10;
                        continue block23;
                    }
                    state = 12;
                    continue block23;
                }
                case 12: {
                    TokenizeComment.Backspace(token.length() + 1);
                    token = "\"";
                    TokenizeComment.CTokenOut(7);
                    inDQuote = true;
                    TokenizeComment.skipNextChar();
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 13: {
                    TokenizeComment.CTokenOut(8);
                    inDQuote = false;
                    TokenizeComment.gotoStart();
                    continue block23;
                }
                case 14: {
                    if (nextChar == '`') {
                        TokenizeComment.addNextChar();
                        TokenizeComment.CTokenOut(5);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    if (nextChar == '^') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 16;
                        continue block23;
                    }
                    if (nextChar == '~') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 18;
                        continue block23;
                    }
                    if (nextChar == '.') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 20;
                        continue block23;
                    }
                    token = "";
                    inSQuote = true;
                    col = ncol - 1;
                    state = 1;
                    continue block23;
                }
                case 15: {
                    if (nextChar == '\'') {
                        TokenizeComment.addNextChar();
                        TokenizeComment.CTokenOut(5);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    state = 8;
                    continue block23;
                }
                case 16: {
                    if (nextChar == '^') {
                        TokenizeComment.skipNextChar();
                        state = 17;
                        continue block23;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (token.equals("")) {
                            token = " ";
                        }
                        TokenizeComment.CTokenOut(10);
                        TokenizeComment.startNewLine();
                        continue block23;
                    }
                    if (nextChar == '\t') {
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(10);
                        }
                        token = "";
                        state = 22;
                        continue block23;
                    }
                    TokenizeComment.addNextChar();
                    continue block23;
                }
                case 17: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(10);
                        }
                        token = "";
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    token = token + "^";
                    state = 16;
                    continue block23;
                }
                case 18: {
                    if (nextChar == '~') {
                        TokenizeComment.skipNextChar();
                        state = 19;
                        continue block23;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (linev.size() != 0) {
                            TokenizeComment.startNewLine();
                        }
                        col = 0;
                        ncol = 0;
                        continue block23;
                    }
                    if (nextChar == '\t') {
                        state = 22;
                        continue block23;
                    }
                    TokenizeComment.addNextChar();
                    continue block23;
                }
                case 19: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        token = "";
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    TokenizeComment.skipNextChar();
                    state = 18;
                    continue block23;
                }
                case 20: {
                    if (nextChar == '.') {
                        TokenizeComment.skipNextChar();
                        state = 21;
                        continue block23;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(9);
                        }
                        token = "";
                        TokenizeComment.startNewLine();
                        continue block23;
                    }
                    if (nextChar == '\t') {
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(9);
                        }
                        state = 22;
                        continue block23;
                    }
                    TokenizeComment.addNextChar();
                    continue block23;
                }
                case 21: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.CTokenOut(9);
                        TokenizeComment.gotoStart();
                        continue block23;
                    }
                    token = token + ".";
                    state = 20;
                    continue block23;
                }
            }
            Debug.ReportBug("Unexpected state in comment-parsing algorithm");
        }
        return TokenizeComment.vspecToArray();
    }

    public static CToken[][] TeXTokenize(Vector vec2) {
        if (vec2 == null || vec2.size() == 0) {
            return null;
        }
        CToken[][] result = new CToken[vec2.size()][];
        for (line = 0; line < vec2.size(); ++line) {
            String curString = "";
            if (vec2.elementAt(line) != null) {
                curString = (String)vec2.elementAt(line);
            }
            result[TokenizeComment.line] = new CToken[1];
            result[TokenizeComment.line][0] = new CToken(curString, 0, 10, false, false);
        }
        return result;
    }

    static {
        token = "";
        inDQuote = false;
        inSQuote = false;
        ncol = 0;
        line = 0;
        curString = "";
        state = 1;
    }
}

