/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SetCupValue
extends EnumerableValue
implements Enumerable {
    public final Value set1;
    public final Value set2;
    protected SetEnumValue cupSet;

    public SetCupValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.cupSet = null;
    }

    public SetCupValue(Value set1, Value set2, CostModel cm) {
        this(set1, set2);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 19;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.cupSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.cupSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.set1.member(elem) || this.set2.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            return this.set1.isFinite() && this.set2.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.cupSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.cupSet != null && this.cupSet != SetEnumValue.DummyEnum && this.cupSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.cupSet != null && this.cupSet != SetEnumValue.DummyEnum) {
                this.cupSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.set1.deepNormalize();
            this.set2.deepNormalize();
            if (this.cupSet == null) {
                this.cupSet = SetEnumValue.DummyEnum;
            } else if (this.cupSet != SetEnumValue.DummyEnum) {
                this.cupSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set1.isDefined() && this.set2.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.cupSet.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.cupSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.cupSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void convertAndCache() {
        if (this.cupSet == null) {
            this.cupSet = (SetEnumValue)this.toSetEnum();
        } else if (this.cupSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = (SetEnumValue)this.toSetEnum();
            val.deepNormalize();
            this.cupSet = val;
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.cupSet != null && this.cupSet != SetEnumValue.DummyEnum) {
            return this.cupSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, false, this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            block6: {
                try {
                    if (TLCGlobals.expand) {
                        Value val = this.toSetEnum();
                        return val.toString(sb, offset, swallow);
                    }
                }
                catch (Throwable e) {
                    if (swallow) break block6;
                    throw e;
                }
            }
            sb = this.set1.toString(sb, offset, swallow);
            sb = sb.append(" \\cup ");
            sb = this.set2.toString(sb, offset, swallow);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.cupSet == null || this.cupSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.cupSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;
        ValueEnumeration enum2;

        public Enumerator() {
            if (SetCupValue.this.set1 instanceof Enumerable && SetCupValue.this.set2 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCupValue.this.set1)).elements();
                this.enum2 = ((Enumerable)((Object)SetCupValue.this.set2)).elements();
            } else {
                Assert.fail("Attempted to enumerate S \\cup T when S:\n" + Values.ppr(SetCupValue.this.set1.toString()) + "\nand T:\n" + Values.ppr(SetCupValue.this.set2.toString()) + "\nare not both enumerable", SetCupValue.this.getSource());
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
            this.enum2.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem;
            if (Value.coverage) {
                SetCupValue.this.cm.incSecondary();
            }
            if ((elem = this.enum1.nextElement()) != null) {
                return elem;
            }
            elem = this.enum2.nextElement();
            return elem;
        }
    }
}

