/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.tool.Action;
import tlc2.tool.TLCState;

public class TLCStateInfo {
    private static final String INITIAL_PREDICATE_NO_ANGLE_BRACKET = "Initial predicate";
    public static final String INITIAL_PREDICATE = "<Initial predicate>";
    public TLCStateInfo predecessorState;
    public long stateNumber;
    public Object info;
    public final TLCState state;
    public Long fp;

    public TLCStateInfo(TLCState state) {
        this.state = state;
        this.stateNumber = state.getLevel();
        this.info = state.hasAction() ? TLCStateInfo.toInfo(state.isInitial(), state.getAction()) : INITIAL_PREDICATE;
    }

    public TLCStateInfo(TLCState state, Action action) {
        this.state = state;
        this.stateNumber = state.getLevel();
        this.info = TLCStateInfo.toInfo(state.isInitial(), action);
    }

    private static String toInfo(boolean isInitial, Action a) {
        if (isInitial && !a.isNamed()) {
            return a.getLocation(INITIAL_PREDICATE_NO_ANGLE_BRACKET);
        }
        return a.getLocation();
    }

    public TLCStateInfo(TLCState state, int stateOrdinal) {
        this.state = state;
        this.stateNumber = stateOrdinal;
        this.info = "";
    }

    protected TLCStateInfo(TLCState s, TLCStateInfo info) {
        this.state = s;
        this.info = info.info;
        this.stateNumber = info.stateNumber;
        this.fp = info.fp;
    }

    public final long fingerPrint() {
        if (this.fp == null) {
            this.fp = this.state.fingerPrint();
        }
        return this.fp;
    }

    public final String toString() {
        return this.state.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof TLCStateInfo) {
            TLCStateInfo sinfo = (TLCStateInfo)other;
            return this.state.equals(sinfo.state);
        }
        if (other instanceof TLCState) {
            TLCState state = (TLCState)other;
            return this.state.equals(state);
        }
        return false;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public TLCState getOriginalState() {
        return this.state;
    }

    public Action getAction() {
        if (this.state.hasAction()) {
            return this.state.getAction();
        }
        return Action.UNKNOWN;
    }
}

