/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.ITool;
import tlc2.tool.SimulationWorker;
import tlc2.tool.Simulator;
import tlc2.tool.StateVec;
import tlc2.tool.liveness.LiveException;
import tlc2.util.RandomGenerator;
import tlc2.value.RandomEnumerableValues;
import util.Assert;
import util.FilenameToStream;

public class SingleThreadedSimulator
extends Simulator {
    public SingleThreadedSimulator(ITool tool, String metadir, String traceFile, boolean deadlock, int traceDepth, long traceNum, String traceActions, RandomGenerator rng, long seed, FilenameToStream resolver) throws IOException {
        super(tool, metadir, traceFile, deadlock, traceDepth, traceNum, traceActions, rng, seed, resolver, 1);
    }

    @Override
    protected SimulationWorker.SimulationWorkerResult simulate(StateVec initialStates) throws InterruptedException {
        SimulationWorker.SimulationWorkerResult result;
        RandomEnumerableValues.reset();
        SimulationWorker simulationWorker = (SimulationWorker)this.workers.get(0);
        simulationWorker.setInitialStates(initialStates);
        boolean errorCode = false;
        while (true) {
            simulationWorker.simulateAndReport();
            if (this.workerResultQueue.isEmpty()) continue;
            result = (SimulationWorker.SimulationWorkerResult)this.workerResultQueue.take();
            if (!result.isError()) break;
            SimulationWorker.SimulationWorkerError error = result.error();
            if (error.exception != null) {
                if (error.exception instanceof LiveException) {
                    this.printSummary();
                    error.errorCode = ((LiveException)error.exception).errorCode;
                } else if (error.exception instanceof Assert.TLCRuntimeException) {
                    Assert.TLCRuntimeException exception = (Assert.TLCRuntimeException)error.exception;
                    this.printBehavior(exception, error.state, error.stateTrace);
                    error.errorCode = exception.errorCode;
                } else {
                    this.printBehavior(1000, new String[]{MP.ECGeneralMsg("", error.exception)}, error.state, error.stateTrace);
                    error.errorCode = 1000;
                }
                return result;
            }
            this.printBehavior(error);
            if (this.isNonContinuableError(error.errorCode)) {
                return result;
            }
            if (!TLCGlobals.continuation) {
                return result;
            }
            if (errorCode) continue;
            error.errorCode = 1000;
        }
        this.printSummary();
        return result;
    }
}

