/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;

public class RandomAccessFile
extends java.io.RandomAccessFile {
    public long superSeekCnt = 0L;
    public long superReadCnt = 0L;
    public long superWriteCnt = 0L;
    public long superSeekTime = 0L;
    public long superReadTime = 0L;
    public long superWriteTime = 0L;

    public RandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
    }

    public RandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    @Override
    public void seek(long pos) throws IOException {
        ++this.superSeekCnt;
        long start = System.currentTimeMillis();
        super.seek(pos);
        this.superSeekTime += System.currentTimeMillis() - start;
    }

    @Override
    public int read() throws IOException {
        ++this.superReadCnt;
        long start = System.currentTimeMillis();
        int res = super.read();
        this.superReadTime += System.currentTimeMillis() - start;
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        ++this.superReadCnt;
        long start = System.currentTimeMillis();
        int res = super.read(b);
        this.superReadTime += System.currentTimeMillis() - start;
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ++this.superReadCnt;
        long start = System.currentTimeMillis();
        int res = super.read(b, off, len);
        this.superReadTime += System.currentTimeMillis() - start;
        return res;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.superWriteCnt;
        long start = System.currentTimeMillis();
        super.write(b);
        this.superWriteTime += System.currentTimeMillis() - start;
    }

    @Override
    public void write(byte[] b) throws IOException {
        ++this.superWriteCnt;
        long start = System.currentTimeMillis();
        super.write(b);
        this.superWriteTime += System.currentTimeMillis() - start;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ++this.superWriteCnt;
        long start = System.currentTimeMillis();
        super.write(b, off, len);
        this.superWriteTime += System.currentTimeMillis() - start;
    }
}

