/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolMatcher;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;
import util.WrongInvocationException;

public class ModuleNode
extends SymbolNode {
    private final Context ctxt;
    private ModuleNode[] extendees = new ModuleNode[0];
    private HashMap<Boolean, HashSet<ModuleNode>> depthAllExtendeesMap = new HashMap();
    private OpDeclNode[] constantDecls = null;
    private OpDeclNode[] variableDecls = null;
    private ArrayList<SemanticNode> definitions = new ArrayList();
    Vector recursiveDecls = new Vector(8);
    Vector<OpDefNode> opDefsInRecursiveSection = new Vector(16);
    int nestingLevel;
    private OpDefNode[] opDefs = null;
    private ThmOrAssumpDefNode[] thmOrAssDefs = null;
    private ModuleNode[] modDefs = null;
    private InstanceNode[] instantiations = null;
    private AssumeNode[] assumptions = null;
    private TheoremNode[] theorems = null;
    private LevelNode[] topLevel = null;
    private boolean isInstantiated = false;
    private boolean isStandard = false;
    private Vector assumptionVec = new Vector();
    private Vector theoremVec = new Vector();
    private Vector instanceVec = new Vector();
    private Vector topLevelVec = new Vector();
    Vector recursiveOpDefNodes = new Vector();
    private SemanticNode[] children = null;

    public ModuleNode(UniqueString us, Context ct, TreeNode stn) {
        super(1, stn, us);
        this.ctxt = ct;
    }

    @Override
    public final int getArity() {
        return -2;
    }

    public final SymbolTable getSymbolTable() {
        return null;
    }

    public final Context getContext() {
        return this.ctxt;
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    final boolean isParameterFree() {
        return this.getConstantDecls().length == 0 && this.getVariableDecls().length == 0;
    }

    public List<SemanticNode> getDefinitions() {
        return this.definitions;
    }

    public final void createExtendeeArray(Vector<ModuleNode> extendeeVec) {
        this.extendees = new ModuleNode[extendeeVec.size()];
        for (int i = 0; i < this.extendees.length; ++i) {
            this.extendees[i] = extendeeVec.elementAt(i);
        }
    }

    public final OpDeclNode[] getConstantDecls() {
        if (this.constantDecls != null) {
            return this.constantDecls;
        }
        Vector<SemanticNode> contextVec = this.ctxt.getConstantDecls();
        this.constantDecls = new OpDeclNode[contextVec.size()];
        int j = this.constantDecls.length - 1;
        for (int i = 0; i < this.constantDecls.length; ++i) {
            this.constantDecls[j--] = (OpDeclNode)contextVec.elementAt(i);
        }
        return this.constantDecls;
    }

    public final OpDeclNode[] getVariableDecls() {
        if (this.variableDecls != null) {
            return this.variableDecls;
        }
        Vector<SemanticNode> contextVec = this.ctxt.getVariableDecls();
        this.variableDecls = new OpDeclNode[contextVec.size()];
        int j = this.variableDecls.length - 1;
        for (int i = 0; i < this.variableDecls.length; ++i) {
            this.variableDecls[j--] = (OpDeclNode)contextVec.elementAt(i);
        }
        return this.variableDecls;
    }

    public final OpDefNode[] getOpDefs() {
        if (this.opDefs != null) {
            return this.opDefs;
        }
        Vector<OpDefNode> contextVec = this.ctxt.getOpDefs();
        this.opDefs = new OpDefNode[contextVec.size()];
        int j = this.opDefs.length - 1;
        for (int i = 0; i < this.opDefs.length; ++i) {
            this.opDefs[j--] = contextVec.elementAt(i);
        }
        return this.opDefs;
    }

    public final OpDefNode getOpDef(String name) {
        return this.getOpDef(UniqueString.uniqueStringOf(name));
    }

    public final OpDefNode getOpDef(UniqueString name) {
        return Stream.of(this.getOpDefs()).filter(o -> o.getName() == name).findFirst().orElse(null);
    }

    public final ThmOrAssumpDefNode[] getThmOrAssDefs() {
        if (this.thmOrAssDefs != null) {
            return this.thmOrAssDefs;
        }
        Vector<ThmOrAssumpDefNode> contextVec = this.ctxt.getThmOrAssDefs();
        this.thmOrAssDefs = new ThmOrAssumpDefNode[contextVec.size()];
        int j = this.thmOrAssDefs.length - 1;
        for (int i = 0; i < this.thmOrAssDefs.length; ++i) {
            this.thmOrAssDefs[j--] = contextVec.elementAt(i);
        }
        return this.thmOrAssDefs;
    }

    public final void appendDef(SemanticNode s) {
        this.definitions.add(s);
    }

    public final InstanceNode[] getInstances() {
        if (this.instantiations != null) {
            return this.instantiations;
        }
        this.instantiations = new InstanceNode[this.instanceVec.size()];
        for (int i = 0; i < this.instantiations.length; ++i) {
            this.instantiations[i] = (InstanceNode)this.instanceVec.elementAt(i);
        }
        return this.instantiations;
    }

    public final void appendInstance(InstanceNode s) {
        this.instanceVec.addElement(s);
        this.topLevelVec.addElement(s);
    }

    public final ModuleNode[] getInnerModules() {
        if (this.modDefs != null) {
            return this.modDefs;
        }
        Vector<SemanticNode> v = this.ctxt.getModDefs();
        this.modDefs = new ModuleNode[v.size()];
        for (int i = 0; i < this.modDefs.length; ++i) {
            this.modDefs[i] = (ModuleNode)v.elementAt(i);
        }
        return this.modDefs;
    }

    public final AssumeNode[] getAssumptions() {
        if (this.assumptions != null) {
            return this.assumptions;
        }
        this.assumptions = new AssumeNode[this.assumptionVec.size()];
        for (int i = 0; i < this.assumptions.length; ++i) {
            this.assumptions[i] = (AssumeNode)this.assumptionVec.elementAt(i);
        }
        return this.assumptions;
    }

    public final TheoremNode[] getTheorems() {
        if (this.theorems != null) {
            return this.theorems;
        }
        this.theorems = new TheoremNode[this.theoremVec.size()];
        for (int i = 0; i < this.theorems.length; ++i) {
            this.theorems[i] = (TheoremNode)this.theoremVec.elementAt(i);
        }
        return this.theorems;
    }

    public final LevelNode[] getTopLevel() {
        if (this.topLevel != null) {
            return this.topLevel;
        }
        this.topLevel = new LevelNode[this.topLevelVec.size()];
        for (int i = 0; i < this.topLevel.length; ++i) {
            this.topLevel[i] = (LevelNode)this.topLevelVec.elementAt(i);
        }
        return this.topLevel;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public void setInstantiated(boolean isInstantiated) {
        this.isInstantiated = isInstantiated;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void setStandard(boolean isStandard) {
        this.isStandard = isStandard;
    }

    final void addAssumption(TreeNode stn, ExprNode ass, SymbolTable st, ThmOrAssumpDefNode tadn) {
        AssumeNode an = new AssumeNode(stn, ass, this, tadn);
        this.assumptionVec.addElement(an);
        this.topLevelVec.addElement(an);
    }

    final void addTheorem(TreeNode stn, LevelNode thm, ProofNode pf, ThmOrAssumpDefNode tadn) {
        TheoremNode tn = new TheoremNode(stn, thm, this, pf, tadn);
        this.theoremVec.addElement(tn);
        this.topLevelVec.addElement(tn);
    }

    final void addTopLevel(LevelNode nd) {
        this.topLevelVec.addElement(nd);
    }

    final void copyAssumes(ModuleNode extendee) {
        for (int i = 0; i < extendee.assumptionVec.size(); ++i) {
            AssumeNode assume = (AssumeNode)extendee.assumptionVec.elementAt(i);
            this.assumptionVec.addElement(assume);
        }
    }

    final void copyTheorems(ModuleNode extendee) {
        for (int i = 0; i < extendee.theoremVec.size(); ++i) {
            TheoremNode theorem = (TheoremNode)extendee.theoremVec.elementAt(i);
            this.theoremVec.addElement(theorem);
        }
    }

    final void copyTopLevel(ModuleNode extendee) {
        for (int i = 0; i < extendee.topLevelVec.size(); ++i) {
            LevelNode node = (LevelNode)extendee.topLevelVec.elementAt(i);
            this.topLevelVec.addElement(node);
        }
    }

    public final HashSet<ModuleNode> getExtendedModuleSet() {
        return this.getExtendedModuleSet(true);
    }

    public final HashSet<ModuleNode> getExtendedModuleSet(boolean recursively) {
        Boolean key = recursively;
        HashSet<ModuleNode> extendeesSet = this.depthAllExtendeesMap.get(key);
        if (extendeesSet == null) {
            extendeesSet = new HashSet();
            for (int i = 0; i < this.extendees.length; ++i) {
                extendeesSet.add(this.extendees[i]);
                if (!recursively) continue;
                extendeesSet.addAll(this.extendees[i].getExtendedModuleSet(true));
            }
            this.depthAllExtendeesMap.put(key, extendeesSet);
        }
        return extendeesSet;
    }

    public boolean extendsModule(ModuleNode mod) {
        return this.getExtendedModuleSet().contains(mod);
    }

    @Override
    public final boolean match(OpApplNode sn, ModuleNode mn) {
        return false;
    }

    public final TheoremNode[] getThms() {
        return null;
    }

    public final AssumeProveNode[] getAssumes() {
        return null;
    }

    @Override
    public final boolean levelCheck(int itr) {
        int i;
        int i2;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        int firstInSectIdx = 0;
        while (firstInSectIdx < this.opDefsInRecursiveSection.size()) {
            int i3;
            int curNodeIdx = firstInSectIdx;
            OpDefNode curNode = this.opDefsInRecursiveSection.elementAt(curNodeIdx);
            int curSection = curNode.recursiveSection;
            boolean notDone = true;
            while (notDone) {
                if (curNode.inRecursive) {
                    curNode.levelChecked = 1;
                    for (i2 = 0; i2 < curNode.getArity(); ++i2) {
                        curNode.maxLevels[i2] = 2;
                        curNode.weights[i2] = 1;
                    }
                } else {
                    curNode.levelChecked = 0;
                }
                if (++curNodeIdx < this.opDefsInRecursiveSection.size()) {
                    curNode = this.opDefsInRecursiveSection.elementAt(curNodeIdx);
                    notDone = curNode.recursiveSection == curSection;
                    continue;
                }
                notDone = false;
            }
            int maxRecursiveLevel = 0;
            HashSet recursiveLevelParams = new HashSet();
            HashSet recursiveAllParams = new HashSet();
            for (i3 = firstInSectIdx; i3 < curNodeIdx; ++i3) {
                curNode = this.opDefsInRecursiveSection.elementAt(i3);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 0;
                }
                curNode.levelCheck(1);
                if (!curNode.inRecursive) continue;
                for (int j = 0; j < curNode.getArity(); ++j) {
                    if (curNode.maxLevels[j] >= 2) continue;
                    errors.addError(curNode.getTreeNode().getLocation(), "Argument " + (j + 1) + " of recursive operator " + curNode.getName() + " is primed");
                }
                maxRecursiveLevel = Math.max(maxRecursiveLevel, curNode.level);
                recursiveLevelParams.addAll(curNode.levelParams);
                recursiveAllParams.addAll(curNode.allParams);
            }
            for (i3 = firstInSectIdx; i3 < curNodeIdx; ++i3) {
                curNode = this.opDefsInRecursiveSection.elementAt(i3);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 2;
                }
                curNode.level = Math.max(curNode.level, maxRecursiveLevel);
                curNode.levelParams.addAll(recursiveLevelParams);
                curNode.allParams.addAll(recursiveAllParams);
            }
            for (i3 = firstInSectIdx; i3 < curNodeIdx; ++i3) {
                curNode = this.opDefsInRecursiveSection.elementAt(i3);
                if (curNode.inRecursive) {
                    curNode.levelChecked = 1;
                }
                curNode.levelCheck(2);
            }
            firstInSectIdx = curNodeIdx;
        }
        this.levelCorrect = true;
        ModuleNode[] mods = this.getInnerModules();
        for (int i4 = 0; i4 < mods.length; ++i4) {
            if (mods[i4].levelCheck(1)) continue;
            this.levelCorrect = false;
        }
        OpDefNode[] opDefs = this.getOpDefs();
        for (i = 0; i < opDefs.length; ++i) {
            if (opDefs[i].levelCheck(1)) continue;
            this.levelCorrect = false;
        }
        this.thmOrAssDefs = this.getThmOrAssDefs();
        for (i = 0; i < this.thmOrAssDefs.length; ++i) {
            if (this.thmOrAssDefs[i].levelCheck(1)) continue;
            this.levelCorrect = false;
        }
        LevelNode[] tpLev = this.getTopLevel();
        for (int i5 = 0; i5 < tpLev.length; ++i5) {
            if (tpLev[i5].levelCheck(1)) continue;
            this.levelCorrect = false;
        }
        OpDeclNode[] decls = this.getConstantDecls();
        for (i2 = 0; i2 < decls.length; ++i2) {
            this.levelParams.add(decls[i2]);
            this.allParams.add(decls[i2]);
        }
        if (!this.isConstant()) {
            for (i2 = 0; i2 < decls.length; ++i2) {
                this.levelConstraints.put(decls[i2], Levels[0]);
            }
        }
        for (i2 = 0; i2 < opDefs.length; ++i2) {
            this.levelConstraints.putAll(opDefs[i2].getLevelConstraints());
            this.argLevelConstraints.putAll(opDefs[i2].getArgLevelConstraints());
            for (ArgLevelParam alp : opDefs[i2].getArgLevelParams()) {
                if (alp.occur(opDefs[i2].getParams())) continue;
                this.argLevelParams.add(alp);
            }
        }
        for (i2 = 0; i2 < tpLev.length; ++i2) {
            this.levelConstraints.putAll(tpLev[i2].getLevelConstraints());
            this.argLevelConstraints.putAll(tpLev[i2].getArgLevelConstraints());
            this.argLevelParams.addAll(tpLev[i2].getArgLevelParams());
        }
        return this.levelCorrect;
    }

    @Override
    public final int getLevel() {
        throw new WrongInvocationException("Internal Error: Should never call ModuleNode.getLevel()");
    }

    public final boolean isConstant() {
        int i;
        if (this.getVariableDecls().length > 0) {
            return false;
        }
        this.levelCheck(1);
        OpDefNode[] opDefs = this.getOpDefs();
        for (i = 0; i < opDefs.length; ++i) {
            if (opDefs[i].getKind() == 6 || opDefs[i].getBody().getLevel() == 0) continue;
            return false;
        }
        for (i = 0; i < this.theoremVec.size(); ++i) {
            if (((TheoremNode)this.theoremVec.elementAt(i)).getLevel() == 0) continue;
            return false;
        }
        return true;
    }

    public Collection<SymbolNode> getSymbols(SymbolMatcher symbolMatcher) {
        ArrayList<SymbolNode> result = new ArrayList<SymbolNode>();
        Enumeration<Context.Pair> content = this.ctxt.content();
        while (content.hasMoreElements()) {
            SymbolNode aSymbol = content.nextElement().getSymbol();
            if (!symbolMatcher.matches(aSymbol)) continue;
            result.add(aSymbol);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public final String levelDataToString() {
        return "LevelParams: " + this.getLevelParams() + "\nLevelConstraints: " + this.getLevelConstraints() + "\nArgLevelConstraints: " + this.getArgLevelConstraints() + "\nArgLevelParams: " + this.getArgLevelParams() + "\n";
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new SemanticNode[this.opDefs.length + this.topLevel.length];
        for (int i = 0; i < this.opDefs.length; ++i) {
            this.children[i] = this.opDefs[i];
        }
        for (int j = 0; j < this.topLevel.length; ++j) {
            this.children[i + j] = this.topLevel[j];
        }
        return this.children;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.ctxt != null) {
            this.ctxt.walkGraph(semNodesTable, visitor);
        }
        for (int i = 0; i < this.topLevelVec.size(); ++i) {
            ((LevelNode)this.topLevelVec.elementAt(i)).walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    public final void print(int indent, int depth, boolean b) {
        if (depth <= 0) {
            return;
        }
        System.out.print("*ModuleNode: " + this.name + "  " + super.toString(depth) + "  errors: " + (errors == null ? "null" : (errors.getNumErrors() == 0 ? "none" : "" + errors.getNumErrors())));
        Vector<String> contextEntries = this.ctxt.getContextEntryStringVector(depth - 1, b);
        for (int i = 0; i < contextEntries.size(); ++i) {
            System.out.print(Strings.indent(2 + indent, contextEntries.elementAt(i)));
        }
    }

    @Override
    public final String toString(int depth) {
        int i;
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ModuleNode: " + this.name + "  " + super.toString(depth) + "  constant module: " + this.isConstant() + "  errors: " + (errors == null ? "null" : (errors.getNumErrors() == 0 ? "none" : "" + errors.getNumErrors()));
        Vector<String> contextEntries = this.ctxt.getContextEntryStringVector(depth - 1, false);
        if (contextEntries != null) {
            for (i = 0; i < contextEntries.size(); ++i) {
                ret = contextEntries.elementAt(i) != null ? ret + Strings.indent(2, contextEntries.elementAt(i)) : ret + "*** null ***";
            }
        }
        ret = ret + Strings.indent(2, "\nAllExtended: " + LevelNode.HashSetToString(this.getExtendedModuleSet()));
        if (this.instanceVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nInstantiations:");
            for (i = 0; i < this.instanceVec.size(); ++i) {
                ret = ret + Strings.indent(4, ((InstanceNode)this.instanceVec.elementAt(i)).toString(1));
            }
        }
        if (this.assumptionVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nAssumptions:");
            for (i = 0; i < this.assumptionVec.size(); ++i) {
                ret = ret + Strings.indent(4, ((AssumeNode)this.assumptionVec.elementAt(i)).toString(1));
            }
        }
        if (this.theoremVec.size() > 0) {
            ret = ret + Strings.indent(2, "\nTheorems:");
            for (i = 0; i < this.theoremVec.size(); ++i) {
                ret = ret + Strings.indent(4, ((TheoremNode)this.theoremVec.elementAt(i)).toString(1));
            }
        }
        if (this.topLevelVec.size() > 0) {
            ret = ret + Strings.indent(2, "\ntopLevelVec: ");
            for (i = 0; i < this.topLevelVec.size(); ++i) {
                ret = ret + Strings.indent(4, ((LevelNode)this.topLevelVec.elementAt(i)).toString(1));
            }
        }
        return ret;
    }

    @Override
    protected String getNodeRef() {
        return "ModuleNodeRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context) {
        int i;
        Element ret = doc.createElement("ModuleNode");
        ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        LevelNode[] nodes = null;
        nodes = this.getConstantDecls();
        for (i = 0; i < nodes.length; ++i) {
            ret.appendChild(((SemanticNode)nodes[i]).export(doc, context));
        }
        nodes = this.getVariableDecls();
        for (i = 0; i < nodes.length; ++i) {
            ret.appendChild(((SemanticNode)nodes[i]).export(doc, context));
        }
        nodes = this.getOpDefs();
        for (i = 0; i < nodes.length; ++i) {
            ret.appendChild(((SemanticNode)nodes[i]).export(doc, context));
        }
        nodes = this.getTopLevel();
        for (i = 0; i < nodes.length; ++i) {
            ret.appendChild(nodes[i].export(doc, context));
        }
        return ret;
    }
}

