/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import tlc2.TLC;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class TestDriver {
    private static final int COUNT = 3;
    private static final long TIMEOUT = 5000L;
    private static int reported;
    private static TLCThread tlcThread;

    public static void main(String[] args) {
        int i = 0;
        while (i < 3) {
            System.out.println("Run " + (i + 1) + " ----------------------------------------------");
            TestDriver.callTLC(args);
            System.out.println("---------------------------------------- complete.\n");
            ++i;
        }
        System.exit(0);
    }

    private static void callTLC(String[] args) {
        TestDriver.report("entering callTLC()");
        ToolIO.reset();
        ToolIO.setMode(1);
        ToolIO.setUserDir(args[5]);
        reported = 0;
        TLC tlc = new TLC();
        TestDriver.report("tlc created " + tlc.toString());
        if (tlc.handleParameters(args)) {
            tlc.setResolver(new SimpleFilenameToStream());
            tlcThread = new TLCThread(tlc);
            tlcThread.setName("TLC Thread");
            TestDriver.report("tlcThread created " + tlcThread.getId());
            tlcThread.start();
            TestDriver.report("tlcThread " + tlcThread.getId() + "started ");
            while (TestDriver.checkAndSleep()) {
                TestDriver.report("begin report");
                TestDriver.reportProgress();
                TestDriver.report("finished report");
            }
            TestDriver.report("after while");
            TestDriver.reportProgress();
        }
        TestDriver.report("leaving callTLC()");
    }

    private static boolean checkAndSleep() {
        TestDriver.report("entering checkAndSleep()");
        try {
            TestDriver.report("go to sleep " + System.currentTimeMillis());
            Thread.sleep(5000L);
            TestDriver.report("wake up " + System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean isRunning = tlcThread.isRunning();
        TestDriver.report("leaving checkAndSleep() with " + isRunning);
        return isRunning;
    }

    private static void reportProgress() {
        TestDriver.report("entering reportProgress()");
        String[] messages = ToolIO.getAllMessages();
        while (reported < messages.length) {
            System.out.println(messages[reported]);
            ++reported;
        }
        TestDriver.report("leaving reportProgress()");
    }

    public static void report(String message) {
    }

    static class TLCThread
    extends Thread {
        private boolean isRunning;
        private final TLC tlc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TLCThread(TLC tlc) {
            this.tlc = tlc;
            TLCThread tLCThread = this;
            synchronized (tLCThread) {
                this.isRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TLCThread tLCThread = this;
            synchronized (tLCThread) {
                System.out.println("TLC Thread: ------------ {START}");
                this.isRunning = true;
            }
            this.tlc.process();
            tLCThread = this;
            synchronized (tLCThread) {
                System.out.println("TLC Thread: ------------ {FINISHED}");
                this.isRunning = false;
            }
        }

        public synchronized void setIsRunning(boolean value) {
            this.isRunning = value;
        }

        public synchronized boolean isRunning() {
            return this.isRunning;
        }
    }
}

