/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import tlc2.tool.distributed.RMIMethodMonitor;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCServerThread;

public class TLCStatistics {
    public static void writeStats(TLCServer server, Date processStart, Date computationStart, Date computationEnd, Date processEnd) {
        File wFile;
        File sFile;
        String path = System.getProperty(String.valueOf(TLCStatistics.class.getName()) + ".path");
        if (path != null) {
            sFile = new File(String.valueOf(path) + File.separator + "server.csv");
            wFile = new File(String.valueOf(path) + File.separator + "worker.csv");
        } else {
            sFile = new File("server.csv");
            wFile = new File("worker.csv");
        }
        try {
            sFile.createNewFile();
            wFile.createNewFile();
            TLCStatistics.serverStats(server, sFile, processStart, computationStart, computationEnd, processEnd);
            TLCStatistics.workerStats(server, wFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void workerStats(TLCServer server, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("WorkerName");
        writer.write(",");
        writer.write("StatesReceived");
        writer.write(",");
        writer.write("StatesComputed");
        writer.write("\n");
        TLCServerThread[] threads = server.getThreads();
        int i = 0;
        while (i < threads.length && threads[i] != null) {
            int sentStates = threads[i].getSentStates();
            int receivedStates = threads[i].getReceivedStates();
            URI name = threads[i].getUri();
            writer.write(name.toString());
            writer.write(",");
            writer.write(Integer.toString(sentStates));
            writer.write(",");
            writer.write(Integer.toString(receivedStates));
            writer.write("\n");
            ++i;
        }
        writer.close();
    }

    private static void serverStats(TLCServer server, File file, Date processStartTime, Date computationStart, Date computationEnd, Date processEndTime) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write("SpecName");
        writer.write(",");
        writer.write("ConfigName");
        writer.write(",");
        writer.write("NumberFingerprintServer");
        writer.write(",");
        writer.write("NumberWorkers");
        writer.write(",");
        writer.write("NumberCores");
        writer.write(",");
        writer.write("ProcessStartupTime");
        writer.write(",");
        writer.write("ComputationStartupTime");
        writer.write(",");
        writer.write("ComputationEndTime");
        writer.write(",");
        writer.write("ProcessEndTime");
        writer.write(",");
        writer.write("TimePassedDuringComputationInSeconds");
        writer.write(",");
        writer.write("NumberDistinctStates");
        writer.write(",");
        Map<String, Integer> invocations = RMIMethodMonitor.getInvocations();
        for (String methodName : invocations.keySet()) {
            writer.write(methodName);
            writer.write(",");
        }
        writer.write("\n");
        writer.write(server.getSpecFileName());
        writer.write(",");
        writer.write(server.getConfigFileName());
        writer.write(",");
        writer.write(server.getFPSetManager().numOfServers());
        writer.write(",");
        writer.write(Integer.toString(server.getWorkerCount()));
        writer.write(",");
        HashSet<String> hosts = new HashSet<String>();
        TLCServerThread[] threads = server.getThreads();
        int i = 0;
        while (i < threads.length && threads[i] != null) {
            String host = threads[i].getUri().getHost();
            hosts.add(host);
            ++i;
        }
        int size = hosts.size();
        int workerCount = server.getWorkerCount();
        if (workerCount == 0 || size == 0) {
            writer.write(0);
        } else {
            writer.write(Integer.toString(workerCount / size));
        }
        writer.write(",");
        writer.write(processStartTime.toString());
        writer.write(",");
        writer.write(computationStart.toString());
        writer.write(",");
        writer.write(computationEnd.toString());
        writer.write(",");
        writer.write(processEndTime.toString());
        writer.write(",");
        long elapsed = (computationEnd.getTime() - computationStart.getTime()) / 1000L;
        writer.write(Long.toString(elapsed));
        writer.write(",");
        writer.write(Long.toString(TLCServer.finalNumberOfDistinctStates));
        writer.write(",");
        for (Integer amountOfInvocations : invocations.values()) {
            writer.write(Integer.toString(amountOfInvocations));
            writer.write(",");
        }
        writer.write("\n");
        writer.close();
    }
}

