/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.junit.Before;
import org.junit.Test;
import tlc2.TLCGlobals;
import tlc2.tool.WorkerMonitor;
import tlc2.tool.liveness.ModelCheckerTestCase;

public abstract class MultiThreadedSpecTest
extends ModelCheckerTestCase {
    private final String statesGenerated;
    private final String distinctStatesGenerated;
    private final List<PerformanceResult> performanceResults = new ArrayList<PerformanceResult>();
    private final CountDownLatch latch = new CountDownLatch(this.getNumberOfThreads());
    private final double waitedRatio;
    private final double blockedRatio;

    public MultiThreadedSpecTest(String spec2, String path, String statesGenerated, String distinctStatesGenerated, double blockedRatio, double waitedRatio) {
        super(spec2, path);
        this.statesGenerated = statesGenerated;
        this.distinctStatesGenerated = distinctStatesGenerated;
        this.blockedRatio = blockedRatio;
        this.waitedRatio = waitedRatio;
    }

    public MultiThreadedSpecTest(String spec2, String path, String[] extraArguments, String statesGenerated, String distinctStatesGenerated, double blockedRatio, double waitedRatio) {
        super(spec2, path, extraArguments);
        this.statesGenerated = statesGenerated;
        this.distinctStatesGenerated = distinctStatesGenerated;
        this.blockedRatio = blockedRatio;
        this.waitedRatio = waitedRatio;
    }

    @Test
    public void testSpec() throws BrokenBarrierException, InterruptedException, TimeoutException {
        throw new Error("Unresolved compilation problems: \n\tThe method assertTrue(boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertEquals(String, int, int) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(String, boolean) is undefined for the type MultiThreadedSpecTest\n\tThe method assertTrue(String, boolean) is undefined for the type MultiThreadedSpecTest\n");
    }

    @Override
    @Before
    public void setUp() {
        TLCGlobals.livenessThreshold = Double.MAX_VALUE;
        final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        threadBean.setThreadContentionMonitoringEnabled(true);
        WorkerMonitor.addThreadListener(new WorkerMonitor.ThreadListener(){

            @Override
            public synchronized void terminated(Thread thread, long runningTime) {
                ThreadInfo threadInfo = threadBean.getThreadInfo(thread.getId());
                double d = (double)threadInfo.getBlockedTime() / ((double)runningTime * 1.0);
                double d2 = (double)threadInfo.getWaitedTime() / ((double)runningTime * 1.0);
                MultiThreadedSpecTest.this.performanceResults.add(new PerformanceResult(thread.getName(), d, d2));
                MultiThreadedSpecTest.this.latch.countDown();
            }
        });
    }

    @Override
    protected int getNumberOfThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static class PerformanceResult {
        private final double blockedRatio;
        private final double waitedRatio;
        private final String threadName;

        public PerformanceResult(String threadName, double blockedRatio, double waitedRatio) {
            this.threadName = threadName;
            this.blockedRatio = blockedRatio;
            this.waitedRatio = waitedRatio;
        }

        public double getWaitedRatio() {
            return this.waitedRatio;
        }

        public double getBlockedRatio() {
            return this.blockedRatio;
        }

        public String getThreadName() {
            return this.threadName;
        }
    }
}

