/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import gov.nasa.jpf.util.test.TestJPF;
import java.io.IOException;
import org.junit.Test;
import tlc2.tool.TLCState;
import tlc2.tool.queue.DummyTLCState;
import tlc2.tool.queue.StateQueue;

public class StateQueueJPFTest
extends TestJPF {
    public static void main(String[] args) {
        new StateQueueJPFTest().test();
    }

    @Test
    public void test() {
        if (this.verifyNoPropertyViolation(new String[0])) {
            final DummyStateQueue queue = new DummyStateQueue();
            final DummyTLCState tlcState = new DummyTLCState();
            queue.enqueue(tlcState);
            Thread main = new Thread(new Runnable(){

                @Override
                public void run() {
                    queue.suspendAll();
                    queue.resumeAll();
                }
            }, "Main");
            main.start();
            int i = 0;
            while (i < 3) {
                Thread worker = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < 3) {
                            TLCState state = queue.dequeue();
                            if (state == null) {
                                queue.finishAll();
                                return;
                            }
                            queue.enqueue(tlcState);
                            ++i;
                        }
                        queue.finishAll();
                    }
                }, "Worker" + i);
                worker.start();
                ++i;
            }
        }
    }

    private static class DummyStateQueue
    extends StateQueue {
        private TLCState state;

        private DummyStateQueue() {
        }

        @Override
        void enqueueInner(TLCState state) {
            this.state = state;
        }

        @Override
        TLCState dequeueInner() {
            return this.state;
        }

        @Override
        TLCState peekInner() {
            return this.state;
        }

        @Override
        public void beginChkpt() throws IOException {
        }

        @Override
        public void commitChkpt() throws IOException {
        }

        @Override
        public void recover() throws IOException {
        }
    }
}

