/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.Arrays;
import java.util.Collections;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import tlc2.util.FP64;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;

@State(value=Scope.Benchmark)
public class FcnRcdBenchmark {
    @Param(value={"0", "2", "4", "8", "16", "32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"})
    public int size;
    public FcnRcdValue fcnRcd;

    static {
        RandomEnumerableValues.setSeed(15041980L);
        RandomEnumerableValues.reset();
        FP64.Init();
    }

    @Setup(value=Level.Iteration)
    public void setup() {
        Value[] domain = new Value[this.size];
        Value[] range = new Value[this.size];
        int i = 0;
        while (i < domain.length) {
            domain[i] = new StringValue("asdfghjkoiuytrewqzxcvbn" + i);
            range[i] = IntValue.gen(i);
            ++i;
        }
        Collections.shuffle(Arrays.asList(domain));
        this.fcnRcd = (FcnRcdValue)new FcnRcdValue(domain, range, false).normalize();
    }

    @Benchmark
    public Value[] fcnRcdValueSelectNoIndex() {
        Value[] values = new Value[this.size];
        int i = 0;
        while (i < values.length) {
            StringValue domain = new StringValue("asdfghjkoiuytrewqzxcvbn" + i);
            values[i] = this.fcnRcd.selectLinearSearch(domain);
            ++i;
        }
        return values;
    }

    @Benchmark
    public Value[] fcnRcdValueSelectBinarySearch() {
        Value[] values = new Value[this.size];
        int i = 0;
        while (i < values.length) {
            StringValue domain = new StringValue("asdfghjkoiuytrewqzxcvbn" + i);
            values[i] = this.fcnRcd.selectBinarySearch(domain);
            ++i;
        }
        return values;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(FcnRcdBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }
}

