/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import org.eclipse.lsp4j.debug.SourceBreakpoint;
import tla2sany.st.Location;

public class TLCSourceBreakpoint
extends SourceBreakpoint {
    private final int hits;
    private final Location location;

    public TLCSourceBreakpoint(String module, SourceBreakpoint s) {
        this.setColumn(s.getColumn());
        this.setLine(s.getLine());
        int column = this.getColumn() != null ? this.getColumn() : 1;
        this.location = new Location(module, this.getLine() + 1, column, this.getLine(), column + 1);
        this.setCondition(s.getCondition());
        this.setLogMessage(s.getLogMessage());
        this.setHitCondition(s.getHitCondition());
        int h = 0;
        if (this.getHitCondition() != null) {
            try {
                h = Integer.parseInt(this.getHitCondition());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.hits = h;
    }

    public int getHits() {
        return this.hits;
    }

    public boolean isInline() {
        return this.getColumnAsInt() == -1;
    }

    public int getColumnAsInt() {
        if (this.getColumn() != null) {
            return this.getColumn();
        }
        return -1;
    }

    public Location getLocation() {
        return this.location;
    }
}

