/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.Debug;
import tla2tex.OutputFileWriter;

public final class Misc {
    private static final int MAXLEN = 48;

    public static float stringToFloat(String str) {
        int pointPos = str.indexOf(".");
        if (pointPos == -1) {
            Debug.Assert(str.length() > 0, "stringToFloat called with empty string");
            if (str.length() > 18) {
                String substr = str.substring(0, 18);
                float multiplier = 1.0f;
                for (float exponent = (float)(str.length() - 18); exponent > 0.0f; exponent -= 1.0f) {
                    multiplier *= 10.0f;
                }
                return (float)Long.parseLong(substr) * multiplier;
            }
            return Long.parseLong(str);
        }
        String strMinusPoint = str.substring(0, pointPos) + str.substring(pointPos + 1);
        Debug.Assert(strMinusPoint.length() > 0, "stringToFloat called with the string \".\"");
        if (strMinusPoint.length() > 18) {
            strMinusPoint = strMinusPoint.substring(0, 18);
        }
        long divisor = 1L;
        for (long exponent = (long)(strMinusPoint.length() - pointPos); exponent > 0L; --exponent) {
            divisor *= 10L;
        }
        return (float)Long.parseLong(strMinusPoint) / (float)divisor;
    }

    public static String floatToString(float f, int d) {
        int ptPos;
        String fStr = "" + f;
        int ePos = fStr.indexOf("E");
        int shiftRight = 0;
        float tenToTheMinusD = 1.0f;
        for (int i = d; i > 0; --i) {
            tenToTheMinusD /= 10.0f;
        }
        if (f <= tenToTheMinusD) {
            return "0";
        }
        if (ePos != -1) {
            shiftRight = Integer.parseInt(fStr.substring(ePos + 1));
            fStr = fStr.substring(0, ePos);
            ptPos = fStr.indexOf(".");
            fStr = fStr.substring(0, ptPos) + fStr.substring(ptPos + 1);
            ptPos += shiftRight;
            while (ptPos < 0) {
                fStr = "0" + fStr;
                ++ptPos;
            }
            while (ptPos > fStr.length()) {
                fStr = fStr + "0";
            }
            if (ptPos != fStr.length()) {
                fStr = fStr.substring(0, ptPos) + "." + fStr.substring(ptPos);
            }
        }
        if ((ptPos = fStr.indexOf(".")) == -1) {
            return fStr;
        }
        while (fStr.length() - ptPos > d + 1) {
            fStr = fStr.substring(0, fStr.length() - 1);
        }
        return fStr;
    }

    public static void WriteIfNonNull(OutputFileWriter writer, String str) {
        if (!str.equals("")) {
            Misc.BreakStringOut(writer, str);
        }
    }

    public static void BreakStringOut(OutputFileWriter output, String str) {
        String restOfString = str;
        String nextLine = "";
        boolean done = false;
        boolean cut = false;
        while (!done && restOfString.length() > 78) {
            int lastSpace = restOfString.lastIndexOf(32, 77);
            if (lastSpace == -1) {
                lastSpace = restOfString.indexOf(32);
            }
            if (lastSpace <= 19) {
                done = true;
                continue;
            }
            cut = true;
            String outputLine = Misc.EliminateLeadingBlanks(restOfString.substring(0, lastSpace));
            restOfString = restOfString.substring(lastSpace);
            if (outputLine.equals("")) continue;
            output.putLine(" " + outputLine);
        }
        if (cut) {
            if (!(restOfString = Misc.EliminateLeadingBlanks(restOfString)).equals("")) {
                output.putLine(" " + restOfString);
            }
        } else {
            output.putLine(restOfString);
        }
    }

    public static String EliminateLeadingBlanks(String str) {
        int firstNonBlank;
        for (firstNonBlank = 0; firstNonBlank < str.length() && str.charAt(firstNonBlank) == ' '; ++firstNonBlank) {
        }
        return str.substring(firstNonBlank);
    }

    public static String TeXify(String str) {
        String result = "";
        block15: for (int pos = 0; pos < str.length(); ++pos) {
            switch (str.charAt(pos)) {
                case '_': {
                    result = result + "\\_";
                    continue block15;
                }
                case '{': {
                    result = result + "\\{";
                    continue block15;
                }
                case '}': {
                    result = result + "\\}";
                    continue block15;
                }
                case '\\': {
                    result = result + "\\ensuremath{\\backslash}";
                    continue block15;
                }
                case '&': {
                    result = result + "\\&";
                    continue block15;
                }
                case '%': {
                    result = result + "\\%";
                    continue block15;
                }
                case '$': {
                    result = result + "\\$";
                    continue block15;
                }
                case '#': {
                    result = result + "\\#";
                    continue block15;
                }
                case '~': {
                    result = result + "\\ensuremath{\\sim}";
                    continue block15;
                }
                case '^': {
                    result = result + "\\ensuremath{\\ct}";
                    continue block15;
                }
                case '<': {
                    result = result + "\\ensuremath{<}";
                    continue block15;
                }
                case '>': {
                    result = result + "\\ensuremath{>}";
                    continue block15;
                }
                case '|': {
                    result = result + "\\ensuremath{|}";
                    continue block15;
                }
                default: {
                    result = result + str.charAt(pos);
                }
            }
        }
        return result;
    }

    public static String TeXifyIdent(String str) {
        String out = str;
        int nextUS = str.indexOf("_");
        while (nextUS != -1) {
            out = nextUS == 0 ? "\\" + out : out.substring(0, nextUS) + "\\_" + out.substring(nextUS + 1);
            nextUS = out.indexOf("_", nextUS + 2);
        }
        return out;
    }

    public static String TeXifyPcalLabel(String str) {
        String out = "";
        int next = 0;
        while (next < str.length() && Misc.IsLetter(str.charAt(next)) || Misc.IsDigit(str.charAt(next))) {
            char nextChar = str.charAt(next);
            ++next;
            if (nextChar == '_') {
                out = out + "\\";
            }
            out = out + nextChar;
        }
        int numberOfSpaces = 0;
        while (next < str.length() && Misc.IsSpace(str.charAt(next))) {
            ++numberOfSpaces;
            ++next;
        }
        out = numberOfSpaces == 0 ? out + "\\@s{.5}" : out + "\\@s{2.5}";
        out = out + "\\textrm{";
        while (next < str.length()) {
            char nextChar = str.charAt(next);
            ++next;
            if (Misc.IsSpace(nextChar)) continue;
            out = out + nextChar;
        }
        out = out + (numberOfSpaces == 0 ? "}\\@s{3}" : "}\\@s{4}");
        return out;
    }

    public static String BreakLine(String str) {
        int lineLen = 0;
        String newStr = "";
        char ch = '0';
        for (int nextChar = 0; nextChar < str.length(); ++nextChar) {
            ch = str.charAt(nextChar);
            if (ch == '\t') {
                if (lineLen <= 48) continue;
                newStr = newStr + "\n       ";
                lineLen = 7;
                continue;
            }
            newStr = newStr + ch;
            ++lineLen;
        }
        return newStr;
    }

    public static boolean IsLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_';
    }

    public static boolean hasLetter(String str) {
        boolean notFound = true;
        for (int i = 0; notFound && i < str.length(); ++i) {
            if (!Misc.IsLetter(str.charAt(i))) continue;
            notFound = false;
        }
        return !notFound;
    }

    public static boolean IsDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean IsSpace(char c) {
        return c == ' ' | c == '\f' | c == '\r';
    }

    public static boolean isBlank(String str) {
        return str.trim().equals("");
    }

    public static boolean IsLowerCase(String str) {
        boolean result = true;
        for (int i = 0; i < str.length() && result; ++i) {
            char c = str.charAt(i);
            if ('a' <= c && c <= 'z') continue;
            result = false;
        }
        return result;
    }

    public static boolean IsUpperCase(String str) {
        boolean result = true;
        for (int i = 0; i < str.length() && result; ++i) {
            char c = str.charAt(i);
            if ('A' <= c && c <= 'Z') continue;
            result = false;
        }
        return result;
    }

    public static boolean IsCapitalized(String str) {
        if (str.length() > 0) {
            char c = str.charAt(0);
            return 'A' <= c && c <= 'Z' && Misc.IsLowerCase(str.substring(1));
        }
        return false;
    }
}

