/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tlc2.TLCGlobals;
import tlc2.debug.TLCDebugger;
import tlc2.tool.impl.DebugTool;
import tlc2.util.FP64;
import util.FilenameToStream;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class StandaloneConstExpressionDebugger
extends TLCDebugger {
    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        new StandaloneConstExpressionDebugger();
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, Object> args) {
        LOGGER.finer("launch");
        Path p = Paths.get((String)args.get("program"), new String[0]);
        String specPath = p.getParent().toAbsolutePath().toString();
        String specName = p.getFileName().toFile().toString();
        String moduleName = specName.replaceFirst(".tla$", "");
        FP64.Init();
        ToolIO.out = new PrintStream(ToolIO.out){

            @Override
            public void println(String str) {
                ((PrintStream)this.out).println(str);
                this.sendOutput(str + "\n");
            }

            @Override
            public void print(String str) {
                ((PrintStream)this.out).print(str);
                this.sendOutput(str);
            }

            private void sendOutput(String str) {
                OutputEventArguments oea = new OutputEventArguments();
                oea.setOutput(str);
                if (StandaloneConstExpressionDebugger.this.launcher != null) {
                    ((IDebugProtocolClient)StandaloneConstExpressionDebugger.this.launcher.getRemoteProxy()).output(oea);
                }
            }
        };
        ToolIO.reset();
        DebugTool tool = new DebugTool(moduleName, specName, (FilenameToStream)new SimpleFilenameToStream(specPath), new HashMap<String, Object>(), this);
        ModuleNode module = tool.getSpecProcessor().getRootModule();
        OpDefNode valueNode = module.getOpDef("debugMe");
        Executors.newSingleThreadExecutor().submit(() -> {
            TLCGlobals.expand = false;
            tool.eval(valueNode.getBody());
        });
        return CompletableFuture.completedFuture(null);
    }
}

