/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.IOException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStates;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;

@State(value=Scope.Group)
public class StateQueueBenachmark {
    @Param(value={"1", "2", "4", "8", "16", "32", "64"})
    public int size;
    private IStateQueue s;
    private TLCState[] batch;

    @Setup
    public void up() throws IOException {
        this.s = new DiskStateQueue();
        this.batch = new TLCState[this.size];
        int i = 0;
        while (i < this.batch.length) {
            this.batch[i] = TLCStates.createDummyState();
            ++i;
        }
    }

    @TearDown
    public void down() throws IOException {
        this.s.delete();
    }

    @Benchmark
    @Group(value="single")
    @GroupThreads(value=2)
    public TLCState[] consumerSingle() {
        TLCState[] res = new TLCState[this.batch.length];
        int i = 0;
        while (i < this.batch.length) {
            res[i] = this.s.sDequeue();
            ++i;
        }
        return res;
    }

    @Benchmark
    @Group(value="single")
    @GroupThreads(value=2)
    public void producerSingle() {
        int i = 0;
        while (i < this.batch.length) {
            this.s.sEnqueue(this.batch[i]);
            ++i;
        }
    }

    @Benchmark
    @Group(value="batchasym")
    @GroupThreads(value=2)
    public TLCState[] consumerBatch() {
        TLCState[] res = new TLCState[this.batch.length];
        int i = 0;
        while (i < this.batch.length) {
            res[i] = this.s.sDequeue();
            ++i;
        }
        return res;
    }

    @Benchmark
    @Group(value="batchasym")
    @GroupThreads(value=2)
    public void producerBatch() {
        this.s.sEnqueue(this.batch);
    }

    @Benchmark
    @Group(value="batchsym")
    @GroupThreads(value=2)
    public TLCState[] consumerBatchSym() {
        return this.s.sDequeue(this.size);
    }

    @Benchmark
    @Group(value="batchsym")
    @GroupThreads(value=2)
    public void producerBatchSym() {
        this.s.sEnqueue(this.batch);
    }
}

