/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PCalLocation;
import pcal.PcalParams;
import pcal.Region;
import pcal.TLAExpr;

public class AST {
    public static Uniprocess UniprocessObj;
    public static Multiprocess MultiprocessObj;
    public static Procedure ProcedureObj;
    public static Process ProcessObj;
    public static VarDecl VarDeclObj;
    public static PVarDecl PVarDeclObj;
    public static LabeledStmt LabeledStmtObj;
    public static While WhileObj;
    public static Assign AssignObj;
    public static SingleAssign SingleAssignObj;
    public static Lhs LhsObj;
    public static If IfObj;
    public static Either EitherObj;
    public static With WithObj;
    public static When WhenObj;
    public static PrintS PrintSObj;
    public static Assert AssertObj;
    public static Skip SkipObj;
    public static LabelIf LabelIfObj;
    public static LabelEither LabelEitherObj;
    public static Clause ClauseObj;
    public static Call CallObj;
    public static Return ReturnObj;
    public static CallReturn CallReturnObj;
    public static CallGoto CallGotoObj;
    public static Goto GotoObj;
    public static Macro MacroObj;
    public static MacroCall MacroCallObj;
    public int col;
    public int line;
    public int macroCol = 0;
    public int macroLine = -1;
    public PCalLocation macroOriginBegin = null;
    public PCalLocation macroOriginEnd = null;
    public String lbl = "";
    public PCalLocation lblLocation = null;
    private Region origin = null;
    public static final int UNFAIR_PROC = 0;
    public static final int WF_PROC = 1;
    public static final int SF_PROC = 2;
    public static final String[] FairnessString;
    public static int indentDepth;
    public static int[] curIndent;

    static {
        FairnessString = new String[]{"unfair", "wf", "sf"};
        indentDepth = 0;
        curIndent = new int[107];
    }

    public Region getOrigin() {
        return this.origin;
    }

    public void setOrigin(Region origin) {
        this.origin = origin;
    }

    public String location() {
        if (this.macroLine < 0) {
            return "line " + this.line + ", column " + this.col;
        }
        return "line " + this.line + ", column " + this.col + " of macro called at line " + this.macroLine + ", column " + this.macroCol;
    }

    public static void ASTInit() {
        UniprocessObj = new Uniprocess();
        MultiprocessObj = new Multiprocess();
        ProcedureObj = new Procedure();
        ProcessObj = new Process();
        VarDeclObj = new VarDecl();
        PVarDeclObj = new PVarDecl();
        LabeledStmtObj = new LabeledStmt();
        WhileObj = new While();
        AssignObj = new Assign();
        SingleAssignObj = new SingleAssign();
        LhsObj = new Lhs();
        IfObj = new If();
        EitherObj = new Either();
        WithObj = new With();
        WhenObj = new When();
        PrintSObj = new PrintS();
        AssertObj = new Assert();
        SkipObj = new Skip();
        LabelIfObj = new LabelIf();
        LabelEitherObj = new LabelEither();
        CallObj = new Call();
        ReturnObj = new Return();
        CallReturnObj = new CallReturn();
        CallGotoObj = new CallGoto();
        GotoObj = new Goto();
        MacroObj = new Macro();
        MacroCallObj = new MacroCall();
    }

    public String boolToEqOrIn(boolean iseq) {
        if (iseq) {
            return "\"=\"";
        }
        return "\"\\\\in\"";
    }

    public String lineCol() {
        if (PcalParams.Debug) {
            return "(*" + this.line + ", " + this.col + "*)";
        }
        return "";
    }

    public static String Indent(String str) {
        AST.curIndent[AST.indentDepth + 1] = curIndent[indentDepth] + str.length();
        ++indentDepth;
        return str;
    }

    public static String EndIndent() {
        --indentDepth;
        return "";
    }

    public static String NewLine() {
        String result = "\n";
        int i = 0;
        while (i < curIndent[indentDepth]) {
            result = String.valueOf(result) + " ";
            ++i;
        }
        return result;
    }

    public static String VectorToSeqString(Vector vec) {
        if (vec == null) {
            return "null";
        }
        String result = AST.Indent("<<");
        int i = 0;
        while (i < vec.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ", " + AST.NewLine();
            }
            result = String.valueOf(result) + vec.elementAt(i).toString();
            ++i;
        }
        return String.valueOf(result) + ">>" + AST.EndIndent();
    }

    public static String VectorToSeqQuotedString(Vector vec) {
        if (vec == null) {
            return "null";
        }
        String result = AST.Indent("<<");
        int i = 0;
        while (i < vec.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "\"" + vec.elementAt(i).toString() + "\"";
            ++i;
        }
        return String.valueOf(result) + ">>" + AST.EndIndent();
    }

    public static String VectorOfVectorsToSeqString(Vector vecvec) {
        String result = AST.Indent("<< ");
        int i = 0;
        while (i < vecvec.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ", " + AST.NewLine();
            }
            result = String.valueOf(result) + AST.VectorToSeqString((Vector)vecvec.elementAt(i));
            ++i;
        }
        return String.valueOf(result) + " >>" + AST.EndIndent();
    }

    public static class Assert
    extends AST {
        public TLAExpr exp = null;

        public String toString() {
            return String.valueOf(Assert.Indent(this.lineCol())) + "[type |-> \"assert\", " + Assert.NewLine() + " exp |-> " + this.exp.toString() + "]" + Assert.EndIndent();
        }
    }

    public static class Assign
    extends AST {
        public Vector ass = null;

        public String toString() {
            return String.valueOf(Assign.Indent(this.lineCol())) + "[type |-> \"assignment\"," + Assign.NewLine() + Assign.Indent(" ass  |-> ") + Assign.VectorToSeqString(this.ass) + "]" + Assign.EndIndent() + Assign.EndIndent();
        }
    }

    public static class Call
    extends AST {
        public String returnTo = "";
        public String to = "";
        public Vector args = null;

        public String toString() {
            return String.valueOf(Call.Indent(this.lineCol())) + "[type     |-> \"call\"," + Call.NewLine() + " returnTo |-> \"" + this.returnTo + "\"," + Call.NewLine() + " to       |-> \"" + this.to + "\"," + Call.NewLine() + Call.Indent(" args     |-> ") + Call.VectorToSeqString(this.args) + "]" + Call.EndIndent() + Call.EndIndent();
        }
    }

    public static class CallGoto
    extends AST {
        public String after = "";
        public String to = "";
        public Vector args = null;

        public String toString() {
            return String.valueOf(CallGoto.Indent(this.lineCol())) + "[type     |-> \"callGoto\"," + CallGoto.NewLine() + " after    |-> \"" + this.after + "\"," + CallGoto.NewLine() + " to       |-> \"" + this.to + "\"," + CallGoto.NewLine() + CallGoto.Indent("args     |-> ") + CallGoto.VectorToSeqString(this.args) + "]" + CallGoto.NewLine() + CallGoto.EndIndent() + CallGoto.EndIndent();
        }
    }

    public static class CallReturn
    extends AST {
        public String from = "";
        public String to = "";
        public Vector args = null;

        public String toString() {
            return String.valueOf(CallReturn.Indent(this.lineCol())) + "[type     |-> \"callReturn\"," + CallReturn.NewLine() + " from     |-> \"" + this.from + "\"," + CallReturn.NewLine() + " to       |-> \"" + this.to + "\"," + CallReturn.NewLine() + CallReturn.Indent("args     |-> ") + CallReturn.VectorToSeqString(this.args) + "]" + CallReturn.NewLine() + CallReturn.EndIndent() + CallReturn.EndIndent();
        }
    }

    public static class Clause
    extends AST {
        public Vector unlabOr = null;
        public Vector labOr = null;
        private boolean broken = false;

        public boolean isBroken() {
            return this.broken;
        }

        public void setBroken(boolean broken) {
            this.broken = broken;
        }

        public String toString() {
            return String.valueOf(Clause.Indent(this.lineCol())) + Clause.Indent("[unlabOr |-> ") + Clause.VectorToSeqString(this.unlabOr) + "," + Clause.EndIndent() + Clause.NewLine() + Clause.Indent(" labOr   |-> ") + Clause.VectorToSeqString(this.labOr) + "]" + Clause.EndIndent() + Clause.NewLine() + Clause.EndIndent();
        }
    }

    public static class Either
    extends AST {
        public Vector ors = null;

        public String toString() {
            return String.valueOf(Either.Indent(this.lineCol())) + "[type |-> \"either\", " + Either.NewLine() + Either.Indent(" ors  |-> ") + Either.VectorOfVectorsToSeqString(this.ors) + "]" + Either.EndIndent() + Either.EndIndent();
        }
    }

    public static class Goto
    extends AST {
        public String to = "";

        public String toString() {
            return String.valueOf(this.lineCol()) + "[type |-> \"goto\", " + " to |-> \"" + this.to + "\"]";
        }
    }

    public static class If
    extends AST {
        public TLAExpr test = null;
        public Vector Then = null;
        public Vector Else = null;
        public static final int UNBROKEN = 0;
        public static final int BROKEN_WHILE = 1;
        public static final int BROKEN_THEN = 2;
        public static final int BROKEN_ELSE = 4;
        private int source = 0;

        public int getSource() {
            return this.source;
        }

        public void setSource(int source) {
            this.source = source;
        }

        public String toString() {
            return String.valueOf(If.Indent(this.lineCol())) + "[type    |-> \"if\", " + If.NewLine() + " test    |-> " + this.test.toString() + "," + If.NewLine() + If.Indent(" then |-> ") + If.VectorToSeqString(this.Then) + "," + If.EndIndent() + If.NewLine() + If.Indent(" else |-> ") + If.VectorToSeqString(this.Else) + "]" + If.EndIndent() + If.EndIndent();
        }
    }

    public static class LabelEither
    extends AST {
        public Vector clauses = null;

        public String toString() {
            return String.valueOf(LabelEither.Indent(this.lineCol())) + "[type    |-> \"labelEither\"," + LabelEither.NewLine() + LabelEither.Indent(" clauses |-> ") + LabelEither.VectorToSeqString(this.clauses) + "]" + LabelEither.EndIndent() + LabelEither.NewLine() + LabelEither.EndIndent();
        }
    }

    public static class LabelIf
    extends AST {
        public TLAExpr test = null;
        public Vector unlabThen = null;
        public Vector labThen = null;
        public Vector unlabElse = null;
        public Vector labElse = null;

        public String toString() {
            return String.valueOf(LabelIf.Indent(this.lineCol())) + "[type      |-> \"labelIf\"," + LabelIf.NewLine() + " test      |-> " + this.test.toString() + "," + LabelIf.NewLine() + LabelIf.Indent(" unlabThen |-> ") + LabelIf.VectorToSeqString(this.unlabThen) + "," + LabelIf.EndIndent() + LabelIf.NewLine() + LabelIf.Indent(" labThen   |-> ") + LabelIf.VectorToSeqString(this.labThen) + "," + LabelIf.EndIndent() + LabelIf.NewLine() + LabelIf.Indent(" unlabElse |-> ") + LabelIf.VectorToSeqString(this.unlabElse) + "," + LabelIf.EndIndent() + LabelIf.NewLine() + LabelIf.Indent(" labElse   |-> ") + LabelIf.VectorToSeqString(this.labElse) + "]" + LabelIf.EndIndent() + LabelIf.NewLine() + LabelIf.EndIndent();
        }
    }

    public static class LabeledStmt
    extends AST {
        public String label = null;
        public Vector stmts = null;

        public String toString() {
            return String.valueOf(LabeledStmt.Indent(this.lineCol())) + "[label |-> \"" + this.label + "\"," + LabeledStmt.NewLine() + LabeledStmt.Indent(" stmts |-> ") + LabeledStmt.VectorToSeqString(this.stmts) + "]" + LabeledStmt.EndIndent() + LabeledStmt.EndIndent();
        }
    }

    public static class Lhs
    extends AST {
        public String var = "";
        public TLAExpr sub = null;

        public String toString() {
            return String.valueOf(this.lineCol()) + "[var |-> \"" + this.var + "\", sub |-> " + this.sub.toString() + "]";
        }
    }

    public static class Macro
    extends AST {
        public String name = "";
        public Vector params = null;
        public Vector body = null;

        public String toString() {
            return String.valueOf(Macro.Indent(this.lineCol())) + "[name   |-> \"" + this.name + "\", " + Macro.NewLine() + Macro.Indent(" params |-> ") + Macro.VectorToSeqString(this.params) + "," + Macro.EndIndent() + Macro.NewLine() + Macro.Indent(" body   |-> ") + Macro.VectorToSeqString(this.body) + "]" + Macro.EndIndent() + Macro.EndIndent();
        }
    }

    public static class MacroCall
    extends AST {
        public String name = "";
        public Vector args = null;

        public String toString() {
            return String.valueOf(MacroCall.Indent(this.lineCol())) + "[type |-> \"macrocall\"," + MacroCall.NewLine() + " name |-> \"" + this.name + "\"," + MacroCall.NewLine() + MacroCall.Indent(" args     |-> ") + MacroCall.VectorToSeqString(this.args) + "]" + MacroCall.EndIndent() + MacroCall.EndIndent();
        }
    }

    public static class Multiprocess
    extends AST {
        public String name = "";
        public Vector decls = null;
        public TLAExpr defs = null;
        public Vector macros = null;
        public Vector prcds = null;
        public Vector procs = null;

        public String toString() {
            return String.valueOf(Multiprocess.Indent(this.lineCol())) + "[type    |-> \"multiprocess\", " + Multiprocess.NewLine() + " name  |-> \"" + this.name + "\", " + Multiprocess.NewLine() + Multiprocess.Indent(" decls |-> ") + Multiprocess.VectorToSeqString(this.decls) + "," + Multiprocess.EndIndent() + Multiprocess.NewLine() + Multiprocess.Indent(" defs  |-> ") + this.defs.toString() + "," + Multiprocess.EndIndent() + Multiprocess.NewLine() + Multiprocess.Indent(" prcds |-> ") + Multiprocess.VectorToSeqString(this.prcds) + "," + Multiprocess.EndIndent() + Multiprocess.NewLine() + Multiprocess.Indent(" procs |-> ") + Multiprocess.VectorToSeqString(this.procs) + "]" + Multiprocess.EndIndent() + Multiprocess.EndIndent();
        }
    }

    public static class PVarDecl
    extends AST {
        public final boolean isEq = true;
        public String var = null;
        public TLAExpr val = PcalParams.DefaultVarInit();

        public VarDecl toVarDecl() {
            VarDecl result = new VarDecl();
            result.var = this.var;
            result.val = this.val;
            result.setOrigin(this.getOrigin());
            result.isEq = true;
            return result;
        }

        public String toString() {
            return String.valueOf(PVarDecl.Indent(this.lineCol())) + "[var |-> \"" + this.var + "\", " + "eqOrIn |-> \"=\", " + "val |-> " + this.val.toString() + "]" + PVarDecl.EndIndent();
        }
    }

    public static class PrintS
    extends AST {
        public TLAExpr exp = null;

        public String toString() {
            return String.valueOf(PrintS.Indent(this.lineCol())) + "[type |-> \"print\", " + PrintS.NewLine() + " exp |-> " + this.exp.toString() + "]" + PrintS.EndIndent();
        }
    }

    public static class Procedure
    extends AST {
        public String name = "";
        public Vector minusLabels = new Vector();
        public Vector plusLabels = new Vector();
        public Vector proceduresCalled = new Vector();
        public Vector params = null;
        public Vector decls = null;
        public Vector body = null;

        public String toString() {
            if (PcalParams.inputVersionNumber < PcalParams.VersionToNumber("1.5")) {
                return String.valueOf(Procedure.Indent(this.lineCol())) + "[name   |-> \"" + this.name + "\", " + Procedure.NewLine() + Procedure.Indent(" params |-> ") + Procedure.VectorToSeqString(this.params) + "," + Procedure.EndIndent() + Procedure.NewLine() + Procedure.Indent(" decls  |-> ") + Procedure.VectorToSeqString(this.decls) + "," + Procedure.EndIndent() + Procedure.NewLine() + Procedure.Indent(" body   |-> ") + Procedure.VectorToSeqString(this.body) + "]" + Procedure.EndIndent() + Procedure.EndIndent();
            }
            return String.valueOf(Procedure.Indent(this.lineCol())) + "[name   |-> \"" + this.name + "\", " + Procedure.NewLine() + "minusLabels |-> " + Procedure.VectorToSeqQuotedString(this.minusLabels) + ", plusLabels |->" + Procedure.VectorToSeqQuotedString(this.plusLabels) + ", proceduresCalled |->" + Procedure.VectorToSeqQuotedString(this.proceduresCalled) + "," + Procedure.NewLine() + Procedure.Indent(" params |-> ") + Procedure.VectorToSeqString(this.params) + "," + Procedure.EndIndent() + Procedure.NewLine() + Procedure.Indent(" decls  |-> ") + Procedure.VectorToSeqString(this.decls) + "," + Procedure.EndIndent() + Procedure.NewLine() + Procedure.Indent(" body   |-> ") + Procedure.VectorToSeqString(this.body) + "]" + Procedure.EndIndent() + Procedure.EndIndent();
        }
    }

    public static class Process
    extends AST {
        public String name = "";
        public int fairness = 0;
        public Vector minusLabels = new Vector();
        public Vector plusLabels = new Vector();
        public Vector proceduresCalled = new Vector();
        public boolean isEq = true;
        public TLAExpr id = null;
        public Vector decls = null;
        public Vector body = null;

        public String toString() {
            if (PcalParams.inputVersionNumber < PcalParams.VersionToNumber("1.5")) {
                return String.valueOf(Process.Indent(this.lineCol())) + "[name   |-> \"" + this.name + "\", " + Process.NewLine() + " eqOrIn |-> " + this.boolToEqOrIn(this.isEq) + "," + Process.NewLine() + " id     |-> " + this.id.toString() + "," + Process.NewLine() + Process.Indent(" decls  |-> ") + Process.VectorToSeqString(this.decls) + "," + Process.EndIndent() + Process.NewLine() + Process.Indent(" body   |-> ") + Process.VectorToSeqString(this.body) + "]" + Process.EndIndent() + Process.EndIndent();
            }
            return String.valueOf(Process.Indent(this.lineCol())) + "[name   |-> \"" + this.name + "\"," + Process.NewLine() + " fairness |-> \"" + FairnessString[this.fairness] + "\", minusLabels |-> " + Process.VectorToSeqQuotedString(this.minusLabels) + ", plusLabels |->" + Process.VectorToSeqQuotedString(this.plusLabels) + ", proceduresCalled |->" + Process.VectorToSeqQuotedString(this.proceduresCalled) + "," + Process.NewLine() + " eqOrIn |-> " + this.boolToEqOrIn(this.isEq) + "," + Process.NewLine() + " id     |-> " + this.id.toString() + "," + Process.NewLine() + Process.Indent(" decls  |-> ") + Process.VectorToSeqString(this.decls) + "," + Process.EndIndent() + Process.NewLine() + Process.Indent(" body   |-> ") + Process.VectorToSeqString(this.body) + "]" + Process.EndIndent() + Process.EndIndent();
        }
    }

    public static class Return
    extends AST {
        public String from = "";

        public String toString() {
            return String.valueOf(this.lineCol()) + "[type |-> \"return\", from |-> \"" + this.from + "\"]";
        }
    }

    public static class SingleAssign
    extends AST {
        public Lhs lhs = new Lhs();
        public TLAExpr rhs = null;

        public String toString() {
            return String.valueOf(SingleAssign.Indent(this.lineCol())) + "[lhs |-> " + this.lhs.toString() + "," + SingleAssign.NewLine() + " rhs |-> " + this.rhs.toString() + "]" + SingleAssign.EndIndent();
        }
    }

    public static class Skip
    extends AST {
        public String toString() {
            return String.valueOf(this.lineCol()) + "[type |-> \"skip\"]";
        }
    }

    public static class Uniprocess
    extends AST {
        public String name = "";
        public Vector decls = null;
        public TLAExpr defs = null;
        public Vector macros = null;
        public Vector prcds = null;
        public Vector body = null;

        public String toString() {
            return String.valueOf(Uniprocess.Indent(this.lineCol())) + "[type     |-> \"uniprocess\", " + Uniprocess.NewLine() + " name  |-> \"" + this.name + "\", " + Uniprocess.NewLine() + Uniprocess.Indent(" decls  |-> ") + Uniprocess.VectorToSeqString(this.decls) + "," + Uniprocess.EndIndent() + Uniprocess.NewLine() + Uniprocess.Indent(" defs   |-> ") + this.defs.toString() + "," + Uniprocess.EndIndent() + Uniprocess.NewLine() + Uniprocess.Indent(" prcds  |-> ") + Uniprocess.VectorToSeqString(this.prcds) + "," + Uniprocess.EndIndent() + Uniprocess.NewLine() + Uniprocess.Indent(" body  |-> ") + Uniprocess.VectorToSeqString(this.body) + "]" + Uniprocess.EndIndent() + Uniprocess.EndIndent();
        }
    }

    public static class VarDecl
    extends AST {
        public String var = null;
        public boolean isEq = true;
        public TLAExpr val = PcalParams.DefaultVarInit();

        public String toString() {
            return String.valueOf(VarDecl.Indent(this.lineCol())) + "[var |-> \"" + this.var + "\", " + "eqOrIn |-> " + this.boolToEqOrIn(this.isEq) + ", " + "val |-> " + this.val.toString() + "]" + VarDecl.EndIndent();
        }
    }

    public static class When
    extends AST {
        public TLAExpr exp = null;

        public String toString() {
            return String.valueOf(When.Indent(this.lineCol())) + "[type |-> \"when\", " + When.NewLine() + " exp |-> " + this.exp.toString() + "]" + When.EndIndent();
        }
    }

    public static class While
    extends AST {
        public TLAExpr test = null;
        public Vector unlabDo = null;
        public Vector labDo = null;

        public String toString() {
            return String.valueOf(While.Indent(this.lineCol())) + "[type    |-> \"while\", " + While.NewLine() + " test    |-> " + this.test.toString() + "," + While.NewLine() + While.Indent(" labDo   |-> ") + While.VectorToSeqString(this.labDo) + "," + While.EndIndent() + While.NewLine() + While.Indent(" unlabDo |-> ") + While.VectorToSeqString(this.unlabDo) + "]" + While.EndIndent() + While.EndIndent();
        }
    }

    public static class With
    extends AST {
        public String var = "";
        public boolean isEq = true;
        public TLAExpr exp = null;
        public Vector Do = null;

        public String toString() {
            return String.valueOf(With.Indent(this.lineCol())) + "[type   |-> \"with\", " + With.NewLine() + " var    |-> \"" + this.var + "\"," + With.NewLine() + " eqOrIn |-> " + this.boolToEqOrIn(this.isEq) + "," + With.NewLine() + " exp    |-> " + this.exp.toString() + "," + With.NewLine() + With.Indent(" do     |-> ") + With.VectorToSeqString(this.Do) + "]" + With.EndIndent() + With.EndIndent();
        }
    }
}

