/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.PcalDebug;
import pcal.PcalSymTab;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.exception.PcalFixIDException;
import pcal.exception.TLAExprException;

public class PcalFixIDs {
    private static PcalSymTab st = null;

    public static void Fix(AST ast, PcalSymTab stab) throws PcalFixIDException {
        st = stab;
        PcalFixIDs.FixSym(ast, "");
        if (PcalFixIDs.st.iPC != null) {
            PcalFixIDs.st.iPC = st.UseThis(1, PcalFixIDs.st.iPC, "");
        }
    }

    private static void FixSym(AST ast, String context) throws PcalFixIDException {
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            PcalFixIDs.FixUniprocess((AST.Uniprocess)ast, context);
        } else if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            PcalFixIDs.FixMultiprocess((AST.Multiprocess)ast, context);
        } else if (ast.getClass().equals(AST.ProcedureObj.getClass())) {
            PcalFixIDs.FixProcedure((AST.Procedure)ast, context);
        } else if (ast.getClass().equals(AST.ProcessObj.getClass())) {
            PcalFixIDs.FixProcess((AST.Process)ast, context);
        } else if (ast.getClass().equals(AST.LabeledStmtObj.getClass())) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast, context);
        } else if (ast.getClass().equals(AST.WhileObj.getClass())) {
            PcalFixIDs.FixWhile((AST.While)ast, context);
        } else if (ast.getClass().equals(AST.AssignObj.getClass())) {
            PcalFixIDs.FixAssign((AST.Assign)ast, context);
        } else if (ast.getClass().equals(AST.SingleAssignObj.getClass())) {
            PcalFixIDs.FixSingleAssign((AST.SingleAssign)ast, context);
        } else if (ast.getClass().equals(AST.LhsObj.getClass())) {
            PcalFixIDs.FixLhs((AST.Lhs)ast, context);
        } else if (ast.getClass().equals(AST.IfObj.getClass())) {
            PcalFixIDs.FixIf((AST.If)ast, context);
        } else if (ast.getClass().equals(AST.WithObj.getClass())) {
            PcalFixIDs.FixWith((AST.With)ast, context);
        } else if (ast.getClass().equals(AST.WhenObj.getClass())) {
            PcalFixIDs.FixWhen((AST.When)ast, context);
        } else if (ast.getClass().equals(AST.PrintSObj.getClass())) {
            PcalFixIDs.FixPrintS((AST.PrintS)ast, context);
        } else if (ast.getClass().equals(AST.AssertObj.getClass())) {
            PcalFixIDs.FixAssert((AST.Assert)ast, context);
        } else if (ast.getClass().equals(AST.SkipObj.getClass())) {
            PcalFixIDs.FixSkip((AST.Skip)ast, context);
        } else if (ast.getClass().equals(AST.LabelIfObj.getClass())) {
            PcalFixIDs.FixLabelIf((AST.LabelIf)ast, context);
        } else if (ast.getClass().equals(AST.CallObj.getClass())) {
            PcalFixIDs.FixCall((AST.Call)ast, context);
        } else if (ast.getClass().equals(AST.ReturnObj.getClass())) {
            PcalFixIDs.FixReturn((AST.Return)ast, context);
        } else if (ast.getClass().equals(AST.CallReturnObj.getClass())) {
            PcalFixIDs.FixCallReturn((AST.CallReturn)ast, context);
        } else if (ast.getClass().equals(AST.CallGotoObj.getClass())) {
            PcalFixIDs.FixCallGoto((AST.CallGoto)ast, context);
        } else if (ast.getClass().equals(AST.GotoObj.getClass())) {
            PcalFixIDs.FixGoto((AST.Goto)ast, context);
        } else if (ast.getClass().equals(AST.EitherObj.getClass())) {
            PcalFixIDs.FixEither((AST.Either)ast, context);
        } else if (ast.getClass().equals(AST.LabelEitherObj.getClass())) {
            PcalFixIDs.FixLabelEither((AST.LabelEither)ast, context);
        } else {
            PcalDebug.ReportBug("Unexpected AST type" + ast.toString());
        }
    }

    private static void FixUniprocess(AST.Uniprocess ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.decls.size()) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
            ++i;
        }
        i = 0;
        while (i < ast.prcds.size()) {
            PcalFixIDs.FixProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
            ++i;
        }
        i = 0;
        while (i < ast.body.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), "");
            ++i;
        }
    }

    private static void FixMultiprocess(AST.Multiprocess ast, String context) throws PcalFixIDException {
        int j;
        Vector pCalled;
        int i = 0;
        while (i < ast.decls.size()) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
            ++i;
        }
        Vector<String> procedureNames = new Vector<String>();
        Vector<Vector> proceduresCalled = new Vector<Vector>();
        int i2 = 0;
        while (i2 < ast.prcds.size()) {
            AST.Procedure prcd = (AST.Procedure)ast.prcds.elementAt(i2);
            PcalFixIDs.FixProcedure(prcd, "");
            procedureNames.addElement(prcd.name);
            proceduresCalled.addElement(prcd.proceduresCalled);
            ++i2;
        }
        int n = procedureNames.size();
        boolean[][] path = new boolean[n][];
        int i3 = 0;
        while (i3 < n) {
            path[i3] = new boolean[n];
            int j2 = 0;
            while (j2 < n) {
                String nm = (String)procedureNames.elementAt(j2);
                path[i3][j2] = -1 != PcalFixIDs.nameToNum(nm, (Vector)proceduresCalled.elementAt(i3));
                ++j2;
            }
            ++i3;
        }
        int k = 0;
        while (k < n) {
            int i4 = 0;
            while (i4 < n) {
                int j3 = 0;
                while (j3 < n) {
                    path[i4][j3] = path[i4][j3] || path[i4][k] && path[k][j3];
                    ++j3;
                }
                ++i4;
            }
            ++k;
        }
        i3 = 0;
        while (i3 < ast.prcds.size()) {
            AST.Procedure prcd = (AST.Procedure)ast.prcds.elementAt(i3);
            pCalled = new Vector();
            j = 0;
            while (j < n) {
                if (path[i3][j]) {
                    pCalled.addElement(procedureNames.elementAt(j));
                }
                ++j;
            }
            prcd.proceduresCalled = pCalled;
            ++i3;
        }
        i3 = 0;
        while (i3 < ast.procs.size()) {
            AST.Process proc = (AST.Process)ast.procs.elementAt(i3);
            PcalFixIDs.FixProcess(proc, "");
            pCalled = proc.proceduresCalled;
            j = 0;
            while (j < pCalled.size()) {
                String pName = (String)pCalled.elementAt(j);
                int pNum = PcalFixIDs.nameToNum(pName, procedureNames);
                if (pNum == -1) {
                    PcalDebug.reportError("Could not find procedure name `" + pName + "'");
                    return;
                }
                int k2 = 0;
                while (k2 < n) {
                    String callee;
                    if (path[pNum][k2] && !PcalFixIDs.InVector(callee = (String)procedureNames.elementAt(k2), proc.proceduresCalled)) {
                        proc.proceduresCalled.addElement(callee);
                    }
                    ++k2;
                }
                ++j;
            }
            ++i3;
        }
    }

    private static int nameToNum(String nm, Vector names) {
        int i = 0;
        while (i < names.size()) {
            if (names.elementAt(i).equals(nm)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void FixProcedure(AST.Procedure ast, String context) throws PcalFixIDException {
        String newLbl;
        String lbl;
        int i = 0;
        while (i < ast.decls.size()) {
            PcalFixIDs.FixPVarDecl((AST.PVarDecl)ast.decls.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.params.size()) {
            PcalFixIDs.FixPVarDecl((AST.PVarDecl)ast.params.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.body.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name);
            ++i;
        }
        PcalSymTab.ProcedureEntry p = (PcalSymTab.ProcedureEntry)PcalFixIDs.st.procs.elementAt(st.FindProc(ast.name));
        int i2 = 0;
        while (i2 < ast.plusLabels.size()) {
            lbl = (String)ast.plusLabels.elementAt(i2);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.plusLabels.setElementAt(newLbl, i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < ast.minusLabels.size()) {
            lbl = (String)ast.minusLabels.elementAt(i2);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.minusLabels.setElementAt(newLbl, i2);
            ++i2;
        }
        p.iPC = st.UseThis(1, p.iPC, ast.name);
        p.name = ast.name = st.UseThis(2, ast.name, "");
    }

    private static void FixProcess(AST.Process ast, String context) throws PcalFixIDException {
        String newLbl;
        String lbl;
        int i = 0;
        while (i < ast.decls.size()) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.body.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name);
            ++i;
        }
        PcalSymTab.ProcessEntry p = (PcalSymTab.ProcessEntry)PcalFixIDs.st.processes.elementAt(st.FindProcess(ast.name));
        int i2 = 0;
        while (i2 < ast.plusLabels.size()) {
            lbl = (String)ast.plusLabels.elementAt(i2);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.plusLabels.setElementAt(newLbl, i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < ast.minusLabels.size()) {
            lbl = (String)ast.minusLabels.elementAt(i2);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.minusLabels.setElementAt(newLbl, i2);
            ++i2;
        }
        p.iPC = st.UseThis(1, p.iPC, ast.name);
        p.name = ast.name = st.UseThis(3, ast.name, "");
    }

    private static void FixVarDecl(AST.VarDecl ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.val, context);
    }

    private static void FixPVarDecl(AST.PVarDecl ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.val, context);
    }

    private static void FixLabeledStmt(AST.LabeledStmt ast, String context) throws PcalFixIDException {
        ast.label = st.UseThis(1, ast.label, context);
        int i = 0;
        while (i < ast.stmts.size()) {
            PcalFixIDs.FixSym((AST)ast.stmts.elementAt(i), context);
            ++i;
        }
    }

    private static void FixWhile(AST.While ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.unlabDo.size()) {
            PcalFixIDs.FixSym((AST)ast.unlabDo.elementAt(i), context);
            ++i;
        }
        i = 0;
        while (i < ast.labDo.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labDo.elementAt(i), context);
            ++i;
        }
        PcalFixIDs.FixExpr(ast.test, context);
    }

    private static void FixAssign(AST.Assign ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.ass.size()) {
            PcalFixIDs.FixSingleAssign((AST.SingleAssign)ast.ass.elementAt(i), context);
            ++i;
        }
    }

    private static void FixSingleAssign(AST.SingleAssign ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixLhs(ast.lhs, context);
        PcalFixIDs.FixExpr(ast.rhs, context);
    }

    private static void FixLhs(AST.Lhs ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.sub, context);
    }

    private static void FixIf(AST.If ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.Then.size()) {
            PcalFixIDs.FixSym((AST)ast.Then.elementAt(i), context);
            ++i;
        }
        i = 0;
        while (i < ast.Else.size()) {
            PcalFixIDs.FixSym((AST)ast.Else.elementAt(i), context);
            ++i;
        }
        PcalFixIDs.FixExpr(ast.test, context);
    }

    private static void FixWith(AST.With ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
        int i = 0;
        while (i < ast.Do.size()) {
            PcalFixIDs.FixSym((AST)ast.Do.elementAt(i), context);
            ++i;
        }
    }

    private static void FixWhen(AST.When ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixPrintS(AST.PrintS ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixAssert(AST.Assert ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixSkip(AST.Skip ast, String context) {
    }

    private static void FixLabelIf(AST.LabelIf ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.test, context);
        int i = 0;
        while (i < ast.unlabThen.size()) {
            PcalFixIDs.FixSym((AST)ast.unlabThen.elementAt(i), context);
            ++i;
        }
        i = 0;
        while (i < ast.labThen.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labThen.elementAt(i), context);
            ++i;
        }
        i = 0;
        while (i < ast.unlabElse.size()) {
            PcalFixIDs.FixSym((AST)ast.unlabElse.elementAt(i), context);
            ++i;
        }
        i = 0;
        while (i < ast.labElse.size()) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labElse.elementAt(i), context);
            ++i;
        }
    }

    private static void FixCall(AST.Call ast, String context) throws PcalFixIDException {
        ast.returnTo = st.UseThis(2, ast.returnTo, context);
        ast.to = st.UseThis(2, ast.to, context);
        int i = 0;
        while (i < ast.args.size()) {
            PcalFixIDs.FixExpr((TLAExpr)ast.args.elementAt(i), context);
            ++i;
        }
    }

    private static void FixReturn(AST.Return ast, String context) {
        ast.from = st.UseThis(2, ast.from, context);
    }

    private static void FixCallReturn(AST.CallReturn ast, String context) throws PcalFixIDException {
        ast.from = st.UseThis(2, ast.from, context);
        ast.to = st.UseThis(2, ast.to, context);
        int i = 0;
        while (i < ast.args.size()) {
            PcalFixIDs.FixExpr((TLAExpr)ast.args.elementAt(i), context);
            ++i;
        }
    }

    private static void FixCallGoto(AST.CallGoto ast, String context) throws PcalFixIDException {
        ast.after = st.UseThis(2, ast.after, context);
        ast.to = st.UseThis(2, ast.to, context);
        int i = 0;
        while (i < ast.args.size()) {
            PcalFixIDs.FixExpr((TLAExpr)ast.args.elementAt(i), context);
            ++i;
        }
    }

    private static void FixGoto(AST.Goto ast, String context) throws PcalFixIDException {
        if (st.FindSym(1, ast.to, context) == PcalFixIDs.st.symtab.size() && !ast.to.equals("Done")) {
            throw new PcalFixIDException("goto to non-existent label `" + ast.to + "' at line " + ast.line + ", column " + ast.col);
        }
        ast.to = st.UseThis(1, ast.to, context);
    }

    private static void FixEither(AST.Either ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.ors.size()) {
            Vector orClause = (Vector)ast.ors.elementAt(i);
            int j = 0;
            while (j < orClause.size()) {
                PcalFixIDs.FixSym((AST)orClause.elementAt(j), context);
                ++j;
            }
            ++i;
        }
    }

    private static void FixLabelEither(AST.LabelEither ast, String context) throws PcalFixIDException {
        int i = 0;
        while (i < ast.clauses.size()) {
            AST.Clause orClause = (AST.Clause)ast.clauses.elementAt(i);
            int j = 0;
            while (j < orClause.unlabOr.size()) {
                PcalFixIDs.FixSym((AST)orClause.unlabOr.elementAt(j), context);
                ++j;
            }
            j = 0;
            while (j < orClause.labOr.size()) {
                PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)orClause.labOr.elementAt(j), context);
                ++j;
            }
            ++i;
        }
    }

    private static void FixExpr(TLAExpr expr, String context) throws PcalFixIDException {
        Vector<TLAExpr> exprVec = new Vector<TLAExpr>();
        Vector<String> stringVec = new Vector<String>();
        Vector tokenVec = new Vector();
        int i = 0;
        while (i < expr.tokens.size()) {
            Vector tv = (Vector)expr.tokens.elementAt(i);
            String useMe = null;
            int j = 0;
            while (j < tv.size()) {
                int shift = 0;
                TLAToken tok = (TLAToken)tv.elementAt(j);
                tok.column += shift;
                if (tok.type == 4) {
                    useMe = st.UseThisVar(tok.string, context);
                    if (!PcalFixIDs.InVector(tok.string, stringVec) && !useMe.equals(tok.string)) {
                        stringVec.addElement(tok.string);
                        TLAExpr exp = new TLAExpr();
                        exp.addLine();
                        exp.addToken(new TLAToken(useMe, 0, 4));
                        exp.normalize();
                        exprVec.addElement(exp);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (exprVec.size() > 0) {
            try {
                expr.substituteForAll(exprVec, stringVec, false);
            }
            catch (TLAExprException e) {
                throw new PcalFixIDException(e.getMessage());
            }
        }
    }

    private static boolean InVector(String var, Vector v) {
        int i = 0;
        while (i < v.size()) {
            if (var.equals((String)v.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

