/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.BuiltInLevel;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import tlc2.tool.BuiltInOPs;
import util.UniqueString;
import util.WrongInvocationException;

public class OpDefNode
extends OpDefOrDeclNode
implements OpDefOrLabelNode,
AnyDefNode {
    private boolean local = false;
    private ExprNode body = null;
    private FormalParamNode[] params = null;
    private LevelNode stepNode = null;
    int letInLevel = -1;
    boolean inRecursive = false;
    boolean inRecursiveSection = false;
    int recursiveSection = -1;
    boolean isDefined = false;
    private Hashtable labels = null;
    private OpDefNode source = null;
    private UniqueString[] compoundID = null;
    int[] maxLevels;
    int[] weights;
    int[][] minMaxLevel;
    boolean[] isLeibnizArg;
    boolean isLeibniz;
    private boolean[][][] opLevelCond;

    public boolean getInRecursive() {
        return this.inRecursive;
    }

    public OpDefNode(UniqueString us) {
        super(us, 0, -2, null, null, SyntaxTreeNode.nullSTN);
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(UniqueString us, int k, int ar, FormalParamNode[] parms, boolean localness, ExprNode exp, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn) {
        super(us, k, parms == null ? -1 : parms.length, oModNode, symbolTable, stn);
        this.params = parms;
        if (this.arity >= 0) {
            int i = 0;
            while (i < this.params.length) {
                this.params[i] = new FormalParamNode(UniqueString.uniqueStringOf("Formal_" + i), 0, null, symbolTable, oModNode);
                ++i;
            }
        }
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
        this.isDefined = true;
    }

    public OpDefNode(UniqueString us, int k, FormalParamNode[] parms, boolean localness, ExprNode exp, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, boolean defined, OpDefNode src) {
        super(us, k, parms != null ? parms.length : 0, oModNode, symbolTable, stn);
        this.local = localness;
        this.params = parms != null ? parms : new FormalParamNode[]{};
        this.body = exp;
        this.isDefined = defined;
        this.source = src;
        this.maxLevels = new int[this.params.length];
        this.weights = new int[this.params.length];
        this.isLeibniz = true;
        this.isLeibnizArg = new boolean[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            this.maxLevels[i] = 3;
            this.weights[i] = 0;
            this.isLeibnizArg[i] = true;
            ++i;
        }
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(UniqueString us, int k, FormalParamNode[] parms, boolean localness, ExprNode exp, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, boolean defined, OpDefNode src, UniqueString[] compoundID) {
        this(us, k, parms, localness, exp, oModNode, symbolTable, stn, defined, src);
        this.compoundID = compoundID;
    }

    final UniqueString[] getCompoundId() {
        if (this.compoundID != null) {
            return this.compoundID;
        }
        return new UniqueString[]{this.getName()};
    }

    public final UniqueString getLocalName() {
        if (this.compoundID != null) {
            return this.compoundID[this.compoundID.length - 1];
        }
        return this.getName();
    }

    public final boolean hasPath() {
        if (this.compoundID != null) {
            return this.compoundID.length > 1;
        }
        return false;
    }

    public final UniqueString getPathName() {
        if (this.compoundID != null) {
            return UniqueString.join("!", this.compoundID.length - 1, this.compoundID);
        }
        return UniqueString.of("");
    }

    public OpDefNode(UniqueString us, FormalParamNode[] parms, boolean localness, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, OpDefNode src) {
        super(us, 6, parms == null ? -1 : parms.length, oModNode, symbolTable, stn);
        this.params = parms;
        this.local = localness;
        this.source = src;
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(UniqueString us, LevelNode step, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn) {
        super(us, 37, 0, oModNode, symbolTable, stn);
        this.stepNode = step;
        this.st.addSymbol(us, this);
    }

    @Override
    public final FormalParamNode[] getParams() {
        return this.params;
    }

    public final void setParams(FormalParamNode[] pms) {
        this.params = pms;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    public final void setBody(ExprNode body) {
        this.body = body;
    }

    @Override
    public final OpDefNode getSource() {
        return this.source == null ? this : this.source;
    }

    public final boolean hasSource() {
        return this.source != null;
    }

    @Override
    public final boolean isLocal() {
        return this.local;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    public final LevelNode getStepNode() {
        return this.stepNode;
    }

    private boolean matchingOpArgOperand(ExprOrOpArgNode arg, int i) {
        OpArgNode argOpArg;
        boolean result;
        boolean bl = result = arg instanceof OpArgNode && this.params[i].getArity() == ((OpArgNode)arg).getArity();
        if (result && (argOpArg = (OpArgNode)arg).getOp() instanceof OpDefNode) {
            OpDefNode opdefArg = (OpDefNode)argOpArg.getOp();
            int j = 0;
            while (j < opdefArg.getArity()) {
                if (opdefArg.getParams()[j].getArity() > 0) {
                    result = false;
                }
                ++j;
            }
        }
        return result;
    }

    private boolean errReport(Location loc, String s) {
        errors.addError(loc, s);
        return false;
    }

    @Override
    public final boolean match(OpApplNode oanParent, ModuleNode mn) throws AbortException {
        Location loc;
        ExprOrOpArgNode[] args = oanParent.getArgs();
        boolean result = true;
        boolean tempResult = true;
        Location location = loc = oanParent.getTreeNode() != null ? oanParent.getTreeNode().getLocation() : null;
        if (this.getKind() == 6) {
            errors.addError(loc, "Module instance identifier where operator should be.");
            result = false;
        } else if (this.arity == -1) {
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    if (args[i] instanceof OpArgNode) {
                        errors.addError(loc, "Illegal expression used as argument " + (i + 1) + " to operator '" + this.getName() + "'.");
                        result = false;
                    }
                    ++i;
                }
            } else {
                errors.addAbort(loc, "Internal error: null args vector for operator '" + this.getName() + "' that should take variable number of args.", true);
            }
        } else if (args == null | this.params == null) {
            errors.addAbort(loc, "Internal error: Null args or params vector for operator '" + this.getName() + "'.", true);
        } else if (this.params.length != args.length) {
            errors.addError(loc, "Wrong number of arguments (" + args.length + ") given to operator '" + this.getName() + "', \nwhich requires " + this.params.length + " arguments.");
            result = false;
        } else if (this.getKind() == 7) {
            int i = 0;
            while (i < this.params.length) {
                if (args[i] instanceof OpArgNode) {
                    errors.addError(loc, "Non-expression used as argument number " + (i + 1) + " to BuiltIn operator '" + this.getName() + "'.");
                    result = false;
                }
                ++i;
            }
        } else if (this.getKind() == 5) {
            int i = 0;
            while (i < this.params.length) {
                if (this.params[i].getArity() == 0) {
                    if (args[i] instanceof OpArgNode) {
                        errors.addError(loc, "Operator used in argument number " + (i + 1) + " has incorrect number of arguments.");
                        result = false;
                    }
                } else if (this.params[i].getArity() > 0) {
                    if (!this.matchingOpArgOperand(args[i], i)) {
                        errors.addError(loc, "Argument number " + (i + 1) + " to operator '" + this.getName() + "' \nshould be a " + this.params[i].getArity() + "-parameter operator.");
                        result = false;
                    }
                } else {
                    errors.addError(loc, "Internal error: Operator '" + this.getName() + "' indicates that it requires \na negative number of arguments.");
                }
                ++i;
            }
        } else {
            errors.addAbort(Location.nullLoc, "Internal error: operator neither BuiltIn nor UserDefined \nin call to OpDefNode.match()", true);
        }
        return result;
    }

    public void setLabels(Hashtable ht) {
        this.labels = ht;
    }

    @Override
    public LabelNode getLabel(UniqueString us) {
        if (this.labels == null) {
            return null;
        }
        return (LabelNode)this.labels.get(us);
    }

    @Override
    public boolean addLabel(LabelNode odn) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (this.labels.containsKey(odn)) {
            return false;
        }
        this.labels.put(odn.getName(), odn);
        return true;
    }

    @Override
    public LabelNode[] getLabels() {
        if (this.labels == null) {
            return new LabelNode[0];
        }
        Vector v = new Vector();
        Enumeration e = this.labels.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        LabelNode[] retVal = new LabelNode[v.size()];
        int i = 0;
        while (i < v.size()) {
            retVal[i] = (LabelNode)v.elementAt(i);
            ++i;
        }
        return retVal;
    }

    public Hashtable getLabelsHT() {
        return this.labels;
    }

    @Override
    public boolean[] getIsLeibnizArg() {
        return this.isLeibnizArg;
    }

    @Override
    public boolean getIsLeibniz() {
        return this.isLeibniz;
    }

    public final void setBuiltinLevel(BuiltInLevel.Data d) {
        if (d.arity == -1) {
            if (d.argMaxLevels.length > 0) {
                this.maxLevels = new int[1];
                this.maxLevels[0] = d.argMaxLevels[0];
                this.weights = new int[1];
                this.weights[0] = d.argWeights[0];
            } else {
                this.maxLevels = new int[0];
                this.weights = new int[0];
            }
        } else {
            this.maxLevels = d.argMaxLevels;
            this.weights = d.argWeights;
        }
        this.isLeibniz = true;
        this.isLeibnizArg = new boolean[d.argWeights.length];
        int i = 0;
        while (i < d.argWeights.length) {
            this.isLeibnizArg[i] = d.argWeights[i] > 0;
            this.isLeibniz = this.isLeibniz && this.isLeibnizArg[i];
            ++i;
        }
        this.level = d.opLevel;
        this.levelChecked = 99;
    }

    @Override
    public final boolean levelCheck(int itr) {
        int j;
        if (this.levelChecked >= itr || !this.inRecursiveSection && this.levelChecked > 0) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        if (this.getKind() == 37) {
            LevelNode[] subs = new LevelNode[]{this.stepNode};
            this.levelCorrect = this.stepNode.levelCheck(itr);
            return this.levelCheckSubnodes(itr, subs);
        }
        this.levelCorrect = this.body.levelCheck(itr);
        this.level = Math.max(this.level, this.body.getLevel());
        SetOfLevelConstraints lcSet = this.body.getLevelConstraints();
        int i = 0;
        while (i < this.params.length) {
            Object plevel = lcSet.get(this.params[i]);
            if (plevel != null) {
                this.maxLevels[i] = Math.min(this.maxLevels[i], (Integer)plevel);
            }
            ++i;
        }
        i = 0;
        while (i < this.params.length) {
            if (this.body.getLevelParams().contains(this.params[i])) {
                this.weights[i] = Math.max(this.weights[i], 1);
            }
            ++i;
        }
        this.minMaxLevel = new int[this.params.length][];
        SetOfArgLevelConstraints alcSet = this.body.getArgLevelConstraints();
        int i2 = 0;
        while (i2 < this.params.length) {
            int alen = this.params[i2].getArity();
            this.minMaxLevel[i2] = new int[alen];
            j = 0;
            while (j < alen) {
                Object alevel = alcSet.get(new ParamAndPosition(this.params[i2], j));
                this.minMaxLevel[i2][j] = alevel == null ? 0 : (Integer)alevel;
                ++j;
            }
            ++i2;
        }
        this.opLevelCond = new boolean[this.params.length][this.params.length][];
        HashSet<ArgLevelParam> alpSet = this.body.getArgLevelParams();
        int i3 = 0;
        while (i3 < this.params.length) {
            j = 0;
            while (j < this.params.length) {
                this.opLevelCond[i3][j] = new boolean[this.params[i3].getArity()];
                int k = 0;
                while (k < this.params[i3].getArity()) {
                    ArgLevelParam alp = new ArgLevelParam(this.params[i3], k, this.params[j]);
                    this.opLevelCond[i3][j][k] = alpSet.contains(alp);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        this.levelParams.addAll(this.body.getLevelParams());
        this.allParams.addAll(this.body.getAllParams());
        this.nonLeibnizParams.addAll(this.body.getNonLeibnizParams());
        i3 = 0;
        while (i3 < this.params.length) {
            this.levelParams.remove(this.params[i3]);
            this.allParams.remove(this.params[i3]);
            if (this.nonLeibnizParams.contains(this.params[i3])) {
                this.nonLeibnizParams.remove(this.params[i3]);
                this.isLeibnizArg[i3] = false;
                this.isLeibniz = false;
            }
            ++i3;
        }
        this.levelConstraints = (SetOfLevelConstraints)lcSet.clone();
        i3 = 0;
        while (i3 < this.params.length) {
            this.levelConstraints.remove(this.params[i3]);
            ++i3;
        }
        this.argLevelConstraints = (SetOfArgLevelConstraints)alcSet.clone();
        i3 = 0;
        while (i3 < this.params.length) {
            int alen = this.params[i3].getArity();
            int j2 = 0;
            while (j2 < alen) {
                this.argLevelConstraints.remove(new ParamAndPosition(this.params[i3], j2));
                ++j2;
            }
            ++i3;
        }
        for (ArgLevelParam alp : alpSet) {
            if (alp.op.occur(this.params) && alp.param.occur(this.params)) continue;
            this.argLevelParams.add(alp);
        }
        return this.levelCorrect;
    }

    @Override
    public final int getMaxLevel(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMaxLevel called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.maxLevels[idx];
    }

    @Override
    public final int getWeight(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getWeight called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.weights[idx];
    }

    @Override
    public final int getMinMaxLevel(int i, int j) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMinMaxLevel called before levelCheck");
        }
        if (this.minMaxLevel == null) {
            return 0;
        }
        return this.minMaxLevel[i][j];
    }

    @Override
    public final boolean getOpLevelCond(int i, int j, int k) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getOpLevelCond called before levelCheck");
        }
        if (this.opLevelCond == null) {
            return false;
        }
        return this.opLevelCond[i][j][k];
    }

    @Override
    public final String levelDataToString() {
        if (this.getKind() == 6 || this.getKind() == 37) {
            return "";
        }
        if (this.arity < 0) {
            return "Arity: " + this.arity + "\n" + "Level: " + this.getLevel() + "\n" + "MaxLevel: " + this.maxLevels[0] + "\n";
        }
        String maxLevelStr = "";
        int i = 0;
        while (i < this.maxLevels.length) {
            if (i > 0) {
                maxLevelStr = String.valueOf(maxLevelStr) + ", ";
            }
            maxLevelStr = String.valueOf(maxLevelStr) + this.maxLevels[i];
            ++i;
        }
        String isLeibnizArgStr = "";
        int i2 = 0;
        while (i2 < this.isLeibnizArg.length) {
            if (i2 > 0) {
                isLeibnizArgStr = String.valueOf(isLeibnizArgStr) + ", ";
            }
            isLeibnizArgStr = String.valueOf(isLeibnizArgStr) + this.isLeibnizArg[i2];
            ++i2;
        }
        String opLevelCondStr = "";
        if (this.opLevelCond != null) {
            opLevelCondStr = "[";
            int i3 = 0;
            while (i3 < this.opLevelCond.length) {
                opLevelCondStr = String.valueOf(opLevelCondStr) + " [";
                int j = 0;
                while (j < this.opLevelCond[i3].length) {
                    opLevelCondStr = String.valueOf(opLevelCondStr) + " [";
                    int k = 0;
                    while (k < this.opLevelCond[i3][j].length) {
                        String foo = " ";
                        if (k == 0) {
                            foo = "";
                        }
                        opLevelCondStr = String.valueOf(opLevelCondStr) + foo + this.opLevelCond[i3][j][k];
                        ++k;
                    }
                    opLevelCondStr = String.valueOf(opLevelCondStr) + "]";
                    ++j;
                }
                opLevelCondStr = String.valueOf(opLevelCondStr) + "]";
                ++i3;
            }
            opLevelCondStr = String.valueOf(opLevelCondStr) + "]";
        }
        return "Arity: " + this.arity + "\n" + "Level: " + this.getLevel() + "\n" + "LevelParams: " + this.getLevelParams() + "\n" + "LevelConstraints: " + this.getLevelConstraints() + "\n" + "ArgLevelConstraints: " + this.getArgLevelConstraints() + "\n" + "ArgLevelParams: " + OpDefNode.ALPHashSetToString(this.getArgLevelParams()) + "\n" + "MaxLevel: " + maxLevelStr + "\n" + "opLevelCond: " + opLevelCondStr + "\n" + "AllParams: " + OpDefNode.HashSetToString(this.getAllParams()) + "\n" + "NonLeibnizParams: " + OpDefNode.HashSetToString(this.getNonLeibnizParams()) + "\n" + "IsLeibniz: " + this.isLeibniz + "\n" + "isLeibnizArg: " + isLeibnizArgStr + "\n";
    }

    public boolean hasOpcode(int opCode) {
        return opCode == BuiltInOPs.getOpCode(this.getName());
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.body};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.params != null && this.params.length > 0) {
            int i = 0;
            while (i < this.params.length) {
                if (this.params[i] != null) {
                    this.params[i].walkGraph(semNodesTable, visitor);
                }
                ++i;
            }
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        if (this.stepNode != null) {
            this.stepNode.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public String getSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName().toString());
        if (this.getArity() > 0 && this.getKind() != 7) {
            buf.append("(");
            FormalParamNode[] params = this.getParams();
            int i = 0;
            while (i < params.length - 1) {
                FormalParamNode formalParamNode = params[i];
                if (formalParamNode.getTreeNode() != null) {
                    SyntaxTreeNode treeNode = (SyntaxTreeNode)formalParamNode.getTreeNode();
                    buf.append(treeNode.getHumanReadableImage());
                    buf.append(", ");
                }
                ++i;
            }
            if (params[params.length - 1].getTreeNode() != null) {
                TreeNode treeNode = params[params.length - 1].getTreeNode();
                buf.append(treeNode.getHumanReadableImage());
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*OpDefNode: " + this.getName().toString() + "\n  " + super.toString(depth) + "\n  local: " + this.local + "\n  letInLevel: " + this.letInLevel + "\n  inRecursive: " + this.inRecursive + "\n  inRecursiveSection: " + this.inRecursiveSection + "\n  recursiveSection: " + this.recursiveSection + "\n  local: " + this.local + "\n  source: " + (this.source == null ? "this" : String.valueOf(this.source.getName().toString()) + " (uid: " + this.source.myUID + ")") + "\n  originallyDefinedInModule: " + (this.originallyDefinedInModule == null ? "null" : String.valueOf(this.originallyDefinedInModule.getName().toString()) + " (uid: " + this.originallyDefinedInModule.myUID + ")") + (this.stepNode == null ? "" : "\n  stepNode: " + Strings.indent(4, this.stepNode.toString(depth - 3)));
        if (this.params != null) {
            String tempString = "\n  Formal params: " + this.params.length;
            int i = 0;
            while (i < this.params.length) {
                tempString = String.valueOf(tempString) + Strings.indent(4, this.params[i] != null ? this.params[i].toString(depth - 1) : "\nnull");
                ++i;
            }
            ret = String.valueOf(ret) + tempString;
        } else {
            ret = String.valueOf(ret) + Strings.indent(2, "\nFormal params: null");
        }
        if (depth > 1) {
            ret = this.st != null ? String.valueOf(ret) + "\n  SymbolTable: non-null" : String.valueOf(ret) + "\n  SymbolTable: null";
        }
        ret = this.body != null ? String.valueOf(ret) + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body.toString(depth - 1))) : String.valueOf(ret) + Strings.indent(2, "\nBody: null");
        if (this.labels != null) {
            ret = String.valueOf(ret) + "\n  Labels: ";
            Enumeration list = this.labels.keys();
            while (list.hasMoreElements()) {
                ret = String.valueOf(ret) + ((UniqueString)list.nextElement()).toString() + "  ";
            }
        } else {
            ret = String.valueOf(ret) + "\n  Labels: null";
        }
        return ret;
    }

    @Override
    public String getHumanReadableImage() {
        String comment = this.getComment();
        StringBuffer buf = new StringBuffer(comment);
        buf.append("\n");
        TreeNode[] ones = this.getTreeNode().one();
        if (ones != null) {
            TreeNode[] treeNodeArray = ones;
            int n = ones.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode = treeNodeArray[n2];
                buf.append(treeNode.getHumanReadableImage());
                buf.append(" ");
                ++n2;
            }
        } else {
            buf.append(this.toString());
        }
        return buf.toString().trim();
    }

    @Override
    protected String getNodeRef() {
        switch (this.getKind()) {
            case 5: {
                return "UserDefinedOpKindRef";
            }
            case 7: {
                return "BuiltInKindRef";
            }
            case 6: {
                return "ModuleInstanceKindRef";
            }
        }
        throw new IllegalArgumentException("unsupported kind: " + this.getKind() + " in xml export");
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context) {
        Element ret = null;
        switch (this.getKind()) {
            case 5: {
                ret = doc.createElement("UserDefinedOpKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                ret.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
                ret.appendChild(this.appendElement(doc, "body", this.body.export(doc, context)));
                if (this.params != null) {
                    Element arguments = doc.createElement("params");
                    int i = 0;
                    while (i < this.params.length) {
                        Element lp = doc.createElement("leibnizparam");
                        lp.appendChild(this.params[i].export(doc, context));
                        if (this.isLeibnizArg != null && this.isLeibnizArg[i]) {
                            lp.appendChild(doc.createElement("leibniz"));
                        }
                        arguments.appendChild(lp);
                        ++i;
                    }
                    ret.appendChild(arguments);
                }
                if (!this.inRecursive) break;
                ret.appendChild(doc.createElement("recursive"));
                break;
            }
            case 7: {
                ret = doc.createElement("BuiltInKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                ret.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
                Element arguments2 = doc.createElement("params");
                if (this.params == null) break;
                int i = 0;
                while (i < this.params.length) {
                    Element lp = doc.createElement("leibnizparam");
                    lp.appendChild(this.params[i].export(doc, context));
                    if (this.isLeibnizArg != null && this.isLeibnizArg[i]) {
                        lp.appendChild(doc.createElement("leibniz"));
                    }
                    arguments2.appendChild(lp);
                    ++i;
                }
                ret.appendChild(arguments2);
                break;
            }
            case 6: {
                ret = doc.createElement("ModuleInstanceKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported kind: " + this.getKind() + " in xml export");
            }
        }
        return ret;
    }
}

